# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
from PyQt4 import QtCore
from PyQt4 import QtGui
from qgis.core import *
# import the code for the dialog
from ui_quadratTest import Ui_quadratTestDialog
#handling outputFile: path name, file name and extension
import os
# run R code
import quadrattestRpart
# write to logFile.log
import wl
# dialog for open help file and R code 
import sda4ppDisplayHelpFile
# reading qgis layer
import sda4ppReadQGISLayer
# R options
import sda4ppRoptions

class QuadrattestTool(QtGui.QDialog, Ui_quadratTestDialog):
  def __init__(self, iface):
    QtGui.QDialog.__init__(self)
    # save reference to the QGIS interface
    self.iface = iface
    # Set up the user interface from Designer.
    self.setupUi(self)
    self.setFixedSize(self.size())
    # init variables
    self.index = {"fitModel":False,"inputFilePath":"","inputFileName":"",
                  "plot":True, "save":False, "xDiv":4, "yDiv":4, "opt":False,
                  "outputFilePath":"", "outputFileName":"", "projText":""}
    # read the name of qgis layer
    self.readInputFile()
    self.progressBar.setValue(0)
    QtCore.QObject.connect(self.cmbPointLayer,
        QtCore.SIGNAL("activated(QString )"), self.cmbPointLayer_changed)
    QtCore.QObject.connect(self.btnApply,
        QtCore.SIGNAL("clicked()"), self.runApply)
    QtCore.QObject.connect(self.btnHelp,
        QtCore.SIGNAL("clicked()"), self.runHelp)
    QtCore.QObject.connect(self.btnCancel,
        QtCore.SIGNAL("clicked()"), self.runClose)
    QtCore.QObject.connect(self.chkFitModel,
        QtCore.SIGNAL("clicked()"), self.chkFitModel_changed)
    QtCore.QObject.connect(self.chkOptSize,
        QtCore.SIGNAL("clicked()"), self.chkOptSize_changed)
    QtCore.QObject.connect(self.chkPlot,
        QtCore.SIGNAL("clicked()"), self.chkPlot_changed)
    QtCore.QObject.connect(self.chkSave,
        QtCore.SIGNAL("clicked()"), self.chkSave_changed)
    QtCore.QObject.connect(self.btnSave,
        QtCore.SIGNAL("clicked()"), self.btnSave_changed)

  def runHelp(self):
    sda4ppDisplayHelpFile.DisplayHelpFile("QuadratTest")

  def runClose(self):
    sda4ppRoptions.closeRplot(self.R)
    self.reject()

  def getUniqueOutputFileName(self, file=""):
    notFileExist = 0
    counter = 0
    if file == "":
      file = self.ReadPointLayer.createOutputDir() + "quadrattest"
    while (notFileExist == 0):
      outputFilename = file + "_" + str(counter) + ".shp"
      if not(os.path.exists(outputFilename)):
        self.index["outputFilePath"] = outputFilename
        self.txtPath.setText(outputFilename)
        layerSource = QtCore.QFileInfo(outputFilename)
        self.index["outputFileName"] = str(layerSource.completeBaseName())
        notFileExist = 1
      else:
        counter = counter + 1

  def changeExtension(self):
    if self.index["outputFilePath"] != "":
      f = QtCore.QFileInfo(self.index["outputFilePath"])
      if f.suffix() != "shp":
        self.index["outputFilePath"] = f.path() + "/" + \
                                   f.completeBaseName() + ".shp"
      if not(os.path.exists(self.index["outputFilePath"])):
        self.txtPath.setText(self.index["outputFilePath"])
        self.index["outputFileName"] = str(f.completeBaseName())
      else:
        file =f.path() + "/" + f.completeBaseName()
        self.getUniqueOutputFileName(file)

  def btnSave_changed(self):
    (self.index["outputFilePath"], foo) = self.ReadPointLayer.saveDialog(self)
    if self.index["outputFilePath"] is None:
      self.index["outputFilePath"] = str(self.txtPath.text())
      return
    self.changeExtension()

  def chkSave_changed(self):
    dt = "quadrattest-chkSave_changed"
    if self.chkSave.checkState() == 2:
      self.btnSave.setEnabled(True)
      self.txtPath.setEnabled(True)
      self.index["save"] = True
      self.getUniqueOutputFileName()
    elif self.chkSave.checkState() == 0:
      self.btnSave.setEnabled(False)
      self.txtPath.setEnabled(False)
      self.txtPath.clear()
      self.index["save"] = False
    wl.wl("index: " + str(self.index),dt)

  def chkPlot_changed(self):
    dt = "quadrattest-chkPlot_changed"
    if self.chkPlot.checkState() == 2:
      self.index["plot"] = True
    elif self.chkPlot.checkState() == 0:
      self.index["plot"] = False
    wl.wl("index: " + str(self.index),dt)

  def chkFitModel_changed(self):
    if self.chkFitModel.checkState() == 2:
      self.index["fitModel"] = True
    elif self.chkFitModel.checkState() == 0:
      self.index["fitModel"] = False

  def chkOptSize_changed(self):
    if self.chkOptSize.checkState() == 2:
      self.index["option"] = True
      # apply analysis part to R
      (quadratX, quadratY)= quadrattestRpart.doSpatialAnalysis(self.R, self.index)
      self.txtXaxis.setText(str(quadratX))
      self.txtYaxis.setText(str(quadratY))
      self.txtXaxis.setEnabled(False)
      self.txtYaxis.setEnabled(False)
    else:
      self.index["option"] = False
      self.txtXaxis.setText("4")
      self.txtYaxis.setText("4")
      self.txtXaxis.setEnabled(True)
      self.txtYaxis.setEnabled(True)

  def cmbPointLayer_changed(self):
    dt = "quadrattest-cmbPointLayer_changed"
    #update source of layer
    (self.index["inputFilePath"], self.index["inputFileName"]) = \
                     self.ReadPointLayer.getFileSource (\
                         self.cmbPointLayer.currentText())
    # get projection
    self.index["projText"] = self.ReadPointLayer.getProj()
    wl.wl("index: " +str(self.index),dt)
    # readOGR
    error = sda4ppRoptions.readOGR(self.R,self.index["inputFilePath"],self.index["inputFileName"])
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return

  def readInputFile(self):
    dt = "quadrattest-readInputFile"
    # init rpy2
    import rpy2.robjects as robjects
    self.R = robjects.r
    # SECTION: POINT
    self.ReadPointLayer = sda4ppReadQGISLayer.ReadQgisLayer(self.iface)
    layers = self.ReadPointLayer.getLayerList()
    wl.wl("layers: " +str(layers),dt)
    if layers == []:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "Please add point typed vector layers in QGIS.")
      return
    for layer in layers:
      self.cmbPointLayer.addItem(layer)
    # inputFile
    (self.index["inputFilePath"], self.index["inputFileName"]) = \
                     self.ReadPointLayer.getFileSource (\
                         self.cmbPointLayer.currentText())
    # get projection
    self.index["projText"] = self.ReadPointLayer.getProj()
    # readOGR
    error = sda4ppRoptions.readOGR(self.R,self.index["inputFilePath"],self.index["inputFileName"])
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return
    wl.wl("index: " +str(self.index),dt)
    return

  def runApply(self):
    dt = "quadrattest-runApply"
    self.progressBar.setValue(5)
    #BEGIN SECTION: inputFile
    if self.cmbPointLayer.currentIndex() == -1:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "Please add point typed vector layer in QGIS.")
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(10)
    # could not save postgis layer as shp file
    if self.index["inputFilePath"] == 'error':
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", self.fileBaseName)
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(15)
    # the number of quadrats in x axis
    textX = str(self.txtXaxis.text())
    (value_x, errorText) = wl.readIntTxtBox(textX)
    if value_x == "error":
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", errorText)
      self.progressBar.setValue(0)
      return
    self.index["xDiv"] = value_x
    wl.wl("user's number of quadrats in x axis: " +str(value_x),dt)
    self.progressBar.setValue(20)
    # the number of quadrats in y axis
    textY = str(self.txtYaxis.text())
    (value_y, errorText) = wl.readIntTxtBox(textY)
    if value_y == "error":
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", errorText)
      self.progressBar.setValue(0)
      return
    self.index["yDiv"] = value_y
    wl.wl("user's number of quadrats in y axis: " +str(value_y),dt)
    self.progressBar.setValue(25)
    #BEGIN SECTION: R part
    self.btnApply.setEnabled(False)
    self.index["option"] = False
    wl.wl("index: " +str(self.index),dt)
    # apply analysis part to R
    lstResult = quadrattestRpart.doSpatialAnalysis(self.R, self.index)
    wl.wl("lstResult: " +str(lstResult),dt)
    self.progressBar.setValue(100)
    # formating output
    txtRes = ""
    for i in range(len(lstResult)):
      txtRes += str(lstResult[i]) + "\n"
    wl.wl("txtRes: " +str(txtRes),dt)
    self.lblResult.setText(str(txtRes))
    self.btnApply.setEnabled(True)
    # save
    if self.index["save"]:
      resSave = self.ReadPointLayer.saveShape(self.index["outputFilePath"])
      if resSave == "error":
        self.progressBar.setValue(0)
        return
      self.getUniqueOutputFileName()
    self.progressBar.setValue(0)
