# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
from PyQt4 import QtCore
from PyQt4 import QtGui
from qgis.core import *
# import the code for the dialog
from ui_localKL import Ui_localKLDialog
#handling outputFile: path name, file name and extension
import os
# run R code
import localKLRpart
# write to logFile.log
import wl
# dialog for open help file
import sda4ppDisplayHelpFile
# reading qgis layer
import sda4ppReadQGISLayer
# R options
import sda4ppRoptions

class LocalKLTool(QtGui.QDialog, Ui_localKLDialog):
  def __init__(self, iface):
    QtGui.QDialog.__init__(self)
    # save reference to the QGIS interface
    self.iface = iface
    # Set up the user interface from Designer.
    self.setupUi(self)
    self.setFixedSize(self.size())
    ## init variables
    # tool = localK | localL
    # edge = none | translate | Ripley | isotropic
    # plotType = plotAll | plotId
    # plotId = 0 | id of point number
    # plotIdCount = 0 | total number of feature in the spatial data
    self.index = {"inputFile":"", "fileBaseName":"",
                  "tool":"localK", "edge":"none","plotType":"plotAll",
                  "plotId":"0","plotIdCount":"0"}
    # read the name of qgis layer
    self.readInputFile()
    self.progressBar.setValue(0)
    QtCore.QObject.connect(self.cmbPointLayer,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbPointLayer_changed)
    QtCore.QObject.connect(self.cmbLocalKL,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbLocalKL_changed)
    QtCore.QObject.connect(self.cmbEdge,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbEdge_changed)
    QtCore.QObject.connect(self.cmbPointId,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbPointId_changed)
    QtCore.QObject.connect(self.btnApply, QtCore.SIGNAL("clicked()"),
                           self.runApply)
    QtCore.QObject.connect(self.btnHelp, QtCore.SIGNAL("clicked()"),
                           self.runHelp)
    QtCore.QObject.connect(self.rbPlotAll, QtCore.SIGNAL("clicked()"),
                           self.rbPlotAll_changed)
    QtCore.QObject.connect(self.rbPlotId, QtCore.SIGNAL("clicked()"),
                           self.rbPlotId_changed)
    QtCore.QObject.connect(self.btnCancel, QtCore.SIGNAL("clicked()"),
                           self.runClose)

  def runClose(self):
    sda4ppRoptions.closeRplot(self.R)
    self.reject()

  def runHelp(self):
    sda4ppDisplayHelpFile.DisplayHelpFile("localKL")

  def rbPlotAll_changed(self):
    dt = "localKL-rbPlotAll_changed"
    self.index["plotType"] = "plotAll"
    wl.wl("index: " +str(self.index),dt)
    self.cmbPointId.setEnabled(False)

  def rbPlotId_changed(self):
    dt = "localKL-rbPlotId_changed"
    for i in range(int(self.index["plotIdCount"])):
      self.cmbPointId.addItem(str(i))
    self.index["plotType"] = "plotId"
    wl.wl("index: " +str(self.index),dt)
    self.cmbPointId.setEnabled(True)

  def cmbPointId_changed(self):
    dt = "localKL-cmbPointId_changed"
    self.index["plotId"] = self.cmbPointId.currentIndex()
    wl.wl("index: " +str(self.index),dt)

  def cmbPointLayer_changed(self):
    dt = "localKL-cmbPointLayer_changed"
    #update source of layer
    (self.index["inputFilePath"], self.index["inputFileName"]) = \
       self.ReadPointLayer.getFileSource (self.cmbPointLayer.currentText())
    wl.wl("index: " + str(self.index),dt)
    # readOGR
    error = sda4ppRoptions.readOGR(self.R,self.index["inputFilePath"],self.index["inputFileName"])
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return

  def cmbLocalKL_changed(self):
    dt = "localKL-cmbLocalKL_changed"
    if self.cmbLocalKL.currentIndex() == 0:
      self.index["tool"] = "localK"
    elif self.cmbLocalKL.currentIndex() == 1:
      self.index["tool"] = "localL"
    wl.wl("index: " +str(self.index),dt)

  def cmbEdge_changed(self):
    dt = "localKL-cmbEdge_changed"
    if self.cmbEdge.currentIndex() == 0:
      self.index["edge"] = "none"
    elif self.cmbEdge.currentIndex() == 1:
      self.index["edge"] = "translate"
    elif self.cmbEdge.currentIndex() == 2:
      self.index["edge"] = "Ripley"
    elif self.cmbEdge.currentIndex() == 3:
      self.index["edge"] = "isotropic"
    wl.wl("index: " +str(self.index),dt)

  def readInputFile(self):
    dt = "localKL-readInputFile"
    # init rpy2
    import rpy2.robjects as robjects
    self.R = robjects.r
    # SECTION: point
    self.ReadPointLayer = sda4ppReadQGISLayer.ReadQgisLayer(self.iface)
    layers = self.ReadPointLayer.getLayerList()
    wl.wl("layers: " +str(layers),dt)
    if layers == []:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "Please add point typed vector layers in QGIS.")
      return
    for layer in layers:
      self.cmbPointLayer.addItem(layer)
    # inputFile
    (self.index["inputFilePath"], self.index["inputFileName"]) = \
       self.ReadPointLayer.getFileSource (self.cmbPointLayer.currentText())
    # the number of feature
    self.index["plotIdCount"] = self.ReadPointLayer.getFeatureCount()
    # readOGR
    error = sda4ppRoptions.readOGR(self.R,self.index["inputFilePath"],self.index["inputFileName"])
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return
    wl.wl("index: " +str(self.index),dt)
    return

  def resetWidgets(self):
    self.rbPlotAll.setEnabled(False)
    self.rbPlotId.setEnabled(False)

  def runApply(self):
    dt = "localKL-runApply"
    self.progressBar.setValue(5)
    #BEGIN SECTION: inputFile
    if self.cmbPointLayer.currentIndex() == -1:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "Please add point typed vector layer in QGIS.")
      self.progressBar.setValue(0)
      self.resetWidgets()
      return
    self.progressBar.setValue(10)
    # could not save postgis layer as shp file
    if self.index["inputFilePath"] == 'error':
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", self.index["inputFileName"])
      self.progressBar.setValue(0)
      self.resetWidgets()
      return
    #BEGIN SECTION: R part
    self.progressBar.setValue(100)
    self.btnApply.setEnabled(False)
    wl.wl("index: " +str(self.index),dt)
    # apply analysis part to R
    localKLRpart.doSpatialAnalysis(self.R, self.index)
    self.btnApply.setEnabled(True)
    self.progressBar.setValue(0)
