# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
# R options
import sda4ppRoptions
# write to logFile.log
import wl
import string

def doSingleAnalysis (r, index):
  dt="iplotRpart-doSingleAnalysis"
  # TODO: although rJava package can be loaded in r-cran,
  #       but not while calling with rpy2, 
  #       error is related with rJava in Linux, but not in Win.
  #r.library("rJava")
  #r.library("iplots")
  #r("library('rJava')")
  #r("library('iplots')")
  s = r("df_point <- as.data.frame(v_spdf)")
  s = r("attach(df_point)")
  wl.wl("data frame of point is attached: ",dt)
  # plot type
  if index["Hist"] == 2:
    s = r("ihist(" + str(index["SingleX"]) + ")")
    wl.wl("ihist is executed: "+str(s),dt)
  if index["Coord"] == 2:
    s = r("ipcp(df_point)")
    wl.wl("ipcp is executed: "+str(s),dt)
  if index["Parallel"] == 2:
    s = r("ibox(" + str(index["SingleX"]) + ")")
    wl.wl("ibox is executed: "+str(s),dt)
  if index["Bar"] == 2:
    s = r("ibar(" + str(index["SingleX"]) + ")")
    wl.wl("ibar is executed: "+str(s),dt)
  # linking option
  if index["Linking"] == 2:
    s = r("d <- iplot.data()")
    wl.wl("iplot.data is read: "+str(s),dt)
    r("while (!is.null(ievent.wait())){if(iset.sel.changed()){res <-iset.selected()}}")
    res = r("res")
    wl.wl("event is processed: "+str(res),dt)
    # convert RVectorList to python list
    pyList = []
    for i in range(len(res)):
      pyList.append(int(res[i])-1)
    wl.wl("pyList: "+str(pyList),dt)
  # defining color option
  if index["OptionColorField"] != "":
    s = r("iplot.opt(col=" + str(index["OptionColorField"]) + ")")
    wl.wl("color option is executed: "+str(s),dt)
  # selection option
  if index["OptionSelection"] != 0:
    s = r("df_point[\"temp\"] <- factor(c(" + str(index["OptionSelection"]) + "))")
    s = r("iset.select(df_point[\"temp\"][]==1)")
    wl.wl("selection option is executed: "+str(s),dt)
  # data is detached
  s = r("detach(df_point)")
  wl.wl("data frame of point is detached: ",dt)
  # return list if link option is active
  if index["Linking"] == 2:
    return pyList
  else:
    return 0

def doMultiAnalysis (r, robjects, index):
  dt="iplotRpart-doMultiAnalysis"
  res_rdf = r("df_point <- as.data.frame(v_spdf)")
  s = r("attach(df_point)")
  wl.wl("data frame of point is attached: ",dt)
  # plot type
  if index["MultiParallel"] == 2:
    s = r("ibox(" + str(index["MultiX"]) + ", " + str(index["MultiY"]) + ")")
    wl.wl("ibox(MultiX,MultiY) is executed: "+str(s),dt)
  if index["Scatter"] == 2:
    s = r("iplot(" + str(index["MultiX"]) + ", " + str(index["MultiY"]) + ")")
    wl.wl("iplot(MultiX,MultiY) is executed: "+str(s),dt)
    if index["ScatterLine"] == 2:
      for i in range(len(res_rdf)):
        if index["MultiX"] == res_rdf.names[i]:
          indexXfield = i
          wl.wl("indexXfield: "+str(indexXfield),dt)
        if index["MultiY"] == res_rdf.names[i]:
          indexYfield = i
          wl.wl("indexYfield: "+str(indexYfield),dt)
      d_x = []
      d_y = []
      for i in range(res_rdf.nrow()):
        d_x.append(res_rdf[indexXfield][i])
        d_y.append(res_rdf[indexYfield][i])
      xVec = robjects.FloatVector(d_x)
      yVec = robjects.FloatVector(d_y)
      robjects.globalEnv["xVec"] = xVec
      robjects.globalEnv["yVec"] = yVec
      lmMultiXY = r.lm("xVec ~ yVec")
      s = r.iabline(lmMultiXY)
      wl.wl("iabline(lm(MultiX ~ MultiY)) is executed: "+str(s),dt)
    if index["ScatterLowess"] == 2:
      s = r("ilines(lowess(" + str(index["MultiX"]) + ", " + str(index["MultiY"]) + \
            "), col = \"#0000c0\")")
      wl.wl("ilines(lowess(MultiX,MultiY)) is executed: "+str(s),dt)
  # linking option
  if index["Linking"] == 2:
    s = r("d <- iplot.data()")
    wl.wl("iplot.data is read: "+str(s),dt)
    codeTxt = "while (!is.null(ievent.wait())){if(iset.sel.changed())" + \
              "{res <-iset.selected()}};res"
    res = r(codeTxt)
    wl.wl("event is processed: "+str(res),dt)
    resX = r("d$x[res]")
    resY = r("d$y[res]")
    wl.wl("--- returned value is ----",dt)
    wl.wl("resX: "+str(resX),dt)
    wl.wl("resY: "+str(resY),dt)
    # convert RVectorList to python list
    pyList = []
    for i in range(len(res)):
      pyList.append(int(res[i])-1)
    wl.wl("pyList: "+str(pyList),dt)
  # defining color option
  if index["OptionColorField"] != "":
    r("iplot.opt(col=" + str(index["OptionColorField"]) + ")")
  # selection option
  if index["OptionSelection"] != 0:
    s = r("df_point[\"temp\"] <- factor(c(" + str(index["OptionSelection"]) + "))")
    s = r("iset.select(df_point[\"temp\"][]==1)")
    wl.wl("selection option is executed: "+str(s),dt)
  # data is detached
  s = r("detach(df_point)")
  wl.wl("data frame of point is detached: ",dt)
  # return list if link option is active
  if index["Linking"] == 2:
    return pyList
  else:
    return 0

def doCloseAnalysis (r):
  dt="iplotRpart-doCloseAnalysis"
  s = r("n <- iplot.list()")
  n = r("length(n)")
  n = int(n[0])
  wl.wl("the number of opened plot: "+str(n),dt)
  for i in range(n):
    s = r("iplot.off(plot=iplot.cur())")
  wl.wl("all iplots are closed...",dt)
  return 0
