# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
from PyQt4 import QtCore
from PyQt4 import QtGui
from qgis.core import *
# import the code for the dialog
from ui_KLripley import Ui_KLripleyDialog
#handling outputFile: path name, file name and extension
import os
# run R code
import KLripleyRpart
# write to logFile.log
import wl
# dialog for open help file and R code 
import sda4ppDisplayHelpFile
# reading qgis layer
import sda4ppReadQGISLayer
# R options
import sda4ppRoptions

class KLripleyTool(QtGui.QDialog, Ui_KLripleyDialog):
  def __init__(self, iface):
    QtGui.QDialog.__init__(self)
    # save reference to the QGIS interface
    self.iface = iface
    # Set up the user interface from Designer.
    self.setupUi(self)
    self.setFixedSize(self.size())
    # init variables
    self.index = {"inputFile":"", "fileBaseName":"",
                  "linkDisp":0, "axisX":"theo", "axisY":".",
                  "functionName":"Kest", "showMsgOnce":True}
    # read the name of qgis layer
    self.readInputFile()
    self.progressBar.setValue(0)
    QtCore.QObject.connect(self.chkLinking, QtCore.SIGNAL("clicked()"),
                           self.chkLinking_changed)
    QtCore.QObject.connect(self.cmbPointLayer,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbPointLayer_changed)
    QtCore.QObject.connect(self.cmbKLest,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbKLest_changed)
    QtCore.QObject.connect(self.cmbXaxis,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbXaxis_changed)
    QtCore.QObject.connect(self.cmbYaxis,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbYaxis_changed)
    QtCore.QObject.connect(self.btnApply, QtCore.SIGNAL("clicked()"),
                           self.runApply)
    QtCore.QObject.connect(self.btnHelp, QtCore.SIGNAL("clicked()"),
                           self.runHelp)
    QtCore.QObject.connect(self.btnCancel, QtCore.SIGNAL("clicked()"),
                           self.runClose)

  def runClose(self):
    sda4ppRoptions.closeRplot(self.R)
    self.reject()

  def runHelp(self):
    sda4ppDisplayHelpFile.DisplayHelpFile(self.index["functionName"])

  def chkLinking_changed(self):
    # 0 for no, 2 for yes
    self.index["linkDisp"] = self.chkLinking.checkState()
    if self.index["linkDisp"] == 2:
      self.cmbXaxis.setCurrentIndex(1)
      self.cmbXaxis.setEnabled(False)
      self.index["axisX"] = "r"
    else:
      self.cmbXaxis.setCurrentIndex(0)
      self.cmbXaxis.setEnabled(True)
      self.index["axisX"] = "theo"

  def cmbKLest_changed(self):
    if self.cmbKLest.currentIndex() == 0:
      self.index["functionName"] = "Kest"
    elif self.cmbKLest.currentIndex() == 1:
      self.index["functionName"] = "Lest"

  def cmbXaxis_changed(self):
    if self.cmbXaxis.currentIndex() == 0:
      self.index["axisX"] = "theo"
    elif self.cmbXaxis.currentIndex() == 1:
      self.index["axisX"] = "r"
    elif self.cmbXaxis.currentIndex() == 2:
      self.index["axisX"] = "border"
    elif self.cmbXaxis.currentIndex() == 3:
      self.index["axisX"] = "trans"
    elif self.cmbXaxis.currentIndex() == 4:
      self.index["axisX"] = "iso"
      
  def cmbYaxis_changed(self):
    if self.cmbYaxis.currentIndex() == 0:
      self.index["axisY"] = "."
    elif self.cmbYaxis.currentIndex() == 1:
      self.index["axisY"] = "theo"
    elif self.cmbYaxis.currentIndex() == 2:
      self.index["axisY"] = "border"
    elif self.cmbYaxis.currentIndex() == 3:
      self.index["axisY"] = "trans"
    elif self.cmbYaxis.currentIndex() == 4:
      self.index["axisY"] = "iso"

  def cmbPointLayer_changed(self):
    dt = "KLripley-cmbPointLayer_changed"
    #update source of layer
    (self.index["inputFilePath"], self.index["inputFileName"]) = \
       self.ReadPointLayer.getFileSource (self.cmbPointLayer.currentText())
    wl.wl("index: " + str(self.index),dt)
    # readOGR
    error = sda4ppRoptions.readOGR(self.R,self.index["inputFilePath"],self.index["inputFileName"])
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return

  def readInputFile(self):
    dt = "KLripley-readInputFile"
    # init rpy2
    import rpy2.robjects as robjects
    self.R = robjects.r
    # SECTION: point
    self.ReadPointLayer = sda4ppReadQGISLayer.ReadQgisLayer(self.iface)
    layers = self.ReadPointLayer.getLayerList()
    wl.wl("layers: " +str(layers),dt)
    if layers == []:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "Please add point typed vector layers in QGIS.")
      return
    for layer in layers:
      self.cmbPointLayer.addItem(layer)
    # inputFile
    (self.index["inputFilePath"], self.index["inputFileName"]) = \
       self.ReadPointLayer.getFileSource (self.cmbPointLayer.currentText())
    # readOGR
    error = sda4ppRoptions.readOGR(self.R,self.index["inputFilePath"],self.index["inputFileName"])
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return
    wl.wl("index: " + str(self.index),dt)
    return
    
  def runApply(self):
    dt = "KLripley-runApply"
    self.progressBar.setValue(5)
    #BEGIN SECTION: inputFile
    if self.cmbPointLayer.currentIndex() == -1:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "Please add point typed vector layer in QGIS.")
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(10)
    # could not save postgis layer as shp file
    if self.index["inputFilePath"] == 'error':
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", self.index["inputFileName"])
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(15)
    #BEGIN SECTION: R part
    wl.wl("index: " + str(self.index),dt)
    # link to R
    self.btnApply.setEnabled(False)
    if self.index["linkDisp"] == 2: # true
      self.progressBar.setValue(80)
      if self.index["showMsgOnce"]:
        if os.name == "nt":
          msg = "1. Click on the plot to identify the distance on the X and Y axis.\n\n" + \
            "2. In order to stop the linked display,\n" + \
            "Select 'Stop' from plot menu or " + \
            "Right click on the plot and select 'Stop'\n\n" + \
            "3. The point features which have that much distance between each other " + \
            " will be highlighted at the selected point layer.\n\n" + \
            "Do not close the plot without 'Stop' the event..."
        else:
          msg = "Click on the plot to identify the distance on the X and Y axis.\n\n" + \
            "The point features which have that much distance between each other " + \
            " will be highlighted at the selected point layer."
        QtGui.QMessageBox.information(self.iface.mainWindow(),
            "How to use linked display", msg)
        self.index["showMsgOnce"] = False
      recordList = KLripleyRpart.doSpatialAnalysis(self.R, self.index)
      wl.wl("recordList: " +str(recordList),dt)
      self.progressBar.setValue(100)
      self.ReadPointLayer.setSelectionFromQuery(recordList, zoom = "False")
    else:
      KLripleyRpart.doSpatialAnalysis(self.R, self.index)
    self.btnApply.setEnabled(True)
    self.progressBar.setValue(0)
