# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
# R options
import sda4ppRoptions
# write to logFile.log
import wl

def doSpatialAnalysis (r, index):
  dt="polygonRpart-doSpatialAnalysis"
  wl.wl("index: " +str(index),dt)
  # to ppp format
  r("crds <- v_spdf@coords")
  r("sp_est <- as(v_spdf,\"SpatialPoints\")")
  r("ppp_est <- as(sp_est,\"ppp\")")
  # method = dirichlet | delaunay
  r("poly_est <- " + str(index["method"]) + "(ppp_est)")
  # plot
  if index["plot"]:
    rcodes = ["plot(v_spdf, main=\"Computed Polygon Layer\")",
              "plot(poly_est, add=T, col=\"RED\")"]
    sda4ppRoptions.plotGraphics(r, rcodes)
  # save
  if index["save"]:
    if index["method"] == "dirichlet":
      r("sp <- as(poly_est,\"SpatialPolygons\")")
      r("df = data.frame(ids=seq(0,length(crds[,1])-1), x=crds[,1], y=crds[,2], row.names=sapply(slot(sp, 'polygons'), function(x) slot(x, 'ID')))")
      r("spdf = SpatialPolygonsDataFrame(sp, data=df)")
      r("writeOGR(spdf,\"" + str(index["outputFilePath"]) + "\",\"" + \
        str(index["outputFileName"]) + "\", driver=\"ESRI Shapefile\")")
    else:
      r("sp <- as(poly_est,\"SpatialPolygons\")")
      r("n <- sp@polygons")
      r("df = data.frame(ids=seq(0,length(n)-1))")
      # does not match. this is, i think, a bug
      r("spdf = SpatialPolygonsDataFrame(sp, data=df, match.ID=FALSE)")
      r("writeOGR(spdf,\"" + str(index["outputFilePath"]) + "\",\"" + \
        str(index["outputFileName"]) + "\", driver=\"ESRI Shapefile\")")
  return 0
