# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
# R options
import sda4ppRoptions
# write to logFile.log
import wl

def doSpatialAnalysis (r, index):
  dt="centroidRpart-doSpatialAnalysis"
  wl.wl("index: " +str(index),dt)
  # from polygon_spdf to point_spdf
  r("centroid_point <- getSpatialPolygonsLabelPoints(v_spdf)")
  # plot
  if index["plot"]:
    rcodes = ["plot(v_spdf, main=\"Computed Centroid Layer\")",
              "plot(centroid_point, add=T, col=\"RED\")"]
    sda4ppRoptions.plotGraphics(r, rcodes)
  # save
  if index["save"]:
    r("crds <- centroid_point@coords")
    r("df = data.frame(x=crds[,1], y=crds[,2])")
    r("spdf = SpatialPointsDataFrame(centroid_point, data=df)")
    r("writeOGR(spdf,\"" + str(index["outputFilePath"]) + "\",\"" + \
      str(index["outputFileName"]) + "\", driver=\"ESRI Shapefile\")")
  return 0
