# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
from PyQt4 import QtCore
from PyQt4 import QtGui
# load form
from ui_menuInfoConf import Ui_infoConfDialog
import os
# write to logFile.log
import wl

class UiConfControl(QtGui.QDialog, Ui_infoConfDialog):
  def __init__(self, parent, flag):
    QtGui.QDialog.__init__(self, parent, flag)
    self.setupUi(self)
    self.setFixedSize(self.size())
    dt = "uiconfcontrol-init"
    # QSetting part
    self.index = wl.manageConfFile(mode="read", index="", tool="identify")
    wl.wl("index: " + str(self.index),dt)
    # set widgets
    self.chkUserXY.setChecked(bool(self.index["userxy"]))
    # -----------------------for vector layer
    self.chkVctName.setChecked(bool(self.index["v.name"]))
    self.chkVctType.setChecked(bool(self.index["v.type"]))
    self.chkVctFormat.setChecked(bool(self.index["v.format"]))
    self.chkVctProj.setChecked(bool(self.index["v.proj"]))
    self.chkVctSource.setChecked(bool(self.index["v.source"]))
    self.chkVctFid.setChecked(bool(self.index["v.fid"]))
    self.chkVctDistance.setChecked(bool(self.index["v.dist"]))
    self.chkVctFields.setChecked(bool(self.index["v.field"]))
    self.chkVctFieldType.setChecked(bool(self.index["v.ftype"]))
    # --------------------- for tolerance
    self.txtTolerance.setText(str(self.index["tolerance"]))
    # ---------------------for raster layer
    self.chkRstName.setChecked(bool(self.index["r.name"]))
    self.chkRstFormat.setChecked(bool(self.index["r.format"]))
    self.chkRstProj.setChecked(bool(self.index["r.proj"]))
    self.chkRstSource.setChecked(bool(self.index["r.source"]))
    self.chkRstBandCount.setChecked(bool(self.index["r.bcount"]))
    self.chkRstBandValue.setChecked(bool(self.index["r.bvalue"]))
    self.chkRstType.setChecked(bool(self.index["r.type"]))
