# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
# R options
import sda4ppRoptions
# write to logFile.log
import wl

def doSpatialAnalysis (r, index):
  dt="localKLRpart-doSpatialAnalysis"
  wl.wl("index: " +str(index),dt)
  # to ppp format
  r("sp_est <- as(v_spdf,\"SpatialPoints\")")
  r("ppp_est <- as(sp_est,\"ppp\")")
  # Plot all the local function
  if index["plotType"] == "plotAll":
    r("allLocals <- " + str(index["tool"]) + "(ppp_est, correction = \"" +\
      str(index["edge"]) + "\")")
    # send to plot
    rcodes = ["plot(allLocals, main=\" all " + str(index["tool"]) + \
        " functions for " + str(index["inputFileName"]) + "\")"]
    sda4ppRoptions.plotGraphics(r, rcodes)
  # Plot only local function
  elif index["plotType"] == "plotId":
    r("onlyOneLocal <- " + str(index["tool"]) + \
      "(ppp_est, correction = \"" + str(index["edge"]) + "\")")
    if index["edge"] == "none":
      isoNo = "un"
    elif index["edge"] == "translate":
      isoNo = "trans"
    else:
      isoNo = "iso"
    intId = len(str(index["plotIdCount"]))-len(str(index["plotId"]))
    for i in range(intId):
      isoNo += "0"
    isoNo += str(int(index["plotId"])+1)
    wl.wl("isoNo: " +str(isoNo),dt)
    # send to plot
    rcodes = ["plot(onlyOneLocal, " + str(isoNo) + " ~ r, main=\" only " + \
        str(index["tool"]) + " functions for " + str(index["inputFileName"]) + \
        " point number " + str(index["plotId"]) + "\")"]
    sda4ppRoptions.plotGraphics(r, rcodes)
  return 0
