# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
# R options
import sda4ppRoptions
# write to logFile.log
import wl

def doSpatialAnalysis (r,index):
  dt="intensityRpart-doSpatialAnalysis"
  wl.wl("index: " +str(index),dt)
  # to ppp format
  r("v_sp <- as(v_spdf,\"SpatialPoints\")")
  r("v_ppp <- as(v_sp,\"ppp\")")
  summary = r("summary(v_ppp)")
  wl.wl("summary: " +str(summary),dt)
  intensity = r("summary(v_ppp)$intensity")
  wl.wl("intensity: " +str(intensity),dt)
  lblResult = str(summary) + "\n\nIntensity = " + str(intensity[0])
  wl.wl("lblResult: " +str(lblResult),dt)
  # plot
  if index["plot"]:
    rcodes = ["plot(v_ppp, main=\"Plotting the layer of " + \
        str(index["inputFileName"]) + "\")"]
    sda4ppRoptions.plotGraphics(r, rcodes)
  return lblResult
