# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
from PyQt4 import QtCore
from PyQt4 import QtGui
from qgis.core import *
# import the code for the dialog
from ui_intensity import Ui_intensityDialog
#handling vector: path name, file name and extension
import os
# run R code
import intensityRpart
# write to logFile.log
import wl
# dialog for open help file
import sda4ppDisplayHelpFile
# reading qgis layer
import sda4ppReadQGISLayer
# R options
import sda4ppRoptions

class IntensityTool(QtGui.QDialog, Ui_intensityDialog):
  def __init__(self, iface):
    QtGui.QDialog.__init__(self)
    # save reference to the QGIS interface
    self.iface = iface
    # Set up the user interface from Designer.
    self.setupUi(self)
    self.setFixedSize(self.size())
    ## init variables
    self.index = {"inputFile":"","fileBaseName":""}
    # read the name of qgis layer
    self.readInputFile()
    self.progressBar.setValue(0)
    QtCore.QObject.connect(self.cmbVector,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbVector_changed)
    QtCore.QObject.connect(self.btnApply, QtCore.SIGNAL("clicked()"),
                           self.runApply)
    QtCore.QObject.connect(self.btnHelp, QtCore.SIGNAL("clicked()"),
                           self.runHelp)
    QtCore.QObject.connect(self.btnCancel, QtCore.SIGNAL("clicked()"),
                           self.runClose)

  def runHelp(self):
    sda4ppDisplayHelpFile.DisplayHelpFile("intensity")

  def runClose(self):
    sda4ppRoptions.closeRplot(self.R)
    self.reject()

  def cmbVector_changed(self):
    dt = "intensity-cmbVector_changed"
    #update source of layer
    (self.index["inputFilePath"], self.index["inputFileName"]) = \
            self.ReadVector.getFileSource (self.cmbVector.currentText())
    wl.wl("index: " + str(self.index),dt)
    # readOGR
    error = sda4ppRoptions.readOGR(self.R,self.index["inputFilePath"],self.index["inputFileName"])
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return

  def readInputFile(self):
    dt = "intensity-readInputFile"
    # init rpy2
    import rpy2.robjects as robjects
    self.R = robjects.r
    # point one
    self.ReadVector = sda4ppReadQGISLayer.ReadQgisLayer(self.iface)
    layers = self.ReadVector.getLayerList()
    wl.wl("layers: " +str(layers),dt)
    if layers == []:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "Please add point typed vector layers in QGIS.")
      return
    for layer in layers:
      self.cmbVector.addItem(layer)
    # inputFile
    (self.index["inputFilePath"], self.index["inputFileName"]) = \
            self.ReadVector.getFileSource (self.cmbVector.currentText())
    # readOGR
    error = sda4ppRoptions.readOGR(self.R,self.index["inputFilePath"],self.index["inputFileName"])
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return
    wl.wl("index: " +str(self.index),dt)
    return

  def runApply(self):
    dt = "intensity-runApply"
    self.lblResult.clear()
    self.progressBar.setValue(5)
    #BEGIN SECTION: inputFile
    if self.cmbVector.currentIndex() == -1:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "Please add point typed vector layer in QGIS.")
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(10)
    # could not save postgis layer as shp file
    if self.index["inputFilePath"] == 'error':
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", self.index["inputFileName"])
      self.progressBar.setValue(0)
      return
    # SECTION: R part
    self.progressBar.setValue(100)
    # plot
    self.index["plot"] = self.chkPlot.isChecked()
    wl.wl("index: " +str(self.index),dt)
    # apply analysis to R
    self.btnApply.setEnabled(False)
    resText = intensityRpart.doSpatialAnalysis(self.R, self.index)
    self.btnApply.setEnabled(True)
    self.lblResult.setText(resText)
    self.progressBar.setValue(0)
