# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
from PyQt4 import QtCore
from PyQt4 import QtGui
from qgis.core import *
# import the code for the dialog
from ui_diggle import Ui_diggleDialog
#handling outputFile: path name, file name and extension
import os
# run R code
import diggleRpart
# write to logFile.log
import wl
# dialog for open help file
import sda4ppDisplayHelpFile
# reading qgis layer
import sda4ppReadQGISLayer
# R options
import sda4ppRoptions

class DiggleTool(QtGui.QDialog, Ui_diggleDialog):
  def __init__(self, iface):
    QtGui.QDialog.__init__(self)
    # save reference to the QGIS interface
    self.iface = iface
    # Set up the user interface from Designer.
    self.setupUi(self)
    self.setFixedSize(self.size())
    # init variables
    self.index = {"caseFilePath":"","caseFileName":"",
                  "backFilePath":"","backFileName":"",
                  "plotOpt":"diggle", "readogrError":""}
    # read the name of qgis layer
    self.readInputFile()
    self.progressBar.setValue(0)
    QtCore.QObject.connect(self.cmbPointLayer,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbPointLayer_changed)
    QtCore.QObject.connect(self.cmbSecond,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbSecond_changed)
    QtCore.QObject.connect(self.btnApply, QtCore.SIGNAL("clicked()"),
                           self.runApply)
    QtCore.QObject.connect(self.btnHelp, QtCore.SIGNAL("clicked()"),
                           self.runHelp)
    QtCore.QObject.connect(self.btnCancel, QtCore.SIGNAL("clicked()"),
                           self.runClose)
    QtCore.QObject.connect(self.rbDiggle, QtCore.SIGNAL("clicked()"),
                           self.rbDiggle_changed)
    QtCore.QObject.connect(self.rbBandwidth, QtCore.SIGNAL("clicked()"),
                           self.rbBandwidth_changed)
    QtCore.QObject.connect(self.rbIntsPoint, QtCore.SIGNAL("clicked()"),
                           self.rbIntsPoint_changed)
    QtCore.QObject.connect(self.rbIntsSecond, QtCore.SIGNAL("clicked()"),
                           self.rbIntsSecond_changed)
    QtCore.QObject.connect(self.rbRatio, QtCore.SIGNAL("clicked()"),
                           self.rbRatio_changed)

  def runClose(self):
    sda4ppRoptions.closeRplot(self.R)
    self.reject()

  def runHelp(self):
    sda4ppDisplayHelpFile.DisplayHelpFile("Diggle")

  def rbDiggle_changed(self):
    self.index["plotOpt"]="diggle"

  def rbBandwidth_changed(self):
    self.index["plotOpt"]="bandwidth"

  def rbIntsPoint_changed(self):
    self.index["plotOpt"]="case"

  def rbIntsSecond_changed(self):
    self.index["plotOpt"]="background"

  def rbRatio_changed(self):
    self.index["plotOpt"]="ratio"

  def cmbSecond_changed(self):
    dt = "diggle-cmbSecond"
    self.index["readogrError"] = ""
    #update source of layer
    (self.index["backFilePath"], self.index["backFileName"]) = \
       self.ReadSecondLayer.getFileSource (self.cmbSecond.currentText())
    # readOGR
    error = sda4ppRoptions.readOGR(self.R,self.index["backFilePath"],\
                                   self.index["backFileName"],\
                                   secondLayer="True")
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return

  def cmbPointLayer_changed(self):
    dt = "diggle-cmbPointLayer"
    self.index["readogrError"] = ""
    #update source of layer
    (self.index["caseFilePath"], self.index["caseFileName"]) = \
       self.ReadPointLayer.getFileSource (self.cmbPointLayer.currentText())
    # readOGR
    error = sda4ppRoptions.readOGR(self.R,self.index["caseFilePath"],\
                                   self.index["caseFileName"])
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return

  def readInputFile(self):
    dt = "diggle-readInputFile"
    # init rpy2
    import rpy2.robjects as robjects
    self.R = robjects.r
    # SECTION: POINT
    self.ReadPointLayer = sda4ppReadQGISLayer.ReadQgisLayer(self.iface)
    layers = self.ReadPointLayer.getLayerList()
    wl.wl("layers: " +str(layers),dt)
    if layers == []:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
                        "SDA4PP Plugin Error",
                        "Please add point typed vector layers in QGIS.")
      return
    for layer in layers:
      self.cmbPointLayer.addItem(layer)
    # caseFile
    (self.index["caseFilePath"], self.index["caseFileName"]) = \
       self.ReadPointLayer.getFileSource (self.cmbPointLayer.currentText())
    # SECTION: second point region area
    self.ReadSecondLayer = sda4ppReadQGISLayer.ReadQgisLayer(self.iface)
    layers2 = self.ReadSecondLayer.getLayerList()
    for layer2 in layers2:
      self.cmbSecond.addItem(layer2)
    # backgroundFile
    (self.index["backFilePath"], self.index["backFileName"]) = \
       self.ReadPointLayer.getFileSource (self.cmbPointLayer.currentText())
    # SECTION readOGR
    error1 = sda4ppRoptions.readOGR(self.R,self.index["caseFilePath"],\
                                   self.index["caseFileName"])
    error2 = sda4ppRoptions.readOGR(self.R,self.index["backFilePath"],\
                                   self.index["backFileName"],\
                                   secondLayer="True")
    if error1 != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error1)
      return
    if error2 != error1:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error2)
      return
    wl.wl("index: " +str(self.index),dt)
    return

  def runApply(self):
    dt = "diggle-runApply"
    self.progressBar.setValue(5)
    #BEGIN SECTION: caseFile
    if self.cmbPointLayer.currentIndex() == -1:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "Please add point typed vector layer in QGIS.")
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(10)
    # could not save postgis layer as shp file
    if self.index["caseFilePath"] == 'error':
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", self.index["caseFileName"])
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(15)
    # readogrError
    if self.index["readogrError"] != "":
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", self.index["readogrError"])
      self.progressBar.setValue(0)
      return
    #BEGIN SECTION: R part
    self.progressBar.setValue(100)
    wl.wl("index: " +str(self.index),dt)
    # apply analysis part to R
    self.btnApply.setEnabled(False)
    diggleRpart.doSpatialAnalysis(self.R,index= self.index)
    self.btnApply.setEnabled(True)
    self.progressBar.setValue(0)
