# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
# R options
import sda4ppRoptions
# write to logFile.log
import wl

def doSpatialAnalysis (r,index):
  dt="adaptiveRpart-doSpatialAnalysis"
  wl.wl("index: " +str(index),dt)
  # pixel
  r("spatstat.options(npixel=c(" + str(index["pixelX"]) + "," + \
    str(index["pixelY"])+"))")
  # to ppp
  r("v_sp <- as(v_spdf,\"SpatialPoints\")")
  r("v_ppp <- as(v_sp,\"ppp\")")
  # adaptive.density
  r("ap <- adaptive.density(v_ppp, f = " + str(index["fraction"]) + ")")
  # save
  if index["save"]:
    r("sgdf <- as(ap,\"SpatialGridDataFrame\")")
    r("writeGDAL(sgdf,\"" + str(index["outputFilePath"]) + \
      "\", drivername = \"" + str(index["rstfile"]) + \
      "\", type = \"Float32\")")
  # plot
  if index["plot"]:
    rcodes = ["plot(ap, main=\"Plotting the adaptive density for " + \
        str(index["inputFileName"]) + "\")"]
    sda4ppRoptions.plotGraphics(r, rcodes)
  # defult pixel
  r("spatstat.options(npixel=100)")
  return
