# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
import os, tempfile
import __init__
from PyQt4 import QtCore
writable = True
writable_uni = True

def wl (logMsg, nameModule="", wrtmode="a"):
  global writable
  if writable:
    # returns the directory where wl.py is found.
    recordFile =  os.path.dirname(__file__) + "/logFile.log"
    # orijinal msg
    """
    f = open(recordFile, wrtmode)
    f.write("\n***_" + str(logMsg) + "_***\n")
    f.close()
    """
    # formatting module name
    if nameModule.find("-") != -1:
      (nameClass, nameFunction) = nameModule.split("-", 1)
      newModule = nameClass + " | " + nameFunction
    else:
      newModule = nameModule
    # formatting log message
    logMsg = str(logMsg)
    if logMsg.find(":") != -1:
      (varName, varValue) = logMsg.split(":", 1)
      ## if isinstance (varName, dict):
      if varName == "index":
        try:
          indexDict = varValue.strip()[1:-1]
          indexLists = indexDict.split(", ")
          realDict = {}
          for indexList in indexLists:
            (name, value) = indexList.split(": ", 1)
            realDict[name[1:-1]] = value
          newMsg = ""
          for var in realDict.keys():
            newMsg += newModule + " | index | " + str(var) + " = " + \
                    str(realDict[var]) + "\n"
        except:
          try:
            v = int(varValue.strip())
            newMsg = newModule + " | " + varName + " = " + str(v)
          except:
            newMsg = newModule + " | " + varName + " = \"" + \
                   str(varValue.strip()) + "\""
      else:
        try:
          v = int(varValue.strip())
          newMsg = newModule + " | " + varName + " = " + str(v)
        except:
          newMsg = newModule + " | " + varName + " = \"" + \
                 str(varValue.strip()) + "\""
    else:
      # class name | function name | message
      if newModule == "":
        newMsg = str(logMsg)
      else:
        newMsg = newModule + " | " + str(logMsg)
    # for terminal in linux
    if os.name == "posix":
      print str(newMsg)
    newMsg += "\n"
    try:
      f = open(recordFile, wrtmode)
      f.write(newMsg)
      f.close()
    except IOError:
      print "cannot open ", recordFile
      # no logging any more
      writable = False
    except:
      print "Unexpected error"
      # no logging any more
      writable = False

def wluni (logMsg, pyFile="", wrtmode="a"):
  global writable_uni
  if writable_uni:
    recordFile =  os.path.dirname(__file__) + "/logFile_ii.log"
    if pyFile.find("-") != -1:
      (nameClass, nameFunction) = pyFile.split("-", -1)
      pyFile = nameClass.ljust(20) + " | " + nameFunction.ljust(25)
    else:
      pyFile = pyFile.ljust(48)
    if logMsg.find(":") != -1:
      try:
        (varName, varValue) = logMsg.split(":", 1)
        try:
          v = int(varValue.strip())
          logMsg = varName + "=" + str(v)
        except:
          logMsg = varName + "=\"" + varValue.strip() + "\""
      except:
        pass
    # class name-function name --- message
    logMsg = pyFile + " - " + logMsg + "\n"
    try: 
      f = open(recordFile, wrtmode)
      f.write(logMsg.encode('utf-8'))
      f.close()
    except IOError:
      print "cannot open ", recordFile
      # no logging any more
      writable_uni = False
    except:
      print "Unexpected error"
      # no logging any more
      writable_uni = False

def manageConfFile(mode, index, tool=""):
  dt = "wl-manageConfFile"
  wl("mode: "+str(mode),dt)
  wl("index: "+str(index),dt)
  wl("tool: "+str(tool),dt)
  keyName = "sda4pp/" + tool + "/"
  curVer = __init__.version()
  # QSettings part
  settings = QtCore.QSettings()
  # writing default values to QSettings
  if mode == "writeInit":
    verKey = "sda4pp/version"
    if settings.contains(verKey):
      regVer = str(settings.value(verKey).toString())
      if regVer == curVer:
        # no need to init for this version
        return True
      else:
        # plugin is updated
        settings.setValue(verKey, QtCore.QVariant(curVer))
        writeInits(settings)
        return True
    else:
      # plugin is installed and first time execution so init requires
      settings.setValue(verKey, QtCore.QVariant(curVer))
      writeInits(settings)
      return True
  # writing user values to QSettings
  elif mode == "writeIndex":
    settings.beginGroup(keyName)
    for indexkey in index:
      settings.setValue(indexkey, QtCore.QVariant(index[indexkey]))
    settings.endGroup()
    return True
  # reading values from QSettings
  elif mode == "read":
    read_index = {}
    settings.beginGroup(keyName)
    setkeys = settings.childKeys()
    for setkey in setkeys:
      """
      wl("key: " + str(setkey),dt)
      wl("toInt: " + str(settings.value(setkey).toInt()),dt)
      wl("toString: " + str(settings.value(setkey).toString()),dt)
      wl("toBool: " + str(settings.value(setkey).toBool()),dt)
      """
      if tool == "graphics":
        if setkey in ["units","folderPath","width","height"]:
          read_index[str(setkey)] = str(settings.value(setkey).toString())
        elif setkey in ["res"]:
          read_index[str(setkey)] = settings.value(setkey).toInt()[0]
        elif setkey in ["overwrite","folder","Rdevice","PNGdevice"]:
          read_index[str(setkey)] = settings.value(setkey).toBool()
      elif tool == "identify":
        read_index[str(setkey)] = settings.value(setkey).toInt()[0]
      elif tool == "rplot":
        if setkey in ["width","height"]:
          read_index[str(setkey)] = str(settings.value(setkey).toString())
        elif setkey in ["xpos","ypos","pointsize"]:
          read_index[str(setkey)] = settings.value(setkey).toInt()[0]
        elif setkey in ["default"]:
          read_index[str(setkey)] = settings.value(setkey).toBool()
    wl("read_index from registry: "+str(read_index),dt)
    return read_index

def writeInits(settings):
  dt = "wl-writeInits"
  wl("Initial writing to registry.",dt)
  # graphics
  defConf = {"units":"px", "width":600.00, "height":600.00, "res":72, "folderPath":"",
             "overwrite":False, "folder":True, "Rdevice":True, "PNGdevice":False}
  settings.beginGroup("sda4pp/graphics/")
  for defkey in defConf:
    settings.setValue(defkey, QtCore.QVariant(defConf[defkey]))
  settings.endGroup()
  # identify
  defConf = {"userxy":2, "v.name":2, "v.type":2, "v.format":2,
             "v.proj":2, "v.source":2, "v.fid":2, "v.dist":2,
             "v.field":2, "v.ftype":2, "tolerance":10000, "r.name":2,
             "r.format":2, "r.proj":2, "r.source":2,
             "r.bcount":2, "r.bvalue":2, "r.type":2}
  settings.beginGroup("sda4pp/identify/")
  for defkey in defConf:
    settings.setValue(defkey, QtCore.QVariant(defConf[defkey]))
  settings.endGroup()
  # r-graphic-device
  if os.name == "nt":
    rgdConf = {"default":True, "width":5.00, "height":5.00, "xpos":0, "ypos":0, "pointsize":9}
  else:
    rgdConf = {"default":False, "width":5.00, "height":5.00, "xpos":0, "ypos":0, "pointsize":7}
  settings.beginGroup("sda4pp/rplot/")
  for rgdkey in rgdConf:
    settings.setValue(rgdkey, QtCore.QVariant(rgdConf[rgdkey]))
  settings.endGroup()
  # save dialog
  tempDir = tempfile.gettempdir()
  if os.name == "nt":
    tempDir = tempDir.replace("\\","/")
  outputpathdir = tempDir + "/SDA4PP/"
  if not(os.path.exists(outputpathdir)):
    os.mkdir(outputpathdir)
  dialogDirs = {"sda4pp/csvDir":outputpathdir + "csv/",
                "sda4pp/tifDir":outputpathdir + "tif/",
                "sda4pp/imgDir":outputpathdir + "img/"}
  for dialogDir in dialogDirs:
    settings.setValue(dialogDir, QtCore.QVariant(dialogDirs[dialogDir]))
  return True

def readIntTxtBox(userValue, mode="integer", allowZero="False", allowNegative="False", widgetName="."):
    dt = "wl-readIntTxtBox"
    if widgetName != ".":
      widgetName = "\nfor " + widgetName + "."
    #converting from maybe string to either integer or decimal number
    try:
      if mode == "integer":
        value = int(str(userValue).strip())
      elif mode == "decimal":
        value = float(str(userValue).strip())
    except Exception, e:
      wl("Please enter " + mode + " number" + widgetName + ";\n" + str(e),dt)
      return "error", "Please enter " + mode + " number" + widgetName
    #checking no zero or negative number
    if value < 0 and allowNegative == "False":
      return "error", "Please enter positive " + mode + " number" + widgetName
    elif value == 0 and allowZero == "False":
      return "error", "The value can not be zero. Please enter "+\
             mode + " number" + widgetName
    #returns ok
    wl("userValue: " +str(userValue),dt)
    wl("value: " + str(value),dt)
    return value, "foo"
