# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
from PyQt4 import QtCore
from PyQt4 import QtGui
from qgis.core import *
# import the code for the dialog
from ui_toolrandom import Ui_toolrandomDialog
#handling outputFile: path name, file name and extension
import os
# run R code
import toolrandomRpart
# write to logFile.log
import wl
# dialog for open help file
import sda4ppDisplayHelpFile
# reading qgis layer
import sda4ppReadQGISLayer
# R options
import sda4ppRoptions

class RandomTool(QtGui.QDialog, Ui_toolrandomDialog):
  def __init__(self, iface):
    QtGui.QDialog.__init__(self)
    self.iface = iface
    self.setupUi(self)
    self.setFixedSize(self.size())
    ## init variables
    # random = homo | inhomo | inhomoCoef | gauss
    # plot = 0 | 1
    # save = 0 | 1
    self.index = {"Intensity":0.0, "random":"homo", "Equation":"0",
                  "Addxa":"0", "Diameter":"0", "Probability":"0",
                  "plot":True, "save":False, "returnArea":False, "area":1.0,
                  "totalPoint":0.0, "unitSquare":1, "geomType":-1,
                  "outputFilePath":"", "outputFileName":"",}
    # read the name of qgis layer
    self.readInputFile()
    self.progressBar.setValue(0)
    QtCore.QObject.connect(self.cmbOwin,
            QtCore.SIGNAL("activated(QString )"), self.cmbOwin_changed)
    QtCore.QObject.connect(self.btnSave,
            QtCore.SIGNAL("clicked()"), self.btnSave_changed)
    QtCore.QObject.connect(self.btnApply,
            QtCore.SIGNAL("clicked()"), self.runApply)
    QtCore.QObject.connect(self.btnHelp,
            QtCore.SIGNAL("clicked()"), self.runHelp)
    QtCore.QObject.connect(self.rbHomo,
            QtCore.SIGNAL("clicked()"), self.rbHomo_changed)
    QtCore.QObject.connect(self.rbInhomo,
            QtCore.SIGNAL("clicked()"), self.rbInhomo_changed)
    QtCore.QObject.connect(self.rbGauss,
            QtCore.SIGNAL("clicked()"), self.rbGauss_changed)
    QtCore.QObject.connect(self.chkAddxa,
            QtCore.SIGNAL("clicked()"), self.chkAddxa_changed)
    QtCore.QObject.connect(self.chkPlot,
            QtCore.SIGNAL("clicked()"), self.chkPlot_changed)
    QtCore.QObject.connect(self.chkSave,
            QtCore.SIGNAL("clicked()"), self.chkSave_changed)
    QtCore.QObject.connect(self.btnCancel, QtCore.SIGNAL("clicked()"),
                           self.runClose)

  def runClose(self):
    sda4ppRoptions.closeRplot(self.R)
    self.reject()

  def runHelp(self):
    if self.index["random"] == "gauss":
      sda4ppDisplayHelpFile.DisplayHelpFile("randomGauss")
    else:
      sda4ppDisplayHelpFile.DisplayHelpFile("randomPoisson")

  def chkAddxa_changed(self):
    dt = "random-chkAddxa_changed"
    if self.chkAddxa.checkState() == 2:
      self.txtAddxa.setEnabled(True)
      self.index["random"] = "inhomoCoef"
    elif self.chkAddxa.checkState() == 0:
      self.txtAddxa.setEnabled(False)
      self.index["random"] = "inhomo"
    wl.wl("index: " + str(self.index),dt)

  def rbInhomo_changed(self):
    dt = "random-rbInhomo_changed"
    self.index["random"] = "inhomo"
    wl.wl("index: " + str(self.index),dt)
    self.txtEquation.setEnabled(True)
    self.txtAddxa.setEnabled(False)
    self.chkAddxa.setEnabled(True)
    self.txtDiameter.setEnabled(False)
    self.txtProbability.setEnabled(False)

  def rbHomo_changed(self):
    dt = "random-rbHomo_changed"
    self.index["random"] = "homo"
    wl.wl("index: " + str(self.index),dt)
    self.txtEquation.setEnabled(False)
    self.txtAddxa.setEnabled(False)
    self.chkAddxa.setEnabled(False)
    self.txtDiameter.setEnabled(False)
    self.txtProbability.setEnabled(False)

  def rbGauss_changed(self):
    dt = "random-rbGauss_changed"
    self.index["random"] = "gauss"
    wl.wl("index: " + str(self.index),dt)
    self.txtDiameter.setEnabled(True)
    self.txtProbability.setEnabled(True)
    self.txtEquation.setEnabled(False)
    self.txtAddxa.setEnabled(False)
    self.chkAddxa.setEnabled(False)

  def getUniqueOutputFileName(self, file=""):
    notFileExist = 0
    counter = 0
    if file == "":
      file = self.ReadAllLayer.createOutputDir() + "random"
    while (notFileExist == 0):
      outputFilename = file + "_" + str(counter) + ".shp"
      if not(os.path.exists(outputFilename)):
        self.index["outputFilePath"] = outputFilename
        self.txtPath.setText(outputFilename)
        layerSource = QtCore.QFileInfo(outputFilename)
        self.index["outputFileName"] = str(layerSource.completeBaseName())
        notFileExist = 1
      else:
        counter = counter + 1

  def changeExtension(self):
    if self.index["outputFilePath"] != "":
      f = QtCore.QFileInfo(self.index["outputFilePath"])
      if f.suffix() != "shp":
        self.index["outputFilePath"] = f.path() + "/" + f.completeBaseName() + ".shp"
      if not(os.path.exists(self.index["outputFilePath"])):
        self.txtPath.setText(self.index["outputFilePath"])
        self.index["outputFileName"] = f.completeBaseName()
      else:
        file =f.path() + "/" + f.completeBaseName()
        self.getUniqueOutputFileName(file)

  def btnSave_changed(self):
    (self.index["outputFilePath"], foo) = self.ReadAllLayer.saveDialog(self)
    if self.index["outputFilePath"] is None:
      self.index["outputFilePath"] = str(self.txtPath.text())
      return
    self.changeExtension()

  def chkSave_changed(self):
    dt = "random-chkSave_changed"
    if self.chkSave.checkState() == 2:
      self.btnSave.setEnabled(True)
      self.txtPath.setEnabled(True)
      self.index["save"] = True
      self.getUniqueOutputFileName()
    elif self.chkSave.checkState() == 0:
      self.btnSave.setEnabled(False)
      self.txtPath.setEnabled(False)
      self.txtPath.clear()
      self.index["save"] = False
    wl.wl("index: " + str(self.index),dt)

  def chkPlot_changed(self):
    dt = "random-chkPlot_changed"
    if self.chkPlot.checkState() == 2:
      self.index["plot"] = True
    elif self.chkPlot.checkState() == 0:
      self.index["plot"] = False
    wl.wl("index: " + str(self.index),dt)

  def cmbOwin_changed(self):
    dt = "random-cmbOwin_changed"
    if str(self.cmbOwin.currentIndex()) == "0":
      self.index["unitSquare"] = 1
      self.index["area"] = 1.0
    else:
      # updateLayer: prepare sda4ppReadQGISLayer class to do analysis
      # as the layer is changed in the combobox
      self.ReadAllLayer.updateLayer(self.cmbOwin.currentText())
      extent = self.ReadAllLayer.getExtentObj()
      self.index["xmin"] = extent.xMinimum()
      self.index["xmax"] = extent.xMaximum()
      self.index["ymin"] = extent.yMinimum()
      self.index["ymax"] = extent.yMaximum()
      self.index["unitSquare"] = 0
      # readOGR None
      # apply analysis part to R
      self.index["returnArea"] = True
      self.index["area"] = toolrandomRpart.doSpatialAnalysis(self.R, self.index)
    self.lblArea.setText("Extent of Study Area = " + \
                         str(self.index["area"]))
    wl.wl("index: " + str(self.index),dt)

  def readInputFile(self):
    dt = "random-readInputFile"
    # init rpy2
    import rpy2.robjects as robjects
    self.R = robjects.r
    # read study area
    self.ReadAllLayer = sda4ppReadQGISLayer.ReadQgisLayer(self.iface,
                                                          "all")
    layers = self.ReadAllLayer.getLayerList()
    for layer in layers:
      self.cmbOwin.addItem(layer)
    #  readOGR None
    return

  def runApply(self):
    dt = "random-runApply"
    self.progressBar.setValue(5)
    # check output: at least one of them should be checked
    if not(self.index["save"]) and not(self.index["plot"]):
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "At least one of the output option should be checked.")
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(10)
    # Intensity
    if str(self.txtIntensity.text()) == "":
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", "please, enter the Intensity value.")
      self.progressBar.setValue(0)
      return
    userIntensity = str(self.txtIntensity.text())
    (value, errorText) = wl.readIntTxtBox(userIntensity, mode="decimal")
    if value == "error":
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", errorText)
      self.progressBar.setValue(0)
      return
    self.index["Intensity"] = value
    wl.wl("index: " + str(self.index),dt)
    # check the number
    self.index["totalPoint"] = round(self.index["Intensity"] * \
                                     self.index["area"],0)
    wl.wl("totalPoint: " +str(self.index["totalPoint"]),dt)
    if self.index["totalPoint"] > 3000000.0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", str(self.index["totalPoint"]) + \
            " point could not be created.\n" + \
            "Please change either intensity value or the study area.")
      self.txtIntensity.setText("")
      self.progressBar.setValue(0)
      return
    elif self.index["totalPoint"] > 300000.0:
      sureToCreatePoint = QtGui.QMessageBox.question(self,
            "SDA4PP Plugin Error", str(self.index["totalPoint"]) + \
            " point will be added.\nAre you sure to proceed?\n\n" + \
            "It will take a while to complete the procedure.",
            QtGui.QMessageBox.Yes, QtGui.QMessageBox.No,
            QtGui.QMessageBox.NoButton)
      if sureToCreatePoint == QtGui.QMessageBox.No:
        self.txtIntensity.setText("")
        self.progressBar.setValue(0)
        return
    # Section inhomo poisson
    self.progressBar.setValue(15)
    # Equation
    if self.index["random"] == "inhomo":
      if str(self.txtEquation.text()) == "":
        QtGui.QMessageBox.information(self.iface.mainWindow(),
           "SDA4PP Plugin Error", "please, enter the formula value.")
        self.progressBar.setValue(0)
        return
      if str(self.txtEquation.text()).find("x") == -1:
        QtGui.QMessageBox.information(self.iface.mainWindow(),
           "SDA4PP Plugin Error", "please, the formula should have \"x\".")
        self.progressBar.setValue(0)
        return
      self.index["Equation"] = str(self.txtEquation.text())
      wl.wl("Equation: " + str(self.index["Equation"]),dt)
    self.progressBar.setValue(20)
    if self.index["random"] == "inhomoCoef":
      # formula
      if str(self.txtEquation.text()) == "":
        QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", "please, enter the formula value.")
        self.progressBar.setValue(0)
        return
      if str(self.txtEquation.text()).find("x") == -1:
        QtGui.QMessageBox.information(self.iface.mainWindow(),
           "SDA4PP Plugin Error", "please, the formula should have \"x\".")
        self.progressBar.setValue(0)
        return
      self.index["Equation"] = str(self.txtEquation.text())
      wl.wl("Equation: " + str(self.index["Equation"]),dt)
      # coefficient
      if str(self.txtAddxa.text()) == "":
        QtGui.QMessageBox.information(self.iface.mainWindow(),
           "SDA4PP Plugin Error",
            "please, enter the coefficient of x value.")
        self.progressBar.setValue(0)
        return
      if str(self.txtEquation.text()).find("a") == -1:
        QtGui.QMessageBox.information(self.iface.mainWindow(),
           "SDA4PP Plugin Error",
           "please, the formula should have \"a\" - the coefficient of x.")
        self.progressBar.setValue(0)
        return
      userAddxa = str(self.txtAddxa.text())
      (value, errorText) = wl.readIntTxtBox(userAddxa, mode="decimal")
      if value == "error":
        QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", errorText)
        self.progressBar.setValue(0)
        return
      self.index["Addxa"] = value
      wl.wl("index: " + str(self.index),dt)
    self.progressBar.setValue(25)
    # Section: Gauss
    if self.index["random"] == "gauss":
      # Diameter
      if str(self.txtDiameter.text()) == "":
        QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", "please, enter the Diameter value.")
        self.progressBar.setValue(0)
        return
      userDiameter = str(self.txtDiameter.text())
      (value, errorText) = wl.readIntTxtBox(userDiameter, mode="decimal")
      if value == "error":
        QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", errorText)
        self.progressBar.setValue(0)
        return
      self.index["Diameter"] = value
      wl.wl("index: " + str(self.index),dt)
      # Probability
      if str(self.txtProbability.text()) == "":
        QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", "please, enter the Probability value.")
        self.progressBar.setValue(0)
        return
      userProbability = str(self.txtProbability.text())
      (value, errorText) = wl.readIntTxtBox(userProbability, mode="decimal")
      if value == "error":
        QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", errorText)
        self.progressBar.setValue(0)
        return
      self.index["Probability"] = value
      wl.wl("index: " + str(self.index),dt)
    self.progressBar.setValue(30)
    # Section: outputFile
    if self.index["outputFilePath"] == "" and self.index["save"]:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "SHP file name should be defined.\n" + \
            "Please, use \"Save SHP file As\" button.")
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(100)
    # SECTION: R part
    self.btnApply.setEnabled(False)
    wl.wl("index: " +str(self.index),dt)
    # apply analysis part to R
    self.index["returnArea"] = False
    toolrandomRpart.doSpatialAnalysis(self.R, self.index)
    self.btnApply.setEnabled(True)
    # save
    if self.index["save"]:
      resSave = self.ReadAllLayer.saveShape(self.index["outputFilePath"])
      if resSave == "error":
        self.progressBar.setValue(0)
        return
      self.getUniqueOutputFileName()
    self.progressBar.setValue(0)
