# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
# load available R packages
import sda4ppLoadRlib
# to check internet connection
import urllib2, os
# write to log file
import wl

class InstallRpackages(QDialog):
  def __init__(self, iface):
    QDialog.__init__(self)
    self.iface = iface
    dt = "installRpackages-__init__"
    ## check to have pywin32, rpy2, R-cran
    error_win32api = ""
    error_rpy2 = ""
    error_rcran = ""
    # pywin32
    if os.name == "nt":
      try:
        import win32api
      except Exception, e:
        wl.wl("Plug-in will not perform properly, Pywin32 is missing;\n" + str(e),dt)
        error_win32api = "Pywin32 (Python module) is missing. Please, install it."
    # rpy2
    try:
      import rpy2
    except Exception, e:
      wl.wl("Plug-in will not perform properly, Rpy2 is missing;\n" + str(e),dt)
      error_rpy2 = "Rpy2 (Python module) is missing. Please, install it."
    # R
    try:
      import rpy2.robjects as robjects
      self.r = robjects.r
    except Exception, e:
      wl.wl("Plug-in will not perform properly, rpy2 could not call R-cran;\n" + str(e),dt)
      error_rcran = "Rpy2 could not call R-cran. Check Rpy2, R-cran and path definitions."
    ## check error
    if (error_win32api == "") and (error_rpy2 == "") and (error_rcran == ""):
      ## no error
      # rgdal
      self.chk_rgdal = QCheckBox()
      self.chk_rgdal.setText("install rgdal with all dependencies")
      res = sda4ppLoadRlib.loadRgdal(self.r)
      if res:
        status_rgdal = QLabel("Installed")
        self.chk_rgdal.setChecked(False)
      else:
        status_rgdal = QLabel("Not Installed")
        self.chk_rgdal.setChecked(True)
      # maptools
      self.chk_maptools = QCheckBox()
      self.chk_maptools.setText("install maptools with all dependencies")
      res = sda4ppLoadRlib.loadMaptools(self.r)
      if res:
        status_maptools = QLabel("Installed")
        self.chk_maptools.setChecked(False)
      else:
        status_maptools = QLabel("Not Installed")
        self.chk_maptools.setChecked(True)
      # spatstat
      self.chk_spatstat = QCheckBox()
      self.chk_spatstat.setText("install spatstat with all dependencies")
      res = sda4ppLoadRlib.loadSpatstat(self.r)
      if res:
        status_spatstat = QLabel("Installed")
        self.chk_spatstat.setChecked(False)
      else:
        status_spatstat = QLabel("Not Installed")
        self.chk_spatstat.setChecked(True)
      # rggobi
      self.chk_rggobi = QCheckBox()
      self.chk_rggobi.setText("install rggobi with all dependencies")
      res = sda4ppLoadRlib.loadRggobi(self.r)
      if res:
        status_rggobi = QLabel("Installed")
        self.chk_rggobi.setChecked(False)
      else:
        status_rggobi = QLabel("Not Installed")
        self.chk_rggobi.setChecked(True)
      # iplots
      self.chk_iplots = QCheckBox()
      self.chk_iplots.setText("install iplots with all dependencies")
      res = sda4ppLoadRlib.loadIplot(self.r)
      if res:
        status_iplots = QLabel("Installed")
        self.chk_iplots.setChecked(False)
      else:
        status_iplots = QLabel("Not Installed")
        self.chk_iplots.setChecked(True)
      # automap
      self.chk_automap = QCheckBox()
      self.chk_automap.setText("install automap with all dependencies")
      res = sda4ppLoadRlib.loadAutomap(self.r)
      if res:
        status_automap = QLabel("Installed")
        self.chk_automap.setChecked(False)
      else:
        status_automap = QLabel("Not Installed")
        self.chk_automap.setChecked(True)

      header0 = QLabel("<b>Package Name\t</b>")
      header1 = QLabel("<b>Required for Tools\t</b>")
      header2 = QLabel("<b>Status of Package\t</b>")
      header3 = QLabel("<b>Select Checkbox to install the package\t</b>")

      package0 = QLabel("rgdal")
      package1 = QLabel("maptools")
      package2 = QLabel("spatstat")
      package3 = QLabel("rggobi")
      package4 = QLabel("iplots")
      package5 = QLabel("automap")

      tools0 = QLabel("All tools")
      tools1 = QLabel("Most of the tools")
      tools2 = QLabel("Most of the tools")
      tools3 = QLabel("Rggobi")
      tools4 = QLabel("Linked Statistical Display")
      tools5 = QLabel("Kriging")

      grid = QGridLayout()
      grid.addWidget(header0, 0, 0)
      grid.addWidget(header1, 0, 1)
      grid.addWidget(header2, 0, 2)
      grid.addWidget(header3, 0, 3)

      grid.addWidget(package0, 1, 0)
      grid.addWidget(package1, 2, 0)
      grid.addWidget(package2, 3, 0)
      grid.addWidget(package3, 4, 0)
      grid.addWidget(package4, 5, 0)
      grid.addWidget(package5, 6, 0)

      grid.addWidget(tools0, 1, 1)
      grid.addWidget(tools1, 2, 1)
      grid.addWidget(tools2, 3, 1)
      grid.addWidget(tools3, 4, 1)
      grid.addWidget(tools4, 5, 1)
      grid.addWidget(tools5, 6, 1)

      grid.addWidget(status_rgdal, 1, 2)
      grid.addWidget(status_maptools, 2, 2)
      grid.addWidget(status_spatstat, 3, 2)
      grid.addWidget(status_rggobi, 4, 2)
      grid.addWidget(status_iplots, 5, 2)
      grid.addWidget(status_automap, 6, 2)

      grid.addWidget(self.chk_rgdal, 1, 3)
      grid.addWidget(self.chk_maptools, 2, 3)
      grid.addWidget(self.chk_spatstat, 3, 3)
      grid.addWidget(self.chk_rggobi, 4, 3)
      grid.addWidget(self.chk_iplots, 5, 3)
      grid.addWidget(self.chk_automap, 6, 3)

      btnApply = QPushButton()
      btnApply.setText("Install selected R Packages")
      btnCancel = QPushButton()
      btnCancel.setText("Close")

      layout = QHBoxLayout()
      layout.addWidget(btnApply)
      layout.addWidget(btnCancel)

      main = QVBoxLayout()
      main.addLayout(grid)
      main.addLayout(layout)
      self.setLayout(main)
      self.setWindowTitle("Install Missing R Packages")

      self.connect(btnApply, SIGNAL("clicked()"), self.install)
      self.connect(btnCancel, SIGNAL("clicked()"), self.close)

    else:
      ## error part
      header0 = QLabel("<b>Name\t</b>")
      header1 = QLabel("<b>Status of Component\t</b>")

      package0 = QLabel("Rpy2")
      package1 = QLabel("R-cran")
      package2 = QLabel("Pywin32")

      # rpy2
      if error_rpy2 == "":
        lbl_status0 = QLabel("Installed")
      else:
        lbl_status0 = QLabel(error_rpy2)
      # r-cran
      if error_rcran == "":
        lbl_status1 = QLabel("Installed")
      else:
        lbl_status1 = QLabel(error_rcran)
      # pywin32
      if os.name == "nt":
        if error_win32api == "":
          lbl_status2 = QLabel("Installed")
        else:
          lbl_status2 = QLabel(error_win32api)
      else:
        lbl_status2 = QLabel("Not required for Linux")

      grid = QGridLayout()
      grid.addWidget(header0, 0, 0)
      grid.addWidget(header1, 0, 1)

      grid.addWidget(package0, 1, 0)
      grid.addWidget(package1, 2, 0)
      grid.addWidget(package2, 3, 0)

      grid.addWidget(lbl_status0, 1, 1)
      grid.addWidget(lbl_status1, 2, 1)
      grid.addWidget(lbl_status2, 3, 1)

      btnCancel = QPushButton()
      btnCancel.setText("Close")

      layout = QHBoxLayout()
      layout.addWidget(btnCancel)

      main = QVBoxLayout()
      main.addLayout(grid)
      main.addLayout(layout)
      self.setLayout(main)
      self.setWindowTitle("Components")

      self.connect(btnCancel, SIGNAL("clicked()"), self.close)

  def close(self):
    self.reject()

  def install(self):
    dt = "installRpackages-install"
    # internet
    try:
      test = urllib2.urlopen("http://www.google.com")
    except Exception, e:
      QMessageBox.information(self.iface.mainWindow(),
                "SDA4PP Plugin Error",
                "Internet connection could not be found.")
      wl.wl("Internet connection could not be found;\n" + str(e),dt)
      return
    selPac = {"rgdal":False,"maptools":False,"spatstat":False,
		"rggobi":False,"iplots":False,"automap":False}
    # is package selected
    if self.chk_rgdal.checkState() == 2: selPac["rgdal"] = True
    if self.chk_maptools.checkState() == 2: selPac["maptools"] = True
    if self.chk_spatstat.checkState() == 2: selPac["spatstat"] = True
    if self.chk_rggobi.checkState() == 2: selPac["rggobi"] = True
    if self.chk_iplots.checkState() == 2: selPac["iplots"] = True
    if self.chk_automap.checkState() == 2: selPac["automap"] = True
    # execute
    notSelected = True
    for packageName in ["rgdal","maptools","spatstat","rggobi","iplots","automap"]:
      if selPac[packageName]:
        wl.wl("trying to install "+str(packageName)+" package.",dt)
        try:
          from rpy2 import robjects
          r = robjects.r
          rInput = "install.packages(\""+str(packageName)+"\", dependencies = TRUE)"
          exec "output = r(''' capture.output(" + str(rInput) + ") ''')"
          #output = self.r("install.packages(\""+str(packageName)+"\", dependencies = TRUE)")
          notSelected = False
        except Exception, e:
          QMessageBox.information(self.iface.mainWindow(),
                 "SDA4PP Plugin Error",
                 str(packageName)+ " could not be installed;\n" + str(e))
          wl.wl(str(packageName)+ " could not be installed;\n" + str(e),dt)
          return
    # result
    if notSelected:
      QMessageBox.information(self.iface.mainWindow(),
                 "SDA4PP Plugin Error",
                 "No package is selected.")
      wl.wl("No package is selected to install.",dt)
      return
    else:
      QMessageBox.information(self.iface.mainWindow(),
                 "SDA4PP Plugin Info",
                 "The result of package installation is: "+str(output)+\
                 "\n\nTo load the package, please re-load the plug-in or re-start QGIS.")
      wl.wl("output: "+str(output),dt)
      self.reject()
