# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
# R options
import sda4ppRoptions
# write to logFile.log
import wl

def doSpatialAnalysis (r, index):
  dt="poissonRpart-doSpatialAnalysis"
  wl.wl("index: " +str(index),dt)
  # to ppp format
  r("v_sp <- as(v_spdf,\"SpatialPoints\")")
  r("v_ppp <- as(v_sp,\"ppp\")")
  # method
  if index["method"] == "~side(x)":
    r("side <- function(z) factor(ifelse(z < " + \
      str(index["userSideX"]) + ",\"left\",\"right\"))")
    txtRst = r("fit <- ppm(v_ppp, ~side(x))")
  elif index["method"] == "~custom(x)":
    txtRst = r("fit <- ppm(v_ppp, ~" + str(index["userCustom"]) + ")")
  else:
    txtRst = r("fit <- ppm(v_ppp, " + str(index["method"]) + ")")
  # plot
  if index["plot"]:
    # pixel size
    if index["changePixel"]:
      rcodes = ["plot(predict(fit, type = \"" + str(index["plotType"]) + \
                "\", ngrid = c(" + str(index["pixelX"]) + "," + \
                str(index["pixelY"]) + ")))",
                "plot(v_ppp, add=TRUE)"]
    else:
      rcodes = ["plot(predict(fit, type = \"" + str(index["plotType"]) + "\"))",
                "plot(v_ppp, add=TRUE)"]
    sda4ppRoptions.plotGraphics(r, rcodes)
  # save
  if index["save"]:
    if index["changePixel"]:
      r("real_im <- predict(fit, type = \"" + str(index["plotType"]) + \
        "\", ngrid = c(" + str(index["pixelX"]) + "," + \
        str(index["pixelY"]) + "))")
    else:
      r("real_im <- predict(fit, type = \"" + str(index["plotType"]) + \
        "\")")
    r("sgdf<- as.SpatialGridDataFrame.im(real_im)")
    r("writeGDAL(sgdf,\"" + str(index["outputFilePath"]) + \
      "\", drivername = \"" + str(index["rstfile"]) + \
      "\", type = \"Float32\")")
  return str(txtRst)
