# -*- coding: utf-8 -*-
"""
/**************************************************************************
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
from PyQt4.QtCore import *
from PyQt4.QtGui import *

from qgis.core import *
from qgis.gui import *

from ui_menuInfo import Ui_infoDialog
import os, wl

class UiInfoControl(QDialog, Ui_infoDialog):
  def __init__(self, parent, flag):
    QDialog.__init__(self, parent, flag)
    self.setupUi(self)
    self.setFixedSize(self.size())

class InfoGuiControl(QgsMapTool):
  def __init__(self, canvas):
    QgsMapTool.__init__(self, canvas)
    self.canvas = canvas
    self.cursor = QCursor(Qt.CrossCursor)
  def canvasPressEvent(self,event):
    pass
  def canvasMoveEvent(self,event):
    pass
  def canvasReleaseEvent(self,event):
    self.emit(SIGNAL("finished(PyQt_PyObject)"),
              {'x': event.pos().x(), 'y': event.pos().y()})
  def activate(self):
    QgsMapTool.activate(self)
    self.canvas.setCursor(self.cursor)
  def deactivate(self):
    QgsMapTool.deactivate(self)
  def isZoomTool(self):
    return False
