# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
# R options
import sda4ppRoptions
# write to logFile.log
import wl

def doSpatialAnalysis (r, index):
  dt="krigingRpart-doSpatialAnalysis"
  wl.wl("index: " +str(index),dt)
  # reading input_data
  s = r("point_df = as.data.frame(v_spdf)")
  s = r("names(point_df)[which(names(point_df)==\"coords.x1\")]=\"x\"")
  s = r("names(point_df)[which(names(point_df)==\"coords.x2\")]=\"y\"")
  s = r("coordinates(point_df) = ~x+y")
  s = r(str(index["inputFileName"]) + " = point_df")
  # autofitVariogram
  if index["plotVariogram"]:
    s = r("plot(" + str(index["autovar"]) + ")")
    wl.wl("plotVariogram: " +str(s),dt)
    return 0
  # reading new_data
  if index["new_data"] != "" and \
         index["new_dataType"] == "SpatialGridDataFrame":
    try:
      s = r(str(index["new_dataFile"]) + " = readGDAL(\"" + \
          str(index["new_dataPath"]) + "\")")
    except Exception, e:
      return sda4ppRoptions.findError(e, str(index["new_dataFile"]))
  elif index["new_data"] != "" and \
           index["new_dataType"] == "SpatialPointsDataFrame":
    try:
      s = r("point_new = readOGR(dsn=\"" + str(index["new_dataPath"]) + \
          "\", layer=\"" + str(index["new_dataFile"]) + "\")")
    except Exception, e:
      return sda4ppRoptions.findError(e, str(index["new_dataFile"]))
    rcodeText = "convex_hull = " + \
            "chull(coordinates(point_new)[,1],coordinates(point_new)[,2])"
    s = r(rcodeText)
    s = r("convex_hull = c(convex_hull, convex_hull[1])")
    s = r("d = Polygon(point_new[convex_hull,])")
    s = r("point_new_sp = spsample(d, 5000, type = \"regular\")")
    s = r("point_new_df = as.data.frame(point_new_sp)")
    s = r("names(point_new_df)[which(names(point_new_df)==\"x1\")]=\"x\"")
    s = r("names(point_new_df)[which(names(point_new_df)==\"x2\")]=\"y\"")
    s = r("gridded(point_new_df) = ~x+y")
    s = r(str(index["new_dataFile"]) + " = point_new_df")
  # autoKrige
  s = r("kr = " + str(index["autokrige"]))
  # save
  if index["save"]:
    s = r("writeGDAL(kr$krige_output,\"" + str(index["outputFilePath"]) + \
                "\", drivername = \"" + str(index["rstfile"]) + \
                "\", type = \"Float32\")")
    wl.wl("save: " +str(s),dt)
  # plot
  if index["plot"]:
    rcodes = ["plot(kr)"]
    sda4ppRoptions.plotGraphics(r, rcodes)
  return 0
