# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
# R options
import sda4ppRoptions
# write to logFile.log
import wl

def doSpatialAnalysis (r, index):
  dt = "GFestimateRpart-doSpatialAnalysis"
  r("sp_est <- as(v_spdf,\"SpatialPoints\")")
  r("ppp_est <- as(sp_est,\"ppp\")")
  r("function_gf <- " + str(index["functionName"]) + "(ppp_est)")
  # title
  if index["functionName"] == "Gest":
    mainTitle = "Nearest Neighbour Distance Function G"
  else:
    mainTitle = "Estimate the empty space function F"
  # linked display part
  if index["linkDisp"] == 2: # true
    r('par(mfrow=c(1,1))')
    r("plot(function_gf, " + str(index["axisY"]) + " ~ " + str(index["axisX"]) + \
        ", main=\"" + str(mainTitle) + "\")")
    # read value of x & y axis from the R plot when the user clicked on it.
    pt = r("pt <- locator(n=1, type = \"p\")")
    r("text(pt$x, pt$y, paste(\"x:\", round(pt$x,3), \",\", \"y:\", round(pt$y,3)), pos=3)")
    ptx = r("pt$x")
    ptx = round(ptx[0],3)
    ids = r("InputID <- seq(0,ppp_est$n-1)")
    whichs = r("Which <- nnwhich(ppp_est)")
    dists = r("Dist <- nndist(ppp_est)")
    #id
    pyids = []
    for id in ids:
      pyids.append(id)
    ##wl.wl ("pyids: " + str(pyids), dt)
    #which
    pywhichs = []
    for which in whichs:
      pywhichs.append(which - 1)
    ##wl.wl ("pywhichs: " + str(pywhichs), dt)
    # dist
    pydists = []
    for dist in dists:
      pydists.append(dist)
    ##wl.wl ("pydists: " + str(pydists), dt)
    # combine them into dict
    distAlls = {}
    for i in range(len(pyids)):
      twoList = str(pyids[i]) + "|" + str(pywhichs[i])
      keyDist = pydists[i]
      distAlls[keyDist] = twoList
    ##wl.wl ("distAlls: " + str(distAlls), dt)
    # smaller distance should return
    selDist = []
    for dist in distAlls.keys():
      if dist <= ptx:
        id = int(distAlls[dist].split("|")[0])
        which = int(distAlls[dist].split("|")[1])
        if id not in selDist:
          selDist.append(id)
        if which not in selDist:
          selDist.append(which)
    ##wl.wl ("selDist: " + str(selDist), dt)
    return selDist
  else:
    # plot
    rcodes = ["plot(function_gf, " + str(index["axisY"]) + " ~ " + str(index["axisX"]) + \
              ", main=\"" + str(mainTitle) + "\")"]
    sda4ppRoptions.plotGraphics(r, rcodes)
  return 0
