# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
# R options
import sda4ppRoptions
# write to logFile.log
import wl

def doSpatialAnalysis (r, index):
  dt="randomRpart-doSpatialAnalysis"
  wl.wl("index: " +str(index),dt)
  # owin
  if index["unitSquare"] == 1:
    r("rect <- owin(xrange=c(0,1), yrange=c(0,1))")
  else:
    r("rect <- owin(xrange=c(" + str(index["xmin"]) + \
      "," + str(index["xmax"]) + "), yrange=c(" + \
      str(index["ymin"]) + "," + str(index["ymax"]) + "))")
  # returnArea
  if index["returnArea"]:
    area_owin = r("area.owin(rect)")
    wl.wl("area_owin: " +str(area_owin[0]),dt)
    return area_owin[0]
  # method
  if index["random"] == "homo":
    r("pp <- rpoispp(" + str(index["Intensity"]) + \
      ", win=owin(rect$xrange,rect$yrange))")
  elif index["random"] == "inhomo":
    r("lamb <- function(x,y) {" + str(index["Equation"]) + "}")
    r("pp <- rpoispp(lamb, " + str(index["Intensity"]) + \
      ", win=owin(rect$xrange,rect$yrange))")
  elif index["random"] == "inhomoCoef":
    r("lamb <- function(x,y,a) {" + str(index["Equation"]) + "}")
    r("pp <- rpoispp(lamb, " + str(index["Intensity"]) + ", a=" + \
      str(index["Addxa"]) + ", win=owin(rect$xrange,rect$yrange))")
  elif index["random"] == "gauss":
    r("pp <- rGaussPoisson(" + str(index["Intensity"]) + ", " + \
      str(index["Diameter"]) + ", " + str(index["Probability"]) + \
      ", win=owin(rect$xrange,rect$yrange))")
  # plot
  if index["plot"]:
    rcodes = ["plot(pp, main=\"Random Point Pattern\")"]
    sda4ppRoptions.plotGraphics(r, rcodes)
  # save
  if index["save"]:
    r("sp <- as.SpatialPoints.ppp(pp)")
    r("df = data.frame(ids=seq(0,pp$n-1))")
    r("spdf = SpatialPointsDataFrame(sp, df)")
    r("writeOGR(spdf,\"" + str(index["outputFilePath"]) + "\",\"" + \
      str(index["outputFileName"]) + "\", driver=\"ESRI Shapefile\")")
  return 0
