# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
from PyQt4 import QtCore
from PyQt4 import QtGui
from qgis.core import *
# import the code for the dialog
from ui_histogram import Ui_histogramDialog
#handling outputFile: path name, file name and extension
import os
# run R code
import histogramRpart
# write to logFile.log
import wl
# dialog for open help file
import sda4ppDisplayHelpFile
# reading qgis layer
import sda4ppReadQGISLayer
# R options
import sda4ppRoptions

class HistogramTool(QtGui.QDialog, Ui_histogramDialog):
  def __init__(self, iface):
    QtGui.QDialog.__init__(self)
    # save reference to the QGIS interface
    self.iface = iface
    # Set up the user interface from Designer.
    self.setupUi(self)
    self.setFixedSize(self.size())
    # init variables
    self.index = {"inputFilePath":"","inputFileName":"","fieldName":"",
                  "breaks":"", "column":"", "border":"", "main":"",
				  "xlab":"", "labels":"TRUE", "readogrError":"",
                  "border":"black", "column":"gray"
                  }
    self.wdgt_border.setStyleSheet("QWidget { background-color: black }" )
    self.wdgt_bar.setStyleSheet("QWidget { background-color: gray }" )
    # read the name of qgis layer
    self.readInputFile()
    self.progressBar.setValue(0)
    QtCore.QObject.connect(self.chkLabel,
                           QtCore.SIGNAL("clicked()"),
                           self.chkLabel_changed)
    QtCore.QObject.connect(self.cmbPointLayer,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbPointLayer_changed)
    QtCore.QObject.connect(self.cmbFieldName,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbFieldName_changed)
    QtCore.QObject.connect(self.btnApply, QtCore.SIGNAL("clicked()"),
                           self.runApply)
    QtCore.QObject.connect(self.btnHelp, QtCore.SIGNAL("clicked()"),
                           self.runHelp)
    QtCore.QObject.connect(self.btnCancel, QtCore.SIGNAL("clicked()"),
                           self.runClose)
    QtCore.QObject.connect(self.btnColorBar, QtCore.SIGNAL("clicked()"),
                           self.runColorBar)
    QtCore.QObject.connect(self.btnColorBorder, QtCore.SIGNAL("clicked()"),
                           self.runColorBorder)

  def runColorBorder(self):
    colBorder = QtGui.QColorDialog.getColor()
    if colBorder.isValid():
      self.index["border"] = str(colBorder.name())
      self.wdgt_border.setStyleSheet("QWidget { background-color: %s }" 
            % colBorder.name())


  def runColorBar(self):
    colBar = QtGui.QColorDialog.getColor()
    if colBar.isValid():
      self.index["column"] = str(colBar.name())
      self.wdgt_bar.setStyleSheet("QWidget { background-color: %s }" 
            % colBar.name())

  def runClose(self):
    sda4ppRoptions.closeRplot(self.R)
    self.reject()

  def runHelp(self):
    sda4ppDisplayHelpFile.DisplayHelpFile("histogram")

  def chkLabel_changed(self):
    if self.chkLabel.checkState() == 2:
      self.index["labels"] = "TRUE" # in the R format
    elif self.chkLabel.checkState() == 0:
      self.index["labels"] = "FALSE" # in the R format

  def cmbPointLayer_changed(self):
    dt = "histogram-cmbPointLayer_changed"
    self.index["readogrError"] = ""
    #update source of layer
    (self.index["inputFilePath"], self.index["inputFileName"], self.index["geometryType"]) = \
       self.ReadPointLayer.getFileSource (self.cmbPointLayer.currentText())
    # readOGR
    error = sda4ppRoptions.readOGR(self.R,self.index["inputFilePath"],self.index["inputFileName"])
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return
    # field names
    self.cmbFieldName.clear()
    fields = self.ReadPointLayer.getFieldNameList()
    wl.wl("fields: " +str(fields),dt)
    if fields == []:
      self.index["nonumericfieldError"] = \
              "This tool requires at least one numeric field.\n\n" +\
              "Please, add one numeric field to the layer, '" +\
              self.index["inputFileName"] + \
              "',nor do not use this layer for this analysis."
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", self.index["nonumericfieldError"])
      self.index["fieldName"] = ""
    else:
      for field in fields:
        self.cmbFieldName.addItem(field)
      self.index["nonumericfieldError"] = ""
      self.index["fieldName"] = fields[0]
    wl.wl("index: " +str(self.index),dt)

  def cmbFieldName_changed(self):
    self.index["nonumericfieldError"] = ""
    self.index["fieldName"] = str(self.cmbFieldName.currentText())

  def readInputFile(self):
    dt = "histogram-readInputFile"
    # init rpy2
    import rpy2.robjects as robjects
    self.R = robjects.r
    # SECTION: POINT
    self.ReadPointLayer = sda4ppReadQGISLayer.ReadQgisLayer(self.iface, "all")
    layers = self.ReadPointLayer.getLayerList(checkNumericField="YES")
    wl.wl("layers: " +str(layers),dt)
    if layers == []:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
                        "SDA4PP Plugin Error",
                        "Please add vector layers in QGIS.")
      return
    for layer in layers:
      self.cmbPointLayer.addItem(layer)
    # inputFile
    (self.index["inputFilePath"], self.index["inputFileName"], self.index["geometryType"]) = \
       self.ReadPointLayer.getFileSource (self.cmbPointLayer.currentText())
    # field names
    self.cmbFieldName.clear()
    fields = self.ReadPointLayer.getFieldNameList()
    wl.wl("fields: " +str(fields),dt)
    if fields == []:
      self.index["nonumericfieldError"] = \
              "This tool requires at least one numeric field.\n\n" +\
              "Please, add one numeric field to the layer, '" +\
              self.index["inputFileName"] + \
              "',nor do not use this layer for this analysis."
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", self.index["nonumericfieldError"])
      self.index["fieldName"] = ""
    else:
      for field in fields:
        self.cmbFieldName.addItem(field)
      self.index["nonumericfieldError"] = ""
      self.index["fieldName"] = fields[0]
    # readOGR
    error = sda4ppRoptions.readOGR(self.R,self.index["inputFilePath"],self.index["inputFileName"])
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return
    wl.wl("index: " +str(self.index),dt)
    return

  def runApply(self):
    dt = "histogram-runApply"
    self.progressBar.setValue(5)
    #BEGIN SECTION: inputFile
    if self.cmbPointLayer.currentIndex() == -1:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "Please add vector layer in QGIS.")
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(10)
    # could not save postgis layer as shp file
    if self.index["inputFilePath"] == 'error':
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", self.index["inputFileName"])
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(15)
    # nonumericfieldError
    if self.index["nonumericfieldError"] != "":
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", self.index["nonumericfieldError"])
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(20)
    # readogrError
    if self.index["readogrError"] != "":
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", self.index["readogrError"])
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(25)
    # breaks
    self.index["breaks"] = str(self.txtBreaks.text())
    # main title
    self.index["main"] = str(self.txtMain.text())
    # X axis title
    self.index["xlab"] = str(self.txtAxis.text())
    #BEGIN SECTION: R part
    self.progressBar.setValue(100)
    wl.wl("index: " +str(self.index),dt)
    # apply analysis part to R
    self.btnApply.setEnabled(False)
    histogramRpart.doSpatialAnalysis(self.R,index= self.index)
    self.btnApply.setEnabled(True)
    self.progressBar.setValue(0)
