# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
from PyQt4 import QtCore
from PyQt4 import QtGui
from qgis.core import *
# import the code for the dialog
from ui_envelope import Ui_envelopeDialog
#handling outputFile: path name, file name and extension
import os
# run R code
import envelopeRpart
# write to logFile.log
import wl
# dialog for open help file and R code 
import sda4ppDisplayHelpFile
# reading qgis layer
import sda4ppReadQGISLayer
# R options
import sda4ppRoptions

class EnvelopeTool(QtGui.QDialog, Ui_envelopeDialog):
  def __init__(self, iface):
    QtGui.QDialog.__init__(self)
    # save reference to the QGIS interface
    self.iface = iface
    # Set up the user interface from Designer.
    self.setupUi(self)
    self.setFixedSize(self.size())
    # init variables
    self.index = {"inputFile":"", "fileBaseName":"",
                  "testFun":"Gest", "nSim":99}
    # read the name of qgis layer
    self.readInputFile()
    self.progressBar.setValue(0)
    # event part
    QtCore.QObject.connect(self.cmbPointLayer,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbPointLayer_changed)
    QtCore.QObject.connect(self.cmbFunctions,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbFunctions_changed)
    QtCore.QObject.connect(self.btnApply, QtCore.SIGNAL("clicked()"),
                           self.runApply)
    QtCore.QObject.connect(self.btnHelp, QtCore.SIGNAL("clicked()"),
                           self.runHelp)
    QtCore.QObject.connect(self.btnCancel, QtCore.SIGNAL("clicked()"),
                           self.runClose)

  def runClose(self):
    sda4ppRoptions.closeRplot(self.R)
    self.reject()

  def runHelp(self):
    sda4ppDisplayHelpFile.DisplayHelpFile("Envelope")

  def cmbFunctions_changed(self):
    if self.cmbFunctions.currentIndex() == 0:
      self.index["testFun"] = "Gest"
      self.grpExplanation.setTitle(" G Function ")
      self.lblExpImage.setPixmap(QtGui.QPixmap(":/icons/expEnvelopeG.png"))
    elif self.cmbFunctions.currentIndex() == 1:
      self.index["testFun"] = "Fest"
      self.grpExplanation.setTitle(" F Function ")
      self.lblExpImage.setPixmap(QtGui.QPixmap(":/icons/expEnvelopeF.png"))
    elif self.cmbFunctions.currentIndex() == 2:
      self.index["testFun"] = "Kest"
      self.grpExplanation.setTitle(" K Function ")
      self.lblExpImage.setPixmap(QtGui.QPixmap(":/icons/expEnvelopeG.png"))
    elif self.cmbFunctions.currentIndex() == 3:
      self.index["testFun"] = "Lest"
      self.grpExplanation.setTitle(" L Function ")
      self.lblExpImage.setPixmap(QtGui.QPixmap(":/icons/expEnvelopeG.png"))

  def cmbPointLayer_changed(self):
    dt = "envelope-cmbPointLayer_changed"
    #update source of layer
    (self.index["inputFilePath"], self.index["inputFileName"]) = \
       self.ReadPointLayer.getFileSource (self.cmbPointLayer.currentText())
    wl.wl("index: " + str(self.index),dt)
    # readOGR
    error = sda4ppRoptions.readOGR(self.R,self.index["inputFilePath"],self.index["inputFileName"])
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return

  def readInputFile(self):
    dt = "envelope-readInputFile"
    # init rpy2
    import rpy2.robjects as robjects
    self.R = robjects.r
    # reading qgis layer
    wl.wl("init ReadQGISLayer class for POINT layer.",dt)
    self.ReadPointLayer = sda4ppReadQGISLayer.ReadQgisLayer(self.iface)
    layers = self.ReadPointLayer.getLayerList()
    wl.wl("layers: " +str(layers),dt)
    if layers == []:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "Please add point typed vector layers in QGIS.")
      return
    for layer in layers:
      self.cmbPointLayer.addItem(layer)
    # inputfile
    (self.index["inputFilePath"], self.index["inputFileName"]) = \
       self.ReadPointLayer.getFileSource (self.cmbPointLayer.currentText())
    # readOGR
    error = sda4ppRoptions.readOGR(self.R,self.index["inputFilePath"],self.index["inputFileName"])
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return
    wl.wl("index: " + str(self.index),dt)
    return

  def runApply(self):
    dt = "envelope-runApply"
    self.progressBar.setValue(5)
    #BEGIN SECTION: inputFile
    if self.cmbPointLayer.currentIndex() == -1:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "Please add point typed vector layer in QGIS.")
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(10)
    # could not save postgis layer as shp file
    if self.index["inputFilePath"] == 'error':
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", self.index["inputFileName"])
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(15)
    # user input value
    (self.index["nSim"], errorText) = \
                wl.readIntTxtBox(self.txtNsim.text())
    if self.index["nSim"] == "error":
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", errorText)
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(100)
    #BEGIN SECTION: R part
    wl.wl("index: " + str(self.index),dt)
    self.btnApply.setEnabled(False)
    envelopeRpart.doSpatialAnalysis(self.R, self.index)
    self.btnApply.setEnabled(True)
    self.progressBar.setValue(0)
