# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
# R options
import sda4ppRoptions
# write to logFile.log
import wl

def doSpatialAnalysis (r, index):
  dt="nearRpart-doSpatialAnalysis"
  wl.wl("index: " +str(index),dt)
  # to ppp format
  r("sp_est <- as(v_spdf,\"SpatialPoints\")")
  r("X <- as(sp_est,\"ppp\")")
  # ONE point pattern
  if not (index["point2selected"]):
    r("Which <- nnwhich(X)")
    r("Dist <- nndist(X)")
    r("InputID <- seq(0,X$n-1)")
    r("dstMatrix <- pairdist(X)")
    # plot
    if index["Arrows"]:
      r("b <- X[Which]")
      rcodes = ["plot(X, main=\"Nearest Neighbor Point\")",
                "arrows(X$x, X$y, b$x, b$y, angle=15, length=0.15, col=\"red\")"]
      sda4ppRoptions.plotGraphics(r, rcodes)
  # TWO point pattern
  else:
    r("sp_est <- as(v2_spdf,\"SpatialPoints\")")
    r("Y <- as(sp_est,\"ppp\")")
    r("Which <- nncross(X,Y)$which")
    r("Dist <- nncross(X,Y)$dist")
    r("InputID <- seq(0,X$n-1)")
    # plot
    if index["Arrows"]:
      r("b <- Y[Which]")
      rcodes = ["plot(bounding.box(X$window,Y$window), main=\"Nearest Neighbor Point\")",
                "plot(X, add=TRUE)",
                "plot(Y, add=TRUE, cols=\"blue\")",
                "arrows(X$x, X$y, b$x, b$y, angle=15, length=0.15, col=\"red\")"]
      sda4ppRoptions.plotGraphics(r, rcodes)
  # save
  if index["Distance"]:
    lblResult = \
        r("df <- data.frame(inputID=InputID, targetID=Which, dist=Dist)")
  else:
    lblResult = r("df <- data.frame(inputID=InputID, targetID=Which)")
  # save output as csv file
  if index["Matrix"] and not (index["point2selected"]):
    r("write.csv(dstMatrix, file = \"" + str (index["outputFilePath"]) + "\")")
  return lblResult
