# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
from PyQt4 import QtCore
from PyQt4 import QtGui
from qgis.core import *
# import the code for the dialog
from ui_toolnear import Ui_toolnearDialog
#handling point1: path name, file name and extension
import os
# run R code
import toolnearRpart
# write to logFile.log
import wl
# dialog for open help file
import sda4ppDisplayHelpFile
# reading qgis layer
import sda4ppReadQGISLayer
# R options
import sda4ppRoptions

class NearTool(QtGui.QDialog, Ui_toolnearDialog):
  def __init__(self, iface):
    QtGui.QDialog.__init__(self)
    # save reference to the QGIS interface
    self.iface = iface
    # Set up the user interface from Designer.
    self.setupUi(self)
    self.setFixedSize(self.size())
    ## init variables
    self.index = {"Distance":True, "Arrows":False, "Matrix":False,
                  "point1path":"", "point1name":"",
                  "point2path":"", "point2name":"",
                  "pointLayer1":"", "pointLayer2":"",
                  "outputFilePath":"", "outputFileName":"",
                  "point2selected":False}
    # read the name of qgis layer
    self.readInputFile()
    self.progressBar.setValue(0)
    QtCore.QObject.connect(self.cmbPointFirst,
        QtCore.SIGNAL("activated(QString )"), self.cmbPointFirst_changed)
    QtCore.QObject.connect(self.cmbPointSecond,
        QtCore.SIGNAL("activated(QString )"), self.cmbPointSecond_changed)
    QtCore.QObject.connect(self.btnSave,
        QtCore.SIGNAL("clicked()"), self.btnSave_changed)
    QtCore.QObject.connect(self.btnApply,
        QtCore.SIGNAL("clicked()"), self.runApply)
    QtCore.QObject.connect(self.btnHelp,
        QtCore.SIGNAL("clicked()"), self.runHelp)
    QtCore.QObject.connect(self.btnCancel,
        QtCore.SIGNAL("clicked()"), self.runClose)
    QtCore.QObject.connect(self.chkDistance,
        QtCore.SIGNAL("clicked()"), self.chkDistance_changed)
    QtCore.QObject.connect(self.chkArrows,
        QtCore.SIGNAL("clicked()"), self.chkArrows_changed)
    QtCore.QObject.connect(self.chkMatrix,
        QtCore.SIGNAL("clicked()"), self.chkMatrix_changed)

  def chkDistance_changed(self):
    dt = "chkDistance_changed-toolnear"
    if self.chkDistance.checkState() == 2:
      self.index["Distance"] = True
    elif self.chkDistance.checkState() == 0:
      self.index["Distance"] = False
    wl.wl("index: " + str(self.index),dt)

  def runHelp(self):
    sda4ppDisplayHelpFile.DisplayHelpFile("toolnear")

  def runClose(self):
    sda4ppRoptions.closeRplot(self.R)
    self.reject()

  def getUniqueOutputFileName(self, file=""):
    notFileExist = 0
    counter = 0
    if file == "":
      file = self.ReadPointOne.createOutputDir() + "toolnear"
    while (notFileExist == 0):
      outputFilename = file + "_" + str(counter) + ".csv"
      if not(os.path.exists(outputFilename)):
        self.index["outputFilePath"] = outputFilename
        self.txtPath.setText(outputFilename)
        layerSource = QtCore.QFileInfo(outputFilename)
        self.index["outputFileName"] = str(layerSource.completeBaseName())
        notFileExist = 1
      else:
        counter = counter + 1

  def changeExtension(self):
    if self.index["outputFilePath"] != "":
      f = QtCore.QFileInfo(self.index["outputFilePath"])
      if f.suffix() != "csv":
        self.index["outputFilePath"] = f.path() + "/" + \
                                f.completeBaseName() + ".csv"
      if not(os.path.exists(self.index["outputFilePath"])):
        self.txtPath.setText(self.index["outputFilePath"])
        self.index["outputFileName"] = str(f.completeBaseName())
      else:
        file =f.path() + "/" + f.completeBaseName()
        self.getUniqueOutputFileName(file)

  def btnSave_changed(self):
    (self.index["outputFilePath"], foo) = self.ReadPointOne.saveDialog(self,
                                                    extension = "csv")
    if self.index["outputFilePath"] is None:
      self.index["outputFilePath"] = str(self.txtPath.text())
      return
    self.changeExtension()

  def chkMatrix_changed(self):
    dt = "toolnear-chkMatrix_changed"
    if self.chkMatrix.checkState() == 2:
      self.btnSave.setEnabled(True)
      self.txtPath.setEnabled(True)
      self.index["Matrix"] = True
      self.getUniqueOutputFileName()
    elif self.chkMatrix.checkState() == 0:
      self.btnSave.setEnabled(False)
      self.txtPath.setEnabled(False)
      self.txtPath.clear()
      self.index["Matrix"] = False
    wl.wl("index: " + str(self.index),dt)

  def chkArrows_changed(self):
    dt = "toolnear-chkArrows_changed"
    if self.chkArrows.checkState() == 2:
      self.index["Arrows"] = True
    elif self.chkArrows.checkState() == 0:
      self.index["Arrows"] = False
    wl.wl("index: " + str(self.index),dt)

  def cmbPointFirst_changed(self):
    dt = "toolnear-cmbPointFirst_changed"
    (self.index["point1path"], self.index["point1name"]) = \
        self.ReadPointOne.getFileSource (self.cmbPointFirst.currentText())
    wl.wl("index: " + str(self.index),dt)
    # readOGR
    error = sda4ppRoptions.readOGR(self.R, self.index["point1path"],self.index["point1name"])
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return

  def cmbPointSecond_changed(self):
    dt = "toolnear-cmbPointSecond_changed"
    if self.cmbPointSecond.currentIndex() == 0:
      self.index["point2selected"] = False
    else:
      # update source of layer
      (self.index["point2path"], self.index["point2name"]) = \
        self.ReadPointTwo.getFileSource (self.cmbPointSecond.currentText())
      self.index["point2selected"] = True
    wl.wl("index: " + str(self.index),dt)
    # readOGR
    error = sda4ppRoptions.readOGR(self.R, self.index["point2path"],
					self.index["point2name"],secondLayer="Selected")
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return

  def readInputFile(self):
    dt = "toolnear-readInputFile"
    # init rpy2
    import rpy2.robjects as robjects
    self.R = robjects.r
    # point one
    self.ReadPointOne = sda4ppReadQGISLayer.ReadQgisLayer(self.iface)
    layers = self.ReadPointOne.getLayerList()
    wl.wl("layers: " +str(layers),dt)
    if layers == []:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "Please add point typed vector layers in QGIS.")
      return
    for layer in layers:
      self.cmbPointFirst.addItem(layer)
    (self.index["point1path"], self.index["point1name"])  = \
        self.ReadPointOne.getFileSource (self.cmbPointFirst.currentText())
    wl.wl("index: " +str(self.index),dt)
    # point two
    wl.wl("init ReadQGISLayer class for SECOND POINT layer.",dt)
    self.ReadPointTwo = sda4ppReadQGISLayer.ReadQgisLayer(self.iface)
    layers = self.ReadPointTwo.getLayerList()
    for layer in layers:
      self.cmbPointSecond.addItem(layer)
    # readOGR
    error = sda4ppRoptions.readOGR(self.R, self.index["point1path"],self.index["point1name"])
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return
    return

  def runApply(self):
    dt = "toolnear-runApply"
    self.lblResult.clear()
    self.progressBar.setValue(5)
    #BEGIN SECTION: inputFile
    if self.cmbPointFirst.currentIndex() == -1:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "Please add point typed vector layer in QGIS.")

      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(10)
    # could not save postgis layer as shp file
    if self.index["point1path"] == 'error':
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", self.index["point1name"])
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(15)
    # check either one pattern or two
    if self.index["point1name"] == self.index["point2name"]:
      self.index["point2selected"] = False
    # SECTION: R part
    self.progressBar.setValue(20)
    self.btnApply.setEnabled(False)
    wl.wl("index: " +str(self.index),dt)
    if self.index["point2selected"]:
      error = sda4ppRoptions.readOGR(self.R, self.index["point2path"],self.index["point2name"],secondLayer="YES")
      if error != 0:
        QtGui.QMessageBox.information(self.iface.mainWindow(),
              "SDA4PP Plugin Error", error)
        self.progressBar.setValue(0)
        return
    # apply analysis part to R
    lstResult = toolnearRpart.doSpatialAnalysis(self.R, index=self.index)
    # DISTANCE: output formating and changing index
    resLst = []
    for j in range(len(lstResult[0])):
      for i in range(len(lstResult)):
        resLst.append(lstResult[i][j])
    wl.wl("resLst: " +str(resLst),dt)
    self.progressBar.setValue(90)
    if self.index["Distance"]:
      resText = "InputID,TargetID,Distance\n"
      for i in range(0,len(resLst)-1,3):
        resText += str(resLst[i]) + ","
        resText += str(resLst[i+1]-1) + ","
        resText += str(resLst[i+2]) + "\n"
    else:
      resText = "InputID,TargetID\n"
      for i in range(0,len(resLst)-1,2):
        resText += str(resLst[i]) + ","
        resText += str(resLst[i+1]-1) + "\n"
    self.lblResult.setText(resText)
    self.progressBar.setValue(100)
    if self.index["Matrix"] and not (self.index["point2selected"]):
      # DISTANCE MATRIX for ONE LAYER
      f = open(self.index["outputFilePath"], "r")
      csvList = f.readlines()
      f.close()
      firstLine = csvList[0].split(",")
      # formating "Vn" to "Vn-1"
      for i in range(1,len(firstLine)):
        if firstLine[i].find("\n") != -1:
          firstLine[i] = firstLine[i].replace("\n","")
        textV = str(firstLine[i])[2:-1]
        firstLine[i] = '"V' + str(int(textV)-1) + '"'
      firstLine[-1] = firstLine[-1] + '\n'
      txt = ""
      for i in range(len(firstLine)):
        txt += firstLine[i] + ','
      csvList[0] = txt[:-1]
      # formating "n" to "n-1"
      for i in range(1,len(csvList)):
        lineList = csvList[i].split(",")
        textID = lineList[0][1:-1]
        lineList[0] = '"' + str(int(textID)-1) + '"'
        txt = ""
        for j in range(len(lineList)):
          txt += lineList[j] + ','
        csvList[i] = txt[:-1]
      csvWrite = ""
      for i in range(len(csvList)):
        csvWrite += csvList[i]
      f = open(self.index["outputFilePath"], "w")
      f.write(csvWrite)
      f.close()
      self.txtPath.clear()
      self.getUniqueOutputFileName()
    elif self.index["Matrix"] and self.index["point2selected"]:
      # DISTANCE MATRIX for TWO LAYER
      self.index["pointLayer1"] = self.ReadPointTwo.updateLayer (\
          self.cmbPointFirst.currentText())
      self.index["pointLayer2"] = self.ReadPointTwo.updateLayer (\
          self.cmbPointSecond.currentText())
      self.ReadPointTwo.doDistanceMatrix(layer1=self.index["pointLayer1"],
                                         layer2=self.index["pointLayer2"],
                                         outPath=self.index["outputFilePath"])
      self.txtPath.clear()
      self.getUniqueOutputFileName()
    # end
    self.btnApply.setEnabled(True)
    self.progressBar.setValue(0)
