# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
import os, webbrowser, tempfile
import time, threading
import wl
try:
  import rpy2.rinterface as rinterface
except:
  pass

def readOGR(r,path,layerName,secondLayer=""):
  # TODO: passing path and filename variables to readOGR by this way causes
  # unicode problem. If this is solved, the plugin can use unicode characters.
  try:
    if secondLayer == "":
      r("v_spdf <- readOGR(dsn=\"" + path + "\", layer=\"" + layerName + "\")")
    else:
      # toolnear needs to read second layer which should have different name
      r("v2_spdf <- readOGR(dsn=\"" + path + "\", layer=\"" + layerName + "\")")
  except Exception, e:
    return findError(e, layerName)
  return 0

def findError(e, layerName):
  dt = "sda4ppRoptions-findError"
  wl.wl("orjError: " +str(e),dt)
  realError = str(e).split(":")[1]
  realError = realError.strip()
  wl.wl("realError: " +str(realError),dt)
  knownError = {"Multiple # dimensions":"Multiple dimensions is not supported in this plugin.\n\nPlease do not use the layer, '" + \
                layerName + "', for this analysis.",
                "Incompatible geometry":"This type of geometry is not supported in this plugin.\n\nPlease do not use the layer, '" + \
                layerName + "', for this analysis.",
                "Geographical CRS given to non-conformant data":"The projection system of the layer, '" + \
                layerName + "' does not defined correctly.\n\nPlease, change the projection of this layer.",
                }
  try:
    expError = knownError[realError]
  except:
    expError = str(e)
  wl.wl("expError: " + str(expError),dt)
  return "An error occured:\n" + expError

def plotGraphics(r, rcodes):
  ## tools: intensity, quadrattest, localKL, kstest, kriging, density,
  ## adaptive, toolregular, toolrandom, toolpolygon, toolnear, toolcentroid
  dt = "sda4ppRoptions-plotGraphics"
  # reads values from settings
  index = wl.manageConfFile(mode="read", index="", tool="graphics")
  # save plot as png file
  if index["PNGdevice"]:
    # folder
    if index["folder"]:
      tempDir = tempfile.gettempdir()
      graphFolder = os.path.join(tempDir,"SDA4PP")
    else:
      graphFolder = os.path.join(index["folderPath"],"SDA4PP")
    if not(os.path.exists(graphFolder)):
      os.mkdir(graphFolder)
    # overwrite
    if index["overwrite"]:
      graphFileName = "plot.png"
    else:
      notFileExist = 0
      counter = 0
      while (notFileExist == 0):
        plotName = "plot_" + str(counter) + ".png"
        outputFilename = os.path.join(graphFolder, plotName)
        if not(os.path.exists(outputFilename)):
          graphFileName = "plot_" + str(counter) + ".png"
          notFileExist = 1
        else:
          counter = counter + 1
    # graphic path
    index["gPath"] = os.path.join(graphFolder, graphFileName)
    index["gPath"] = index["gPath"].replace("\\","/")
    # check min of graphic size
    if index["units"] == "px" and float(index["width"]) < 20.0:
      index["width"] = 20.0
      wl.wl("width of pixels of plotting area could not be smaller than 20",dt)
    elif index["units"] == "px" and float(index["height"]) < 20.0:
      index["height"] = 20.0
      wl.wl("height of pixels of plotting area could not be smaller than 20",dt)
    # save R code part
    r("png(filename=\"" + str(index["gPath"]) + "\",width=" + \
        str(index["width"]) + ",height=" + str(index["height"]) + \
        ",units=\"" + str(index["units"]) + "\",res=" + \
        str(index["res"]) + ")")
    for rcode in rcodes:
      r(rcode)
    r['dev.off']()
    webbrowser.open(index["gPath"])
  # use R-cran native plot device
  if index["Rdevice"]:
    setRdeviceSize(r)
    # r device refresh
    t = threading.Timer(0.1, r_refresh)
    t.start()
    # run r plot codes
    for rcode in rcodes:
      r(rcode)
  return 0

def setRdeviceSize(r):
  ## tools: plotGraphics function, envelope, GFestimate, KLripley
  dt = "sda4ppRoptions-setRdeviceSize"
  valueR = wl.manageConfFile(mode="read", index="", tool="rplot")
  # try with custom parameters of plugin
  if valueR["default"] == 0:
    try:
      param = "width=" + str(valueR["width"]) + ", height=" + str(valueR["height"]) + \
              ", xpos=" + str(valueR["xpos"]) + ", ypos=" + str(valueR["ypos"]) + \
              ", pointsize=" + str(valueR["pointsize"])
      wl.wl("param: " + str(param),dt)
      if os.name == "nt":
        r("windows(" + param + ")")
      else:
        r("X11.options(" + param + ")")
    except:
      # try with default custom parameters of plugin
      if os.name == "nt":
        r("windows(width=5, height=5, xpos=0, ypos=0, pointsize=9)")
      else:
        r("X11.options(width=5, height=5, xpos=0, ypos=0, pointsize=7)")
  return 0

def r_refresh(interval = 0.03):
  # Ctrl-C to interrupt
  while True:
    rinterface.process_revents()
    time.sleep(interval)

def closeRplot(r):
  ## tools: GFestimate, intensity, KLripley, kstest, kriging,
  ##        poisson, quadrattest, toolnear,
  dt = "sda4ppRoptions-closeRplot"
  r['graphics.off']()
  wl.wl("R-cran native plot device is closed.",dt)
  return 0
