# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
import os, wl

def checkPartners():
  dt="LoadRlib-checkPartners"
  # win32
  if os.name == "nt":
    wl.wl("Checking win32api.",dt)
    try:
      import win32api
    except Exception, e:
      wl.wl("Plug-in will not perform properly, Pywin32 is missing;\n" + str(e),dt)
      return False, "Plug-in will not perform properly, " + \
             "Pywin32 is missing, please install."
  # rpy2
  wl.wl("Checking rpy2.",dt)
  try:
    import rpy2
  except Exception, e:
    wl.wl("Plug-in will not perform properly, Rpy2 is missing;\n" + str(e),dt)
    return False, "Plug-in will not perform properly, " + \
             "Rpy2 is missing, please install."
  # R
  try:
    wl.wl("rpy2 version= " + str(rpy2.__version__))
  except Exception, e:
    wl.wl("Exception: "+str(e),dt)
    pass
  wl.wl("Checking R-cran.",dt)
  try:
    import rpy2.robjects as robjects
    r = robjects.r
  except Exception, e:
    wl.wl("Plug-in will not perform properly, Rpy2 could not call R-cran;\n" + str(e),dt)
    return False, "Plug-in will not perform properly, " + \
             "Rpy2 could not call R-cran."
  wl.wl("Plug-in will run, rpy2 and R are called.",dt)
  return True, r

def loadMaptools(r):
  dt="LoadRlib-loadMaptools"
  # loading maptools packages
  try:
    res = r.require("maptools", quietly = True)[0]
  except Exception, e:
    wl.wl( "maptools load error;\n" + str(e) ,dt)
    return False
  if res:
    wl.wl( "maptools package loaded. " ,dt)
    return True
  else:
    wl.wl( "maptools load error. " ,dt)
    return False

def loadSpatstat(r):
  dt="LoadRlib-loadSpatstat"
  # loading spatstat packages
  try:
    res = r.require("spatstat", quietly = True)[0]
  except Exception, e:
    wl.wl( "spatstat load error;\n" + str(e) ,dt)
    return False
  if res:
    wl.wl( "spatstat package loaded. " ,dt)
    return True
  else:
    wl.wl( "spatstat load error. " ,dt)
    return False

def loadRgdal(r):
  dt="LoadRlib-loadRgdal"
  # loading rgdal packages
  try:
    res = r.require("rgdal", quietly = True)[0]
  except Exception, e:
    wl.wl( "rgdal load error;\n" + str(e) ,dt)
    return False
  if res:
    wl.wl( "rgdal package loaded. " ,dt)
    return True
  else:
    wl.wl( "rgdal load error. " ,dt)
    return False

def loadRggobi(r):
  dt="LoadRlib-loadRggobi"
  # loading rggobi packages
  try:
    res = r.require("rggobi", quietly = True)[0]
  except Exception, e:
    wl.wl( "rggobi load error;\n" + str(e) ,dt)
    return False
  if res:
    wl.wl( "rggobi package loaded. " ,dt)
    return True
  else:
    wl.wl( "rggobi load error. " ,dt)
    return False

def loadIplot(r):
  dt="LoadRlib-loadIplot"
  ## check if it is installed
  # loading iplots packages
  try:
    res = r.require("iplots", quietly = True)[0]
  except Exception, e:
    wl.wl( "iplots load error;\n" + str(e) ,dt)
    return False
  if res:
    wl.wl( "iplots package loaded. " ,dt)
    return True
  else:
    wl.wl( "iplots load error. " ,dt)
    return False

def loadAutomap(r):
  dt="LoadRlib-loadAutomap"
  # loading automap packages
  try:
    res = r.require("automap", quietly = True)[0]
  except Exception, e:
    wl.wl( "automap load error;\n" + str(e) ,dt)
    return False
  if res:
    wl.wl( "automap package loaded. " ,dt)
    return True
  else:
    wl.wl( "automap load error. " ,dt)
    return False
