# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
# initialize Qt resources from file resouces.py
import resources_rc
# main menu
import intensity, adaptive, density, GFestimate, KLripley, localKL
import quadrattest, kstest, envelope, poisson, kriging, diggle
# tool menu
import toolrandom, toolregular, toolnear, toolcentroid, toolpolygon
# Table Analysis
import histogram, graphics
# display
import rggobi, iplot
# R console
import menuConsoleR
# load available R packages
import sda4ppLoadRlib
# install missing R packages
import sda4ppInstallRpackages
# interactive identify
from menuInfo import UiInfoControl
from menuInfo import InfoGuiControl
# interactive identify options
from menuInfoConf import UiConfControl
# graphic options
import menuGraphicsConf
# about
import menuAbout
# python utility
import os, time
# write to logFile.log
import wl

class SDA4PP:
  def __init__(self, iface):
    # save reference to the QGIS interface
    self.iface = iface
    self.canvas = iface.mapCanvas()
  def initGui(self):
    self.menu = QMenu("SDA4PP")
    # table analysis menu: init
    self.toolTable = QMenu("Table Analysis")
    self.toolTable.setIcon(QIcon(":/icons/menuTable.png"))
    self.histogram = QAction (QIcon(":/icons/tableHistogram.png"),
            "Histograms", self.iface.mainWindow())
    self.graphics = QAction (QIcon(":/icons/tableLattice.png"),
            "Lattice Graphics", self.iface.mainWindow())
    self.toolTable.addActions([self.histogram, self.graphics])
    # table analysis menu: event part
    QObject.connect(self.histogram, SIGNAL("triggered()"),
                    self.dohistogram)
    QObject.connect(self.graphics, SIGNAL("triggered()"),
                    self.dographics)
    # point tool menu: init
    self.toolMenu = QMenu("Point Utilities")
    self.toolMenu.setIcon(QIcon(":/icons/menuTool.png"))
    self.toolrandom = QAction (QIcon(":/icons/toolMenuRandom.png"),
            "Generate Random Point", self.iface.mainWindow())
    self.toolregular = QAction (QIcon(":/icons/toolMenuRegular.png"),
            "Generate Regular Point", self.iface.mainWindow())
    self.toolnear = QAction (QIcon(":/icons/toolMenuNear.png"),
            "Nearest Point and Distance", self.iface.mainWindow())
    self.toolcentroid = QAction (QIcon(":/icons/toolMenuCentroid.png"),
            "Polygon to Point (Centroid)", self.iface.mainWindow())
    self.toolpolygon = QAction (QIcon(":/icons/toolMenuPolygon.png"),
            "Point to Polygon (Dirichlet/Delaunay)", self.iface.mainWindow())
    self.toolMenu.addActions([self.toolrandom, self.toolregular,
                              self.toolnear, self.toolcentroid,
                              self.toolpolygon])
    # point tool menu: event part
    QObject.connect(self.toolrandom, SIGNAL("triggered()"),
                    self.dotoolrandom)
    QObject.connect(self.toolregular, SIGNAL("triggered()"),
                    self.dotoolRegular)
    QObject.connect(self.toolnear, SIGNAL("triggered()"),
                    self.dotoolNear)
    QObject.connect(self.toolcentroid, SIGNAL("triggered()"),
                    self.dotoolCentroid)
    QObject.connect(self.toolpolygon, SIGNAL("triggered()"),
                    self.dotoolPolygon)
    # main menu: init
    self.diggletool = QAction (QIcon(":/icons/menuDiggle.png"),
            "2nd Order Analysis-Diggle's D", self.iface.mainWindow())
    self.krigingtool = QAction (QIcon(":/icons/menuKriging.png"),
            "Kriging", self.iface.mainWindow())
    self.poissontool = QAction (QIcon(":/icons/menuPoisson.png"),
            "Fit Poisson Model", self.iface.mainWindow())
    self.kstesttool = QAction (QIcon(":/icons/menuKstest.png"),
            "Kolmogorov-Smirnov Test", self.iface.mainWindow())
    self.adaptivetool = QAction (QIcon(":/icons/menuAdaptive.png"),
            "Adaptive Density", self.iface.mainWindow())
    self.intensitytool = QAction (QIcon(":/icons/menuIntensity.png"),
            "Uniform Intensity", self.iface.mainWindow())
    self.quadrattesttool = QAction (QIcon(":/icons/menuQuad.png"),
            "Quadrat Test", self.iface.mainWindow())
    self.gfestimatetool = QAction (QIcon(":/icons/menuGFest.png"),
            "G and F Estimate Function", self.iface.mainWindow())
    self.klripleytool = QAction (QIcon(":/icons/menuRipleyKL.png"),
            "Ripley's K and L Function", self.iface.mainWindow())
    self.localKLtool = QAction (QIcon(":/icons/menuLocalKL.png"),
            "Local Ripley's K and L", self.iface.mainWindow())
    self.densitytool = QAction (QIcon(":/icons/menuDensity.png"),
            "Kernel Density", self.iface.mainWindow())
    self.csrTesttool = QAction (QIcon(":/icons/menuCSRtest.png"),
            "Simulation Envelope of CSR", self.iface.mainWindow())
    self.rggobitool = QAction (QIcon(":/icons/rggobi.png"),
            "Rggobi", self.iface.mainWindow())
    self.iplottool = QAction (QIcon(":/icons/iplot.png"),
            "Linked Statistical Display", self.iface.mainWindow())
    self.consoleR = QAction (QIcon(":/icons/menuRcon.png"),
            "R Console", self.iface.mainWindow())
    self.info = QAction (QIcon(":/icons/info.png"),
            "Interactive Identify", self.iface.mainWindow())
    self.infoConf = QAction (QIcon(":/icons/infoconf.png"),
            "Identify Options", self.iface.mainWindow())
    self.installRpackage = QAction (QIcon(":/icons/menuInstallRpackages.png"),
            "Components/R Packages", self.iface.mainWindow())
    self.graphicsConf = QAction (QIcon(":/icons/menuGraphicsConf.png"),
            "Graphic Options", self.iface.mainWindow())
    self.about = QAction (QIcon(":/icons/menuAbout.png"),
            "About", self.iface.mainWindow())
    import __init__
    dt = "NEW LOGGING-" + str(time.strftime('%d.%m.%Y %H:%M:%S'))
    wl.wl("SDA4PP, Version=" + str(__init__.version()), dt, "w")
    wl.wl("CLASS NAME | FUNCTION NAME | VARIABLE NAME = VALUE")
    dt = "sda4pp-initGui"
    try:
      wl.wl("pyqt version= " + str(qVersion()),dt)
      # version 4.4.3
      if QT_VERSION <= 0x040403:
        wl.wl("The plugin requires higher than PyQT4 version 4.4.3",dt)
    except Exception, e:
      wl.wl("Exception: "+str(e),dt)
      pass
    # check to have rpy2, R-cran
    (result, rInterface) = sda4ppLoadRlib.checkPartners()
    if not (result):
      # an error occured, the error is rInterface
      self.makeToolDisable(rInterface)
    else:
      # check to load three R library: 
      # basic; rgdal, and main; maptools, spatstat
      if sda4ppLoadRlib.loadRgdal(rInterface):
        wl.wl("rgdal package is loaded.",dt)
        if sda4ppLoadRlib.loadMaptools(rInterface):
          wl.wl("maptools package is loaded.",dt)
          if sda4ppLoadRlib.loadSpatstat(rInterface):
            wl.wl("spatstat package is loaded.",dt)
          else:
            self.makeToolDisable("spatstat")
        else:
          self.makeToolDisable("maptools")
      else:
        self.makeToolDisable("rgdal")
    # QSetting part
    wl.manageConfFile(mode="writeInit", index="")
    # main menu: event part
    QObject.connect(self.diggletool, SIGNAL("triggered()"),
                    self.doDiggleTool)
    QObject.connect(self.krigingtool, SIGNAL("triggered()"),
                    self.doKrigingTool)
    QObject.connect(self.poissontool, SIGNAL("triggered()"),
                    self.doPoissonTool)
    QObject.connect(self.kstesttool, SIGNAL("triggered()"),
                    self.doKstestTool)
    QObject.connect(self.adaptivetool, SIGNAL("triggered()"),
                    self.doAdaptiveTool)
    QObject.connect(self.intensitytool, SIGNAL("triggered()"),
                    self.doIntensityTool)
    QObject.connect(self.quadrattesttool, SIGNAL("triggered()"),
                    self.doQuadrattestTool)
    QObject.connect(self.gfestimatetool, SIGNAL("triggered()"),
                    self.doGFestimateTool)
    QObject.connect(self.klripleytool, SIGNAL("triggered()"),
                    self.doKLripleyTool)
    QObject.connect(self.localKLtool, SIGNAL("triggered()"),
                    self.dolocalKLTool)
    QObject.connect(self.densitytool, SIGNAL("triggered()"),
                    self.doDensityTool)
    QObject.connect(self.csrTesttool, SIGNAL("triggered()"),
                    self.doCsrTest)
    QObject.connect(self.rggobitool, SIGNAL("triggered()"),
                    self.doRggobiTool)
    QObject.connect(self.iplottool, SIGNAL("triggered()"),
                    self.doIplotTool)
    QObject.connect(self.consoleR, SIGNAL("triggered()"),
                    self.doConsoleR)
    QObject.connect(self.info, SIGNAL("triggered()"),
                    self.doInfo)
    QObject.connect(self.infoConf, SIGNAL("triggered()"),
                    self.doInfoConf)
    QObject.connect(self.installRpackage, SIGNAL("triggered()"),
                    self.doInstallRpackage)
    QObject.connect(self.graphicsConf, SIGNAL("triggered()"),
                    self.doGraphicsConf)
    QObject.connect(self.about, SIGNAL("triggered()"),
                    self.aboutRun)
    self.menu.addActions([self.intensitytool, self.densitytool,
                          self.adaptivetool, self.gfestimatetool,
                          self.klripleytool, self.localKLtool,
                          self.quadrattesttool, self.kstesttool,
                          self.csrTesttool, self.poissontool,
                          self.krigingtool, self.diggletool
                          ])
    self.menu.addSeparator()
    self.menu.addMenu(self.toolMenu)
    self.menu.addSeparator()
    self.menu.addMenu(self.toolTable)
    self.menu.addSeparator()
    self.menu.addActions([self.rggobitool, self.iplottool])
    self.menu.addSeparator()
    self.menu.addActions([self.consoleR, self.info, self.infoConf])
    self.menu.addSeparator()
    self.menu.addActions([self.installRpackage, self.graphicsConf, self.about])
    menuBar = self.iface.mainWindow().menuBar()
    actions = menuBar.actions()
    lastAction = actions[ len( actions ) - 1 ]
    menuBar.insertMenu( lastAction, self.menu )
    self.tool = InfoGuiControl(self.canvas)

  def makeToolDisable(self, packageName):
    dt = "sda4pp-makeToolDisable"
    basic = [self.intensitytool, self.densitytool,
               self.adaptivetool, self.gfestimatetool,
               self.klripleytool, self.localKLtool,
               self.quadrattesttool, self.kstesttool,
               self.csrTesttool, self.poissontool, self.krigingtool,
               self.toolrandom, self.toolregular, self.toolnear,
               self.toolcentroid, self.toolpolygon,
               self.rggobitool, self.iplottool, self.consoleR]
    main = [self.intensitytool, self.densitytool,
               self.adaptivetool, self.gfestimatetool,
               self.klripleytool, self.localKLtool,
               self.quadrattesttool, self.kstesttool,
               self.csrTesttool, self.poissontool,
               self.toolrandom, self.toolnear, self.toolpolygon]
    statusText = packageName + " package could not be loaded. " + \
                 "Please, install '" + packageName + \
                 "' package or use 'Component/R packages' tool."
    if packageName == "rgdal":
      tools = basic
    elif packageName == "maptools":
      tools = main
    elif packageName == "spatstat":
      tools = main
    else:
      # error is related with checkPartners;
      # rpy2, R-cran or win32api is missing.
      tools = basic
      statusText = packageName
    wl.wl("The error: " + str(statusText),dt)
    # disable tools and display error in the qgis status bar.
    for tool in tools:
      tool.setEnabled(False)
      tool.setStatusTip(statusText)

  def unload(self):
    pass
  # table menu part
  def dohistogram(self):
    d = histogram.HistogramTool(self.iface)
    d.exec_()
  def dographics(self):
    d = graphics.GraphicsTool(self.iface)
    d.exec_()
  # tool menu part
  def dotoolrandom(self):
    d = toolrandom.RandomTool(self.iface)
    d.exec_()
  def dotoolRegular(self):
    d = toolregular.RegularTool(self.iface)
    d.exec_()
  def dotoolNear(self):
    d = toolnear.NearTool(self.iface)
    d.exec_()
  def dotoolCentroid(self):
    d = toolcentroid.CentroidTool(self.iface)
    d.exec_()
  def dotoolPolygon(self):
    d = toolpolygon.PolygonTool(self.iface)
    d.exec_()
  # main menu part
  def doIntensityTool(self):
    d = intensity.IntensityTool(self.iface)
    d.exec_()
  def doDensityTool(self):
    d = density.DensityTool(self.iface)
    d.exec_()
  def doAdaptiveTool(self):
    d = adaptive.AdaptiveTool(self.iface)
    d.exec_()
  def doQuadrattestTool(self):
    d = quadrattest.QuadrattestTool(self.iface)
    d.exec_()
  def doKstestTool(self):
    d = kstest.KstestTool(self.iface)
    d.exec_()
  def doGFestimateTool(self):
    d = GFestimate.GFestimateTool(self.iface)
    d.exec_() 
  def doKLripleyTool(self):
    d = KLripley.KLripleyTool(self.iface)
    d.exec_()
  def dolocalKLTool(self):
    d = localKL.LocalKLTool(self.iface)
    d.exec_()
  def doCsrTest(self):
    d = envelope.EnvelopeTool(self.iface)
    d.exec_()
  def doPoissonTool(self):
    d = poisson.PoissonTool(self.iface)
    d.exec_()
  def doKrigingTool(self):
    d = kriging.KrigingTool(self.iface)
    d.exec_()
  def doDiggleTool(self):
    d = diggle.DiggleTool(self.iface)
    d.exec_()
  def doRggobiTool(self):
    d = rggobi.RggobiTool(self.iface)
    d.exec_()
  def doIplotTool(self):
    d = iplot.IplotTool(self.iface)
    d.exec_()
  def doConsoleR(self):
    d = menuConsoleR.MenuConsoleR(self.iface)
    d.exec_()
  def doInstallRpackage(self):
    d = sda4ppInstallRpackages.InstallRpackages(self.iface)
    d.exec_()
  def doGraphicsConf(self):
    d = menuGraphicsConf.MenuGraphicsConf(self.iface)
    d.exec_()
  def aboutRun(self):
    d = menuAbout.MenuAbout(self.iface)
    d.exec_()
  ## ********** interactive identify part ******************
  def vectorGUI(self, stat):
    self.confGui.chkVctName.setChecked(stat)
    self.confGui.chkVctType.setChecked(stat)
    self.confGui.chkVctFormat.setChecked(stat)
    self.confGui.chkVctProj.setChecked(stat)
    self.confGui.chkVctSource.setChecked(stat)
    self.confGui.chkVctFid.setChecked(stat)
    self.confGui.chkVctDistance.setChecked(stat)
    self.confGui.chkVctFields.setChecked(stat)
    self.confGui.chkVctFieldType.setChecked(stat)

  def vectorSelect(self):
    self.vectorGUI(bool(1))

  def vectorDeselect(self):
    self.vectorGUI(bool(0))

  def rasterGUI(self, stat):
    self.confGui.chkRstName.setChecked(stat)
    self.confGui.chkRstFormat.setChecked(stat)
    self.confGui.chkRstProj.setChecked(stat)
    self.confGui.chkRstSource.setChecked(stat)
    self.confGui.chkRstBandCount.setChecked(stat)
    self.confGui.chkRstBandValue.setChecked(stat)
    self.confGui.chkRstType.setChecked(stat)

  def rasterSelect(self):
    self.rasterGUI(bool(1))

  def rasterDeselect(self):
    self.rasterGUI(bool(0))

  def doInfoConf(self):
    flags = Qt.WindowTitleHint | Qt.WindowSystemMenuHint \
            | Qt.WindowMaximizeButtonHint  # QgisGui.ModalDialogFlags
    self.confGui = UiConfControl(self.iface.mainWindow(), flags)
    QObject.connect(self.confGui.btnSave,SIGNAL("clicked()"),
                    self.confSave)
    QObject.connect(self.confGui.btnVectorSelect,SIGNAL("clicked()"),
                    self.vectorSelect)
    QObject.connect(self.confGui.btnVectorDeselect,SIGNAL("clicked()"),
                    self.vectorDeselect)
    QObject.connect(self.confGui.btnRasterSelect,SIGNAL("clicked()"),
                    self.rasterSelect)
    QObject.connect(self.confGui.btnRasterDeselect,SIGNAL("clicked()"),
                    self.rasterDeselect)
    self.confGui.show()

  def confSave(self):
    dt = "info-confSave"
    # O for not checked, 2 for checked.
    index = {}
    index["userxy"] = self.confGui.chkUserXY.checkState()
    # -----------------------for vector layer
    index["v.name"] = self.confGui.chkVctName.checkState()
    index["v.type"] = self.confGui.chkVctType.checkState()
    index["v.format"] = self.confGui.chkVctFormat.checkState()
    index["v.proj"] = self.confGui.chkVctProj.checkState()
    index["v.source"] = self.confGui.chkVctSource.checkState()
    index["v.fid"] = self.confGui.chkVctFid.checkState()
    index["v.dist"] = self.confGui.chkVctDistance.checkState()

    index["v.field"] = self.confGui.chkVctFields.checkState()
    index["v.ftype"] = self.confGui.chkVctFieldType.checkState()
    # --------------------- for tolerance
    try:
      tolerance = int(str(self.confGui.txtTolerance.text()))
    except Exception, e:
      wl.wl("Exception: "+str(e),dt)
      tolerance = 10000
      self.confGui.txtTolerance.setText(str(tolerance))
    index["tolerance"] = tolerance
    # ---------------------for raster layer
    index["r.name"] = self.confGui.chkRstName.checkState()
    index["r.format"] = self.confGui.chkRstFormat.checkState()
    index["r.proj"] = self.confGui.chkRstProj.checkState()
    index["r.source"] = self.confGui.chkRstSource.checkState()
    index["r.bcount"] = self.confGui.chkRstBandCount.checkState()
    index["r.bvalue"] = self.confGui.chkRstBandValue.checkState()
    index["r.type"] = self.confGui.chkRstType.checkState()
    # QSetting part
    wl.manageConfFile(mode="writeIndex", index=index, tool="identify")
    self.confGui.reject()

  def doInfo(self):
    flags = Qt.WindowTitleHint | Qt.WindowSystemMenuHint \
            | Qt.WindowMaximizeButtonHint  # QgisGui.ModalDialogFlags
    self.infoGui = UiInfoControl(self.iface.mainWindow(), flags)
    QObject.connect(self.tool, SIGNAL("finished(PyQt_PyObject)"),
                    self.finished)
    self.canvas.setMapTool(self.tool)

  def finished(self,xy):
    dt = "info-finished"
    transform = self.canvas.getCoordinateTransform()
    mapCoords = transform.toMapCoordinates(xy["x"],xy["y"])
    # QSetting part
    self.index = wl.manageConfFile(mode="read", index="", tool="identify")
    wl.wl("index: " +str(self.index),dt)
    infoString = "The following layers intersect:\n"
    if self.index["userxy"] == 2:
      infoString += "User clicked location (x,y): " + str(mapCoords) + "\n"
    isFeatureFound = 0
    geoDict = {0:"Point",1:"Line",2:"Polygon"}
    rstType = {0:" Gray or Undefined",1:"Palette",2:"Multiband"}
    # Now loop through all layers and look for intersects
    nLayers=self.canvas.layerCount()
    if nLayers == 0:
      infoString += u"\nThere is no layer in the QGIS. " + \
                    "Please, add vector/raster layer."
      self.infoGui.plainTextEdit.setPlainText(QString(infoString))
      self.infoGui.show()
      return
    for nLayer in range(nLayers):
      layer = self.canvas.layer(nLayer)
      extent = layer.extent()
      if mapCoords.x() > extent.xMinimum() and \
         mapCoords.x() < extent.xMaximum() and \
         mapCoords.y() > extent.yMinimum() and \
         mapCoords.y() < extent.yMaximum():
        isFeatureFound = 1
        # vector layers
        if layer and layer.type() == QgsMapLayer.VectorLayer:
          if self.index["v.name"] == 2:
            infoString += "\nVECTOR LAYER: " + unicode(layer.name())
          if self.index["v.type"] == 2:
            infoString += "\n    Vector Type = " + \
                          str(geoDict[layer.geometryType()])
          if self.index["v.format"] == 2:
            infoString += "\n    Format = " + unicode(layer.storageType())
          if self.index["v.proj"] == 2:
            infoString += "\n    Projection = " + \
                          unicode(layer.srs().toProj4())
          if self.index["v.source"] == 2:
            infoString += "\n    Source Path = " + unicode(layer.source())
          dist = float(self.index["tolerance"])
          # polygon
          if layer.geometryType() == 2:
            provider = layer.dataProvider()
            provider.rewind()
            feat = QgsFeature()
            fieldDict = provider.fields()
            colonIndexes = provider.attributeIndexes()
            provider.select(colonIndexes,
                            QgsRectangle(mapCoords.x()-0.00001,
                                         mapCoords.y()-0.00001,
                                         mapCoords.x()+0.00001,
                                         mapCoords.y()+0.00001), False)
            while provider.nextFeature(feat):
              attrs = feat.attributeMap()
              if self.index["v.fid"] == 2:
                infoString += "\n    Feature ID = " + str(feat.id())
              for colonIndex in colonIndexes:
                if self.index["v.field"] == 2:
                  infoString += "\n    " + \
                            unicode(fieldDict[colonIndex].name()) + \
                            " = " + unicode(attrs[colonIndex].toString())
                if self.index["v.ftype"] == 2:
                  infoString += " (" + \
                            unicode(fieldDict[colonIndex].typeName())+ ")"
              break
          # point
          else:
            if layer.geometryType() == 0:
              snaptype = QgsSnapper.SnapToVertex
            if layer.geometryType() == 1:
              snaptype = QgsSnapper.SnapToSegment
            r = self.snapping(layer, mapCoords,
                              int(self.index["tolerance"]), snaptype)
            if r != None:
              rowid = r.snappedAtGeometry
              self.iface.emit(SIGNAL("selectedFeature(int)"), (rowid))
              provider = layer.dataProvider()
              provider.rewind()
              feat = QgsFeature()
              fieldDict = provider.fields()
              colonIndexes = provider.attributeIndexes()
              provider.select(colonIndexes,
                              QgsRectangle(mapCoords.x()-dist,
                                           mapCoords.y()-dist,
                                           mapCoords.x()+dist,
                                           mapCoords.y()+dist), False)
              while provider.nextFeature(feat):
                attrs = feat.attributeMap()
                if str(rowid) == str(feat.id()):
                  if self.index["v.fid"] == 2:
                    infoString += "\n    Feature ID = " + \
                                  unicode(feat.id())
                  for colonIndex in colonIndexes:
                    if self.index["v.field"] == 2:
                      infoString += "\n    " + \
                            unicode(fieldDict[colonIndex].name()) + \
                            " = " + unicode(attrs[colonIndex].toString())
                    if self.index["v.ftype"] == 2:
                      infoString += " (" + \
                            unicode(fieldDict[colonIndex].typeName())+ ")"
                  if self.index["v.dist"] == 2 and self.distList != None:
                    infoString += "\n    Distance to Near " + \
                        str(geoDict[layer.geometryType()]) + \
                        " Feature = " + unicode(round(self.distList[0],3))
                  break
            else:
              infoString += "\n    Feature ID = NOT FOUND"
              infoString += "\n    Distance to Near " + \
                            str(geoDict[layer.geometryType()]) + \
                            " Feature = Out of distance tolerance"
              infoString += "\n    (but, the extent of layer overlaps " + \
                            "with user clicked location.)"
          infoString += "\n"
        # raster
        elif layer and layer.type() == QgsMapLayer.RasterLayer:
          if self.index["r.name"] == 2:
            infoString += "\nRASTER LAYER: " + unicode(layer.name())
          if self.index["r.type"] == 2:
            infoString += "\n    Raster Type = " + \
                unicode(rstType[layer.LayerType()])
          if self.index["r.format"] == 2:
            infoString += "\n    Format = " + \
                unicode(str(layer.metadata()).split(" ")[1].split("<br>")[1].split("</p>")[0])
          if self.index["r.proj"] == 2:
            infoString += "\n    Projection = " + \
                unicode(layer.srs().toProj4())
          if self.index["r.source"] == 2:
            infoString += "\n    Source Path = " + \
                unicode(layer.source())
          if self.index["r.bcount"] == 2:
            infoString += "\n    Band Number = " + \
                unicode(layer.bandCount())
          if self.index["r.bvalue"] == 2:
            ident = layer.identify(QgsPoint(mapCoords.x(),mapCoords.y()))
            infoString += "\n    Pixel Value in " + \
                unicode(ident[1].keys()[0]) + " = " + \
                unicode(ident[1].values()[0])
          infoString += "\n"
    # no feature
    if isFeatureFound == 0:
      infoString += "\nThere is no feature at this position."
    wl.wluni("infoString: " + unicode(infoString),dt)
    self.infoGui.plainTextEdit.setPlainText(QString(infoString))
    self.infoGui.show()

  def snapping(self, layer, point, snapdist, snaptype):
    dt = "snap"
    x, snapresult = layer.snapWithContext(point, snapdist, snaptype)
    if x != 0:
      return None
    keys = snapresult.keys()
    keys.sort()
    self.distList = []
    for k in keys:
      l = snapresult[k]
      self.distList.append(k)
      for r in l:
        return r
