# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
from PyQt4 import QtCore
from PyQt4 import QtGui
from qgis.core import *
# import the code for the dialog
from ui_graphics import Ui_graphicsDialog
#handling outputFile: path name, file name and extension
import os
# run R code
import graphicsRpart
# write to logFile.log
import wl
# dialog for open help file
import sda4ppDisplayHelpFile
# reading qgis layer
import sda4ppReadQGISLayer
# R options
import sda4ppRoptions

class GraphicsTool(QtGui.QDialog, Ui_graphicsDialog):
  def __init__(self, iface):
    QtGui.QDialog.__init__(self)
    # save reference to the QGIS interface
    self.iface = iface
    # Set up the user interface from Designer.
    self.setupUi(self)
    self.setFixedSize(self.size())
    # init variables
    self.index = {"inputFilePath":"","inputFileName":"","fieldName":"",
                  "nonumericfieldError":"","readogrError":"",
                  "chart":"barchart", "fieldY":"", "fieldName":"", "inputFileName":"",
                  "main":"", "xlab":"", "ylab":"", "param":"", "customFormula":""
                  }
    # read the name of qgis layer
    self.readInputFile()
    self.progressBar.setValue(0)
    QtCore.QObject.connect(self.chkParam, QtCore.SIGNAL("clicked()"),
                           self.chkParam_changed)
    QtCore.QObject.connect(self.rbFormula, QtCore.SIGNAL("clicked()"),
                           self.rbFormula_changed)
    QtCore.QObject.connect(self.rbCustom, QtCore.SIGNAL("clicked()"),
                           self.rbCustom_changed)
    QtCore.QObject.connect(self.cmbChartType,
                           QtCore.SIGNAL("activated(QString )"),
                           self.chart_changed)
    QtCore.QObject.connect(self.cmbPointLayer,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbPointLayer_changed)
    QtCore.QObject.connect(self.cmbFieldName,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbFieldName_changed)
    QtCore.QObject.connect(self.cmbFieldY,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbFieldY_changed)
    QtCore.QObject.connect(self.btnApply, QtCore.SIGNAL("clicked()"),
                           self.runApply)
    QtCore.QObject.connect(self.btnHelp, QtCore.SIGNAL("clicked()"),
                           self.runHelp)
    QtCore.QObject.connect(self.btnCancel, QtCore.SIGNAL("clicked()"),
                           self.runClose)

    QtCore.QObject.connect(self.txtMain, QtCore.SIGNAL("editingFinished()"),
                           self.txtMain_changed)
    QtCore.QObject.connect(self.txtAxisX, QtCore.SIGNAL("editingFinished()"),
                           self.txtAxisX_changed)
    QtCore.QObject.connect(self.txtAxisY, QtCore.SIGNAL("editingFinished()"),
                           self.txtAxisY_changed)
    QtCore.QObject.connect(self.txtCustom, QtCore.SIGNAL("editingFinished()"),
                           self.txtCustom_changed)
    QtCore.QObject.connect(self.txtParam, QtCore.SIGNAL("editingFinished()"),
                           self.txtParam_changed)

  def runClose(self):
    sda4ppRoptions.closeRplot(self.R)
    self.reject()

  def runHelp(self):
    sda4ppDisplayHelpFile.DisplayHelpFile("graphics")

  def chkParam_changed(self):
    dt = "graphics-chkParam"
    if self.chkParam.isChecked():
      self.txtParam.setEnabled(True)
    else:
      self.txtParam.setEnabled(False)

  def rbFormula_changed(self):
    dt = "graphics-rbFormula"
    self.txtCustom.setEnabled(False)
    self.cmbFieldName.setEnabled(True)
    self.cmbFieldY.setEnabled(True)

  def rbCustom_changed(self):
    dt = "graphics-rbCustom"
    self.txtCustom.setEnabled(True)
    self.cmbFieldName.setEnabled(False)
    self.cmbFieldY.setEnabled(False)

  def chart_changed(self):
    dt = "graphics-chart"
    self.index["chart"] = str(self.cmbChartType.currentText())
    self.index["chart"] = self.index["chart"].split("-")[1].strip()
    wl.wl("index: " +str(self.index),dt)
    self.setRcode()
    return
    
  def cmbPointLayer_changed(self):
    dt = "graphics-cmbPointLayer"
    self.index["readogrError"] = ""
    #update source of layer
    (self.index["inputFilePath"], self.index["inputFileName"], self.index["geometryType"]) = \
       self.ReadPointLayer.getFileSource (self.cmbPointLayer.currentText())
    # readOGR
    error = sda4ppRoptions.readOGR(self.R,self.index["inputFilePath"],\
                                   self.index["inputFileName"])
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return
    # field names
    self.cmbFieldName.clear()
    self.cmbFieldY.clear()
    self.cmbFieldY.addItem("None")
    fields = self.ReadPointLayer.getFieldNameList()
    wl.wl("fields: " +str(fields),dt)
    if fields == []:
      self.index["nonumericfieldError"] = \
              "This tool requires at least one numeric field.\n\n" +\
              "Please, add one numeric field to the layer, '" +\
              self.index["inputFileName"] + \
              "',nor do not use this layer for this analysis."
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", self.index["nonumericfieldError"])
      self.index["fieldName"] = ""
    else:
      for field in fields:
        self.cmbFieldName.addItem(field)
        self.cmbFieldY.addItem(field)
      self.index["nonumericfieldError"] = ""
      self.index["fieldName"] = fields[0]
      self.index["fieldY"] = ""
    wl.wl("index: " +str(self.index),dt)
    self.setRcode()
    return
  
  def cmbFieldName_changed(self):
    self.index["nonumericfieldError"] = ""
    self.index["fieldName"] = str(self.cmbFieldName.currentText())
    self.setRcode()
    return

  def cmbFieldY_changed(self):
    self.index["nonumericfieldError"] = ""
    self.index["fieldY"] = str(self.cmbFieldY.currentText())
    if self.index["fieldY"] == "None":
      self.index["fieldY"] = ""
    self.setRcode()
    return

  def readInputFile(self):
    dt = "graphics-readInputFile"
    # init rpy2
    import rpy2.robjects as robjects
    self.R = robjects.r
    # SECTION: POINT
    self.ReadPointLayer = sda4ppReadQGISLayer.ReadQgisLayer(self.iface,"all")
    layers = self.ReadPointLayer.getLayerList(checkNumericField="YES")
    wl.wl("layers: " +str(layers),dt)
    if layers == []:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
                        "SDA4PP Plugin Error",
                        "Please add point typed vector layers in QGIS.")
      return
    for layer in layers:
      self.cmbPointLayer.addItem(layer)
    # inputFile
    (self.index["inputFilePath"], self.index["inputFileName"], self.index["geometryType"]) = \
       self.ReadPointLayer.getFileSource (self.cmbPointLayer.currentText())
    # field names
    self.cmbFieldName.clear()
    self.cmbFieldY.clear()
    self.cmbFieldY.addItem("None")
    fields = self.ReadPointLayer.getFieldNameList()
    wl.wl("fields: " +str(fields),dt)
    if fields == []:
      self.index["nonumericfieldError"] = \
              "This tool requires at least one numeric field.\n\n" +\
              "Please, add one numeric field to the layer, '" +\
              self.index["inputFileName"] + \
              "',nor do not use this layer for this analysis."
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", self.index["nonumericfieldError"])
      self.index["fieldName"] = ""
    else:
      for field in fields:
        self.cmbFieldName.addItem(field)
        self.cmbFieldY.addItem(field)
      self.index["nonumericfieldError"] = ""
      self.index["fieldName"] = fields[0]
      self.index["fieldY"] = ""
    self.setRcode()
    # readOGR
    error = sda4ppRoptions.readOGR(self.R,self.index["inputFilePath"],self.index["inputFileName"])
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return
    wl.wl("index: " +str(self.index),dt)
    return

  def txtMain_changed(self):
    dt = "graphics-txtMain"
    self.index["main"] = str(self.txtMain.text())
    self.setRcode()
    return    

  def txtAxisX_changed(self):
    dt = "graphics-txtAxisX"
    self.index["xlab"] = str(self.txtAxisX.text())
    self.setRcode()
    return

  def txtAxisY_changed(self):
    dt = "graphics-txtAxisY"
    self.index["ylab"] = str(self.txtAxisY.text())
    self.setRcode()
    return

  def txtCustom_changed(self):
    dt = "graphics-txtCustom"
    self.index["customFormula"] = str(self.txtCustom.text())
    self.setRcode()
    return

  def txtParam_changed(self):
    dt = "graphics-txtParam"
    self.index["param"] = str(self.txtParam.text())
    self.setRcode()
    return 
  
  def setRcode(self):
    dt = "graphics-setRcode"
    if str(self.index["customFormula"]) == "":
      self.index["rcode"] = str(self.index["chart"]) + "(" + str(self.index["fieldY"]) + " ~ " + \
                          str(self.index["fieldName"]) + ", data=v_df, main=\"" + \
                          str(self.index["main"]) + "\", xlab=\"" +\
                          str(self.index["xlab"]) + "\", ylab=\"" + str(self.index["ylab"]) + "\")"
    else:
      self.index["rcode"] = str(self.index["chart"]) + "(" + str(self.index["customFormula"]) + \
                          ", data=v_df, main=\"" + str(self.index["main"]) + "\", xlab=\"" +\
                          str(self.index["xlab"]) + "\", ylab=\"" + str(self.index["ylab"]) + "\")"
    if str(self.index["param"]) != "":
      self.index["rcode"] = str(self.index["rcode"])[:-1] + ", " + str(self.index["param"]) + ")"
    self.txtRcode.setText(self.index["rcode"])
    #wl.wl("index: " +str(self.index),dt)
    return 

  def runApply(self):
    dt = "graphics-runApply"
    self.progressBar.setValue(5)
    #BEGIN SECTION: inputFile
    if self.cmbPointLayer.currentIndex() == -1:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "Please add point typed vector layer in QGIS.")
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(10)
    # could not save postgis layer as shp file
    if self.index["inputFilePath"] == 'error':
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", self.index["inputFileName"])
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(15)
    # nonumericfieldError
    if self.index["nonumericfieldError"] != "":
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", self.index["nonumericfieldError"])
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(20)
    # readogrError
    if self.index["readogrError"] != "":
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", self.index["readogrError"])
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(25)
    #BEGIN SECTION: R part
    wl.wl("index: " +str(self.index),dt)
    # apply analysis part to R
    self.btnApply.setEnabled(False)
    graphicsRpart.doSpatialAnalysis(self.R,index= self.index)
    self.progressBar.setValue(100)
    self.btnApply.setEnabled(True)
