# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
# R options
import sda4ppRoptions
# write to logFile.log
import wl

def doSpatialAnalysis (r,index):
  dt="densityRpart-doSpatialAnalysis"
  wl.wl("index: " +str(index),dt)
  # pixel
  r("spatstat.options(npixel=c("+str(index["pixelX"])+"," + \
    str(index["pixelY"])+"))")
  # projection
  s = r("p4s <- CRS(\"" + str(index["projText"]) + "\")")
  s = r("rect <- as(v_spdf[\"" + str(index["fieldName"]) + "\"],\"ppp\")")
  # using extent of new study layer
  if index["extent"] == 0:
    s = r("newOwin <- owin(xrange=c(" + str(index["xmin"]) + "," + \
          str(index["xmax"]) + "), yrange=c(" + str(index["ymin"]) + \
          "," + str(index["ymax"]) + "))")
    s = r("rect <- ppp(x=rect$x, y=rect$y, window=newOwin)")
  # units
  unitCheck = str(index["projText"]).split("=", -1)[1].split(" ", -1)[0]
  if unitCheck == "utm":
    s = r("unitname(rect) <- 'meter'")
  # bandwidth value
  if index["readBandwidth"] == 1:
    s = r("w <- rect$window")
    optBand = \
        r("sigma <- (1/8) * min(abs(diff(w$xrange)), abs(diff(w$yrange)))")
    optBand = round(float(str(optBand).split()[1]),3)
    checkBandwidth = \
      r("chkSigma <- (1/6) * max(abs(diff(w$xrange)),abs(diff(w$yrange)))")
    checkBandwidth = round(float(str(checkBandwidth).split()[1]),3)
    minDist = r("minDist <- min(nndist(rect))")
    try:
      minDist = round(float(str(minDist).split()[1]),3)
    except Exception, e:
      wl.wl("intersectionError;\n" + str(e),dt)
      return 0, 0, "intersectionError"
    maxDist = r("maxDist <- max(nndist(rect))")
    maxDist = round(float(str(maxDist).split()[1]),3)
    nearDist = "Distance from each point to its nearest neighbour; " + \
               "Min.dist = " + str(minDist) + \
               " and Max.dist = " + str(maxDist)
    return optBand, checkBandwidth, nearDist
  # weight
  if index["noWeight"]:
    s = r("z <- density.ppp(rect, sigma=" + str(index["bandWidthValue"]) +\
          ", weights=NULL, edge=" + str(index["edgeCor"]) + ")")
  else:
    s = r("z <- density.ppp(rect, sigma=" + str(index["bandWidthValue"]) +\
          ", weights=rect$marks, edge=" + str(index["edgeCor"]) + ")")
  # plot
  if index["plot"]:
    rcodes = ["plot(z, main=\"Kernel Density for " + \
        str(index["inputFileName"]) + "\")"]
    sda4ppRoptions.plotGraphics(r, rcodes)
  # save
  if index["save"]:
    s = r("sgdf <- as(z,\"SpatialGridDataFrame\")")
    s = r("proj4string(sgdf) = CRS(\"" + str(index["projText"]) + "\")")
    s = r("writeGDAL(sgdf,\"" + str(index["outputFilePath"]) + \
          "\", drivername = \"" + str(index["rstfile"]) + \
          "\", type = \"Float32\")")
  # defult pixel
  s = r("spatstat.options(npixel=100)")
