# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
from PyQt4 import QtCore
from PyQt4 import QtGui
from qgis.core import *
# import the code for the dialog
from ui_adaptive import Ui_adaptiveDialog
#handling outputFile: path name, file name and extension
import os
# run R code
import adaptiveRpart
# write to logFile.log
import wl
# dialog for open help file
import sda4ppDisplayHelpFile
# reading qgis layer
import sda4ppReadQGISLayer
# R options
import sda4ppRoptions

class AdaptiveTool(QtGui.QDialog, Ui_adaptiveDialog):
  def __init__(self, iface):
    QtGui.QDialog.__init__(self)
    # save reference to the QGIS interface
    self.iface = iface
    # Set up the user interface from Designer.
    self.setupUi(self)
    self.setFixedSize(self.size())
    # init variables
    self.index = {"inputFilePath":"","inputFileName":"",
                  "outputFilePath":"",
                  "rstfile":"GTiff", "pixelX":100,"pixelY":100,
                  "rstExtension":"tif","fraction":0.10,
                  "plot":True, "save":False}
    # read the name of qgis layer
    self.readInputFile()
    self.progressBar.setValue(0)
    QtCore.QObject.connect(self.cmbPointLayer,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbPointLayer_changed)
    QtCore.QObject.connect(self.cmbRstFormat,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbRstFormat_changed)
    QtCore.QObject.connect(self.btnSave, QtCore.SIGNAL("clicked()"),
                           self.btnSave_changed)
    QtCore.QObject.connect(self.btnApply, QtCore.SIGNAL("clicked()"),
                           self.runApply)
    QtCore.QObject.connect(self.btnHelp, QtCore.SIGNAL("clicked()"),
                           self.runHelp)
    QtCore.QObject.connect(self.chkSave, QtCore.SIGNAL("clicked()"),
                           self.chkSave_changed)
    QtCore.QObject.connect(self.chkPixels, QtCore.SIGNAL("clicked()"),
                           self.chkPixels_changed)
    QtCore.QObject.connect(self.btnCancel, QtCore.SIGNAL("clicked()"),
                           self.runClose)

  def runClose(self):
    sda4ppRoptions.closeRplot(self.R)
    self.reject()

  def runHelp(self):
    sda4ppDisplayHelpFile.DisplayHelpFile("adaptive")

  def getUniqueOutputFileName(self, file=""):
    notFileExist = 0
    counter = 0
    if file == "":
      file = self.ReadPointLayer.createOutputDir() + "adaptive"
    while (notFileExist == 0):
      outputFilename = file + "_" + str(counter) + "." + \
                       self.index["rstExtension"]
      if not(os.path.exists(outputFilename)):
        self.index["outputFilePath"] = outputFilename
        self.txtPath.setText(self.index["outputFilePath"])
        notFileExist = 1
      else:
        counter = counter + 1

  def changeExtension(self):
    if self.index["outputFilePath"] != "":
      f = QtCore.QFileInfo(self.index["outputFilePath"])
      if f.suffix() != self.index["rstExtension"]:
        self.index["outputFilePath"] = f.path() + "/" + f.completeBaseName()+ \
                                   "." + self.index["rstExtension"]
      if not(os.path.exists(self.index["outputFilePath"])):
        self.txtPath.setText(self.index["outputFilePath"])
      else:
        file =f.path() + "/" + f.completeBaseName()
        self.getUniqueOutputFileName(file)

  def btnSave_changed(self):
    (self.index["outputFilePath"], foo) = self.ReadPointLayer.saveDialog(self,
                                    extension = self.index["rstExtension"])
    if self.index["outputFilePath"] is None:
      self.index["outputFilePath"] = str(self.txtPath.text())
      return
    self.changeExtension()

  def cmbRstFormat_changed(self):
    # raster file format: the driver name of GDAL Library in R
    if self.cmbRstFormat.currentIndex() == 0:
      self.index["rstfile"] = "GTiff"
      self.index["rstExtension"] = "tif"
    elif self.cmbRstFormat.currentIndex() == 1:
      self.index["rstfile"] = "HFA"
      self.index["rstExtension"] = "img"
    self.changeExtension()

  def chkSave_changed(self):
    dt = "adaptive-chkSave_changed"
    if self.chkSave.checkState() == 2:
      self.index["save"] = True
      self.cmbRstFormat.setEnabled(True)
      self.btnSave.setEnabled(True)
      self.txtPath.setEnabled(True)
      self.chkPixels.setEnabled(True)
      self.getUniqueOutputFileName()
    elif self.chkSave.checkState() == 0:
      self.txtPath.clear()
      self.index["save"] = False
      self.cmbRstFormat.setEnabled(False)
      self.btnSave.setEnabled(False)
      self.txtPath.setEnabled(False)
      self.chkPixels.setEnabled(False)
      self.chkPixels.setCheckState(0)
      self.spinBoxX.setEnabled(False)
      self.spinBoxY.setEnabled(False)
    wl.wl("index: " + str(self.index),dt)

  def chkPixels_changed(self):
    if self.chkPixels.isChecked():
      self.spinBoxX.setEnabled(True)
      self.spinBoxY.setEnabled(True)
    else:
      self.spinBoxX.setEnabled(False)
      self.spinBoxY.setEnabled(False)

  def cmbPointLayer_changed(self):
    dt = "adaptive-cmbPointLayer_changed"
    #update source of layer
    (self.index["inputFilePath"], self.index["inputFileName"]) = \
       self.ReadPointLayer.getFileSource (self.cmbPointLayer.currentText())
    wl.wl("index: " +str(self.index),dt)
    # readOGR
    error = sda4ppRoptions.readOGR(self.R,self.index["inputFilePath"],self.index["inputFileName"])
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return

  def readInputFile(self):
    dt = "adaptive-readInputFile"
    # init rpy2
    import rpy2.robjects as robjects
    self.R = robjects.r
    # SECTION: POINT
    self.ReadPointLayer = sda4ppReadQGISLayer.ReadQgisLayer(self.iface)
    layers = self.ReadPointLayer.getLayerList()
    wl.wl("layers: " +str(layers),dt)
    if layers == []:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "Please add point typed vector layer.")
      return
    for layer in layers:
      self.cmbPointLayer.addItem(layer)
    # inputFile
    (self.index["inputFilePath"], self.index["inputFileName"]) = \
       self.ReadPointLayer.getFileSource (self.cmbPointLayer.currentText())
    wl.wl("index: " +str(self.index),dt)
    # unique output filename
    self.getUniqueOutputFileName()
    # readOGR
    error = sda4ppRoptions.readOGR(self.R,self.index["inputFilePath"],self.index["inputFileName"])
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return
    return

  def runApply(self):
    dt = "adaptive-runApply"
    self.progressBar.setValue(5)
    #BEGIN SECTION: inputFile
    if self.cmbPointLayer.currentIndex() == -1:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
        "SDA4PP Plugin Error", "Please add point typed vector layer.")
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(10)
    # could not save postgis layer as shp file
    if self.index["inputFilePath"] == 'error':
      QtGui.QMessageBox.information(self.iface.mainWindow(),
        "SDA4PP Plugin Error", self.index["inputFileName"])
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(15)
    # reading outputFile
    if self.index["outputFilePath"] == "":
      QtGui.QMessageBox.information(self.iface.mainWindow(),
        "SDA4PP Plugin Error",
        "New raster filename should be defined.\n" + \
        "Please, use \"Save As\" button.")
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(20)
    # plot option
    self.index["plot"] = self.chkPlot.isChecked()
    # at least one of them should be checked
    if not(self.index["save"]) and not(self.index["plot"]):
      QtGui.QMessageBox.information(self.iface.mainWindow(),
        "SDA4PP Plugin Error",
        "At least one of them 'Save' or 'Plot' option should be checked.")
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(30)
    # pixel number:
    if self.chkPixels.isChecked():
      self.index["pixelX"] = self.spinBoxX.value()
      self.index["pixelY"] = self.spinBoxY.value()
    # fraction
    self.index["fraction"] = self.spinBoxF.value()
    #BEGIN SECTION: R part
    self.progressBar.setValue(100)
    wl.wl("index: " +str(self.index),dt)
    # apply analysis part to R
    self.btnApply.setEnabled(False)
    adaptiveRpart.doSpatialAnalysis(self.R,index= self.index)
    self.btnApply.setEnabled(True)
    # save
    if self.index["save"]:
      resSave = self.ReadPointLayer.saveRaster(self.index["outputFilePath"])
      if resSave == "error":
        self.progressBar.setValue(0)
        return
      self.getUniqueOutputFileName()
    self.progressBar.setValue(0)
