# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
from PyQt4 import QtCore
from PyQt4 import QtGui
from qgis.core import *
# import the code for the dialog
from ui_toolcentroid import Ui_toolcentroidDialog
# handling inputFile: path name, file name and extension
import os
# run R code
import toolcentroidRpart
# write to logFile.log
import wl
# dialog for open help file
import sda4ppDisplayHelpFile
# reading qgis layer
import sda4ppReadQGISLayer
# R options
import sda4ppRoptions

class CentroidTool(QtGui.QDialog, Ui_toolcentroidDialog):
  def __init__(self, iface):
    QtGui.QDialog.__init__(self)
    self.iface = iface
    self.setupUi(self)
    self.setFixedSize(self.size())
    ## init variables
    self.index = {"inputFilePath":"", "inputFileName":"",
                  "plot":True,"save":False,
                  "outputFilePath":"", "outputFileName":""}
    # read the name of qgis layer
    self.readInputFile()
    self.progressBar.setValue(0)
    QtCore.QObject.connect(self.cmbPolygonLayer,
        QtCore.SIGNAL("activated(QString )"), self.cmbPointLayer_changed)
    QtCore.QObject.connect(self.btnSave,
        QtCore.SIGNAL("clicked()"), self.btnSave_changed)
    QtCore.QObject.connect(self.btnApply,
        QtCore.SIGNAL("clicked()"), self.runApply)
    QtCore.QObject.connect(self.btnHelp,
        QtCore.SIGNAL("clicked()"), self.runHelp)
    QtCore.QObject.connect(self.chkPlot,
        QtCore.SIGNAL("clicked()"), self.chkPlot_changed)
    QtCore.QObject.connect(self.chkSave,
        QtCore.SIGNAL("clicked()"), self.chkSave_changed)
    QtCore.QObject.connect(self.btnCancel,
        QtCore.SIGNAL("clicked()"), self.runClose)

  def runClose(self):
    sda4ppRoptions.closeRplot(self.R)
    self.reject()

  def runHelp(self):
    sda4ppDisplayHelpFile.DisplayHelpFile("toolcentroid")

  def getUniqueOutputFileName(self, file=""):
    notFileExist = 0
    counter = 0
    if file == "":
      file = self.ReadPolygonLayer.createOutputDir() + "toolcentroid"
    while (notFileExist == 0):
      outputFilename = file + "_" + str(counter) + ".shp"
      if not(os.path.exists(outputFilename)):
        self.index["outputFilePath"] = outputFilename
        self.txtPath.setText(outputFilename)
        layerSource = QtCore.QFileInfo(outputFilename)
        self.index["outputFileName"] = str(layerSource.completeBaseName())
        notFileExist = 1
      else:
        counter = counter + 1

  def changeExtension(self):
    if self.index["outputFilePath"] != "":
      f = QtCore.QFileInfo(self.index["outputFilePath"])
      if f.suffix() != "shp":
        self.index["outputFilePath"] = f.path() + "/" + \
                                   f.completeBaseName() + ".shp"
      if not(os.path.exists(self.index["outputFilePath"])):
        self.txtPath.setText(self.index["outputFilePath"])
        self.index["outputFileName"] = str(f.completeBaseName())
      else:
        file =f.path() + "/" + f.completeBaseName()
        self.getUniqueOutputFileName(file)

  def btnSave_changed(self):
    (self.index["outputFilePath"], foo) = self.ReadPolygonLayer.saveDialog(self)
    if self.index["outputFilePath"] is None:
      self.index["outputFilePath"] = str(self.txtPath.text())
      return
    self.changeExtension()

  def chkSave_changed(self):
    dt = "toolcentroid-chkSave_changed"
    if self.chkSave.checkState() == 2:
      self.btnSave.setEnabled(True)
      self.txtPath.setEnabled(True)
      self.index["save"] = True
      self.getUniqueOutputFileName()
    elif self.chkSave.checkState() == 0:
      self.btnSave.setEnabled(False)
      self.txtPath.setEnabled(False)
      self.txtPath.clear()
      self.index["save"] = False
    wl.wl("index: " + str(self.index),dt)

  def chkPlot_changed(self):
    dt = "toolcentroid-chkPlot_changed"
    if self.chkPlot.checkState() == 2:
      self.index["plot"] = True
    elif self.chkPlot.checkState() == 0:
      self.index["plot"] = False
    wl.wl("index: " + str(self.index),dt)

  def cmbPointLayer_changed(self):
    dt = "toolcentroid-cmbPointLayer_changed"
    #update source of layer
    (self.index["inputFilePath"], self.index["inputFileName"]) = \
         self.ReadPolygonLayer.getFileSource (self.cmbPolygonLayer.currentText())
    # readOGR
    error = sda4ppRoptions.readOGR(self.R,self.index["inputFilePath"],
					self.index["inputFileName"])
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return
    wl.wl("index: " +str(self.index),dt)

  def readInputFile(self):
    dt = "toolcentroid-readInputFile"
    # init rpy2
    import rpy2.robjects as robjects
    self.R = robjects.r
    # SECTION: POINT
    self.ReadPolygonLayer = sda4ppReadQGISLayer.ReadQgisLayer(self.iface,
                                                           "polygon")
    layers = self.ReadPolygonLayer.getLayerList()
    wl.wl("layers: " +str(layers),dt)
    if layers == []:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "Please add polygon typed vector layers in QGIS.")
      return
    for layer in layers:
      self.cmbPolygonLayer.addItem(layer)
    # inputFile
    (self.index["inputFilePath"], self.index["inputFileName"]) = \
         self.ReadPolygonLayer.getFileSource (self.cmbPolygonLayer.currentText())
    # readOGR
    error = sda4ppRoptions.readOGR(self.R,self.index["inputFilePath"],
					self.index["inputFileName"])
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return
    return

  def runApply(self):
    dt = "toolcentroid-runApply"
    self.progressBar.setValue(5)
    #BEGIN SECTION: inputFile
    if self.cmbPolygonLayer.currentIndex() == -1:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "Please add polygon typed vector layer in QGIS.")
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(10)
    # could not save postgis layer as shp file
    if self.index["inputFilePath"] == 'error':
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", self.fileBaseName)
      self.progressBar.setValue(0)
      return
    self.progressBar.setValue(15)
    #BEGIN SECTION: R part
    self.btnApply.setEnabled(False)
    wl.wl("index: " +str(self.index),dt)
    # apply analysis part to R
    lstResult = toolcentroidRpart.doSpatialAnalysis(self.R, self.index)
    wl.wl("lstResult: " +str(lstResult),dt)
    self.progressBar.setValue(100)
    self.btnApply.setEnabled(True)
    # save
    if self.index["save"]:
      resSave = self.ReadPolygonLayer.saveShape(self.index["outputFilePath"])
      if resSave == "error":
        self.progressBar.setValue(0)
        return
      self.getUniqueOutputFileName()
    self.progressBar.setValue(0)
