# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
from PyQt4 import QtCore
from PyQt4 import QtGui
from qgis.core import *
from qgis.gui import *
#handling outputFile: path name, file name and extension
import os, shutil, tempfile
# write to logfile.log
import wl

class ReadQgisLayer():
  def __init__(self, iface, type="point"):
    dt = "ReadQGISLayer-__init__"
    self.iface = iface
    index = {"point":0,"line":1,"polygon":2,"all":-1}
    self.geomIndex = index[type]

  def getLayerList(self, checkNumericField=""):
    ## tool: density, envelope, GFestimate, iplot, rggobi, KLripley,
    ##       quadrattest, toolrandom, toolregular, toolnear, localKL,
    ##       kstest, adaptive, intensity
    dt = "ReadQGISLayer-getLayerList"
    layerNameList = []
    layerNameControl = []
    mapCanvas = self.iface.mapCanvas()
    for i in range(mapCanvas.layerCount()):
      layer = mapCanvas.layer(i)
      if layer.type() == layer.VectorLayer:
        try:
          # for point, line and polygon layers
          if self.geomIndex == -1:
            if checkNumericField == "":
              # if layer name has unicode characters,
              # it is catched with the exception and
              # the layer is not added.
              layerNameControl.append(str(layer.source()))
              layerNameList.append(str(layer.name()))
            else:
              # the layer should have at least one numeric field.
              # checkNumericField controls this condition,
              # which is valid for tool: density, iplot, kriging
              # if not found, the layer is not added.
              self.provider = layer.dataProvider()
              self.fieldDict = self.provider.fields()
              numericFound = 0
              for i in range(self.provider.fieldCount()):
                if self.fieldDict[i].typeName() in ["Integer","Real"]:
                  layerNameControl.append(str(layer.source()))
                  layerNameList.append(str(layer.name()))
                  numericFound = 1
                  break
              if numericFound == 0:
                QtGui.QMessageBox.information(self.iface.mainWindow(),
                     "SDA4PP Plugin Error",
                     "This tool requires at least one numeric field.\n" +\
                     "Please, add one numeric field to the layer.\n\n" +\
                     "The layer, '" + unicode(layer.name()) +\
                     "', is excluded from the analysis.")
          # for one type of geometry layer
          elif self.geomIndex == layer.geometryType():
            if checkNumericField == "":
              layerNameControl.append(str(layer.source()))
              layerNameList.append(str(layer.name()))
            else:
              self.provider = layer.dataProvider()
              self.fieldDict = self.provider.fields()
              numericFound = 0
              for i in range(self.provider.fieldCount()):
                if self.fieldDict[i].typeName() in ["Integer","Real"]:
                  layerNameControl.append(str(layer.source()))
                  layerNameList.append(str(layer.name()))
                  numericFound = 1
                  break
              if numericFound == 0:
                QtGui.QMessageBox.information(self.iface.mainWindow(),
                     "SDA4PP Plugin Error",
                     "This tool requires at least one numeric field.\n" +\
                     "Please, add one numeric field to the layer.\n\n" +\
                     "The layer, '" + unicode(layer.name()) +\
                     "', is excluded from the analysis.")
        except Exception, e:
          wl.wl("Exception: "+str(e),dt)
          # converting pyqt object to string is done due to reason in sda4ppRoptions.readOGR.
          # see TODO note in this function. True way is to use "unicode" instead of "str".
          error = "This plugin does not support unicode characters.\n" +\
                  "Please, use only ASCII characters in the path and the name of file.\n\n" +\
                  "The layer, '" + unicode(layer.name()) + "', is excluded from the analysis."
          QtGui.QMessageBox.information(self.iface.mainWindow(), "SDA4PP Plugin Error", error)
    wl.wl("layerNameList: "+str(layerNameList),dt)
    return layerNameList

  def updateLayer(self, layerName):
    ## tool: toolrandom, toolregular, toolnear
    dt = "ReadQGISLayer-updateLayer"
    mapCanvas = self.iface.mapCanvas()
    for i in range(mapCanvas.layerCount()):
      layer = mapCanvas.layer(i)
      if layer.type() == layer.VectorLayer:
        if self.geomIndex == -1:
          if layer.name() == layerName:
            self.userLayer = layer
            self.provider = layer.dataProvider()
        elif self.geomIndex == layer.geometryType():
          if layer.name() == layerName:
            self.userLayer = layer
            self.provider = layer.dataProvider()
    return self.userLayer

  def getFileSource(self, layerName):
    ## tool: density, envelope, GFestimate, iplot, rggobi, KLripley,
    ##       quadrattest, toolrandom, toolnear, localKL, kstest,
    ##       adaptive, intensity
    dt = "ReadQGISLayer-getFileSource"
    mapCanvas = self.iface.mapCanvas()
    for i in range(mapCanvas.layerCount()):
      layer = mapCanvas.layer(i)
      if layer.type() == layer.VectorLayer:
        if self.geomIndex == -1:
          if layer.name() == layerName:
            self.userLayer = layer
            self.provider = layer.dataProvider()
            self.fieldDict = self.provider.fields()
            if self.provider.name() == "postgres":
              (error, postLayerSource) = self.writeAsSHPfile(\
                                              description = "postgis")
              if error !=0:
                wl.wl("the error is: " + str(error),dt)
                return "error", error, layer.geometryType()
              else:
                (path, file) = self.removeLayerID(postlayerSource)
                wl.wl("path: "+str(path),dt)
                wl.wl("file: "+str(file),dt)
                wl.wl("layer.geometryType: "+str(layer.geometryType()),dt)
                return path, file, layer.geometryType()
            else:
              layerSource = QtCore.QFileInfo(self.userLayer.source())
              (path, file) = self.removeLayerID(layerSource)
              wl.wl("path: "+str(path),dt)
              wl.wl("file: "+str(file),dt)
              wl.wl("layer.geometryType: "+str(layer.geometryType()),dt)
              return path, file, layer.geometryType()
        elif self.geomIndex == layer.geometryType():
          if layer.name() == layerName:
            self.userLayer = layer
            self.provider = layer.dataProvider()
            self.fieldDict = self.provider.fields()
            if self.provider.name() == "postgres":
              (error, postlayerSource) = self.writeAsSHPfile(\
                                                  description = "postgis")
              if error !=0:
                wl.wl("the error is: " + str(error),dt)
                return "error", error
              else:
                (path, file) = self.removeLayerID(postlayerSource)
                wl.wl("path: "+str(path),dt)
                wl.wl("file: "+str(file),dt)
                return path, file
            else:
              layerSource = QtCore.QFileInfo(self.userLayer.source())
              (path, file) = self.removeLayerID(layerSource)
              wl.wl("path: "+str(path),dt)
              wl.wl("file: "+str(file),dt)
              return path, file

  def removeLayerID(self, layerSource):
    ## tool: getFileSource
    dt = "ReadQGISLayer-removeLayerID"
    path = str(layerSource.filePath())
    if path.find("|") != -1:
      path = path.split("|")[0]
    file = str(layerSource.baseName())
    wl.wl("path: "+str(path),dt)
    wl.wl("file: "+str(file),dt)
    return path, file

  def getExtentObj(self):
    ## tool: toolregular, toolrandom
    return self.userLayer.extent()

  def getEncodingObj(self):
    ## tool: toolregular, toolrandom
    dt = "ReadQGISLayer-getEncodingObj"
    encoding = self.provider.encoding()
    wl.wl("encoding: "+str(encoding),dt)
    return encoding

  def getProj(self):
    ## tool: density, quadrattest
    dt = "ReadQGISLayer-getProj"
    layerProj = self.userLayer.srs().toProj4()
    wl.wl("layerProj: "+str(layerProj),dt)
    return str(layerProj)

  def getProjByPointLayerName(self, layerName):
    ## tool: kriging
    dt = "ReadQGISLayer-getProjByPointLayerName"
    mapCanvas = self.iface.mapCanvas()
    for i in range(mapCanvas.layerCount()):
      layer = mapCanvas.layer(i)
      if layer.type() == layer.VectorLayer:
        if layer.geometryType() == 0:
          if layer.name() == layerName:
            layerProj = layer.srs().toProj4()
            wl.wl("layerProj: "+str(layerProj),dt)
            return str(layerProj)

  def getFeatureCount(self):
    ## tool: localKL,
    dt = "ReadQGISLayer-getFeatureCount"
    featureNumber = self.provider.featureCount()
    wl.wl("featureCount: "+str(featureNumber),dt)
    return featureNumber

  def getFieldNameList(self, allFieldType="", returnFieldType=""):
    ## tool: density, iplot, kriging
    dt = "ReadQGISLayer-getFieldsNameWithCombo"
    fieldList = []
    fieldNameTypeDict = {}
    # all field types are required for tool: iplot
    if allFieldType == "":
      fieldstype = ["Integer","Real"]
    else:
      fieldstype = ["Integer","Real","String"]
    for i in range(self.provider.fieldCount()):
      ftype = self.fieldDict[i].typeName()
      if ftype in fieldstype:
        try:
          fieldList.append(str(self.fieldDict[i].name()))
          fieldName = str(self.fieldDict[i].name())
          fieldType = str(self.fieldDict[i].typeName())
          fieldNameTypeDict[fieldName] = fieldType
        except Exception, e:
          wl.wl("Exception: "+str(e),dt)
          # converting pyqt object to string is done due to reason in sda4ppRoptions.readOGR.
          # similarly in this case it is valid for field name.
          # see TODO note in sda4ppRoptions.readOGR function.
          # True way is to use "unicode" instead of "str".
          error = "This plugin does not support unicode characters.\n" +\
                  "Please, use only ASCII characters in the field name.\n\n" +\
                  "The field name, '" + unicode(self.fieldDict[i].name()) +\
                  "', in the point layer, '" + unicode(self.userLayer.name()) +\
                  "',\nhas non-english characters." +\
                  "This field is excluded from the analysis."
          QtGui.QMessageBox.information(self.iface.mainWindow(),
                "SDA4PP Plugin Error", error)
    # returning field names and types as the dict is required for tool: iplot
    if returnFieldType == "":
      return fieldList
    else:
      return fieldNameTypeDict

  def getRasterList(self):
    ## tool: kriging,
    dt = "ReadQGISLayer-getRasterList"
    layerNameList= []
    layerNameControl = []
    mapCanvas = self.iface.mapCanvas()
    for i in range(mapCanvas.layerCount()):
      layer = mapCanvas.layer(i)
      if layer.type() == layer.RasterLayer:
        try:
          layerNameControl.append(str(layer.source()))
          layerNameList.append(str(layer.name()))
        except Exception, e:
          wl.wl("Exception: "+str(e),dt)
          # converting pyqt object to string is done due to reason in sda4ppRoptions.readOGR.
          # see TODO note in this function. True way is to use "unicode" instead of "str".
          error = "This plugin does not support unicode characters.\n" +\
                  "Please, use only ASCII characters in the path and the name of file.\n\n" +\
                  "The layer, '" + unicode(layer.name()) + "', is excluded from the analysis."
          QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
    wl.wl("rasterNameList: "+str(layerNameList),dt)
    return layerNameList

  def getRasterSource(self, layerName):
    ## tool: kriging,
    dt = "ReadQGISLayer-getRasterSource"
    mapCanvas = self.iface.mapCanvas()
    for i in range(mapCanvas.layerCount()):
      layer = mapCanvas.layer(i)
      if layer.type() == layer.RasterLayer and layer.name() == layerName:
        return layer.source()

  def getSelectedDataFromIDField(self):
    ## tool: iplot, 
    dt = "ReadQGISLayer-getDataFromSelectedField"
    featureIDlist = []
    if self.userLayer.selectedFeatureCount() > 0:
      features = self.userLayer.selectedFeatures()
      wl.wl("features: "+str(features),dt)
      for feature in features:
        featureIDlist.append(feature.id())
      wl.wl("featureIDlist: "+str(featureIDlist),dt)
      return featureIDlist, self.provider.featureCount()
    else:
      return "error", "No selection found in the map."

  def setSelectionFromQuery(self, recordList, zoom = "True"):
    ## tool: iplot, GFestimate, KLripley
    dt = "ReadQGISLayer-setSelectionFromQuery"
    self.userLayer.setSelectedFeatures(recordList)
    if zoom == "True":
      mapCanvas = self.iface.mapCanvas()
      mapCanvas.setCurrentLayer(self.userLayer)
      # set extent to the extent of our layer
      mapCanvas.setExtent(self.userLayer.extent())
      mapCanvas.zoomToSelected()
      mapCanvas.refresh()
    return 0

  def checkFeatureNumberInPolyLayer(self):
    ## tool: density, 
    if self.provider.featureCount() == 1:
      return 0, 0
    else:
      if self.userLayer.selectedFeatureCount() == 1:
        (error, selectionLayerSource) = self.writeAsSHPfile(description = \
                                     "selected feature in polygon layer",
                                                          useSelection = 1)
        if error != 0:
          return error, 0
        else:
          return 0, selectionLayerSource
      else:
        return "Either polygon layer should have only one feature\n" + \
               "Or select only one feature from the polygon layer.", 0

  def writeAsSHPfile(self, description = "new", useSelection = 0):
    ## tool: self.checkFeatureNumberInPolyLayer, self.getFileSource, 
    dt = "ReadQGISLayer-writeAsSHPfile"
    # trying to found unique shp filename
    notFileExist = 0
    counter = 0
    file = self.createOutputDir() + str(self.userLayer.name()) + ".shp"
    if os.path.exists(file):
      while (notFileExist == 0):
        outputfilename = self.createOutputDir() + \
                         str(self.userLayer.name()) + \
                         "_" + str(counter) + ".shp"
        if not(os.path.exists(outputfilename)):
          file = outputfilename
          break 
        else:
          counter = counter + 1
    wl.wl("unique filename and path for " + str(description) + \
          " layer to be saved as shp file: "+str(file),dt)
    layer2shpFileSource = QtCore.QFileInfo(file)
    newSHPfilePath = layer2shpFileSource.filePath()
    # writing new layer as shp file
    p4s = self.userLayer.srs()
    encoding = self.provider.encoding()
    if useSelection == 1:
      qgisFeature = self.userLayer.selectedFeatures()
      writer = QgsVectorFileWriter(newSHPfilePath, encoding,
                                   self.fieldDict, QGis.WKBPolygon, p4s)
      writer.addFeature(qgisFeature[0])
      error = writer.hasError()
      del writer
    else:
      error = QgsVectorFileWriter.writeAsShapefile(self.userLayer,
                                                   newSHPfilePath,
                                                   encoding, p4s)
    if error != 0:
      wl.wl("the error is: " + str(description) + \
            " layer could not be written as SHP file.",dt)
      return "The " + str(description) + \
             " layer could not be written as SHP file.", 0
    wl.wl("layer2shpFileSource: "+str(layer2shpFileSource),dt)
    return 0, layer2shpFileSource

  def createOutputDir(self):
    ## tool: self.writeAsSHPfile, rggobi, toolnear, density, toolrandom,
    ##       toolregular
    dt = "ReadQGISLayer-createOutputDir"
    # creating a writable folder
    tempDir = tempfile.gettempdir()
    if os.name == "nt":
      tempDir = tempDir.replace("\\","/")
    outputpathdir = tempDir + "/SDA4PP/"
    if not(os.path.exists(outputpathdir)):
      os.mkdir(outputpathdir)
    wl.wl("outputpathdir: "+str(outputpathdir),dt)
    return outputpathdir

  def saveShape(self, outputFile):
    ## tool: toolrandom, toolregular, quadrat
    dt = "ReadQGISLayer-saveShape"
    fileInfo = QtCore.QFileInfo(outputFile)
    # add a (hardcoded) layer and zoom to its extent
    vlayer = QgsVectorLayer(fileInfo.filePath(),
                            fileInfo.completeBaseName(), "ogr")
    if not vlayer.isValid():
      QtGui.QMessageBox.information(self.iface.mainWindow(),
          "SDA4PP Plugin Error",
          "Shape file: " + str(outputFile) + " is created.\n" + \
          "It seems that the layer is not valid or could not be added to Qgis.\n" + \
          "The problem can be related with gdal library or python-gdal binding.\n" + \
          "Please check the installation of gdal libraries.")
      return "error"
    addToTOC = QtGui.QMessageBox.question(self.iface.mainWindow(),
        "SDA4PP Plugin", "Shapefile: " + outputFile + \
        "\n\nWould you like to add the new layer to the TOC?",
        QtGui.QMessageBox.Yes, QtGui.QMessageBox.No,
                               QtGui.QMessageBox.NoButton)
    # adding raster layer to TOC: yes
    if addToTOC == QtGui.QMessageBox.Yes:
      QgsMapLayerRegistry.instance().addMapLayer(vlayer)
      self.zoomToLayerExtent(vlayer)
    # adding raster layer to TOC: no
    return 0

  def zoomToLayerExtent (self, layer):
    ## tool: self.saveRaster, self.saveShape
    mapCanvas = self.iface.mapCanvas()
    mapCanvas.setCurrentLayer(layer)
    # set extent to the extent of our layer
    mapCanvas.setExtent(layer.extent())
    mapCanvas.zoomToSelected()
    mapCanvas.refresh()

  def saveRaster(self, outputFile, toolname=""):
    ## tool: adaptive, density, poisson, kriging
    dt = "ReadQGISLayer-saveRaster"
    fileInfo = QtCore.QFileInfo(outputFile)
    # add a (hardcoded) layer and zoom to its extent
    rstlayer = QgsRasterLayer(fileInfo.filePath(),
                              fileInfo.completeBaseName())
    if not rstlayer.isValid():
      QtGui.QMessageBox.information(self.iface.mainWindow(),
          "SDA4PP Plugin Error",
          "Raster file: " + str(outputFile) + " is created.\n" + \
          "It seems that the layer is not valid or could not be added to Qgis.\n" + \
          "The problem can be related with gdal library or python-gdal binding.\n" + \
          "Please check the installation of gdal libraries.")
      return "error"
    addToTOC = QtGui.QMessageBox.question(self.iface.mainWindow(),
       "SDA4PP Plugin", "Raster file: " + outputFile + \
       "\n\nWould you like to add the new layer to the TOC?",
       QtGui.QMessageBox.Yes, QtGui.QMessageBox.No,
                              QtGui.QMessageBox.NoButton)
    # adding raster layer to TOC: yes
    if addToTOC == QtGui.QMessageBox.Yes:
      # default: single band 
      if toolname == "":
        rstlayer.setDrawingStyle(QgsRasterLayer.SingleBandPseudoColor)
        rstlayer.setColorShadingAlgorithm(QgsRasterLayer.PseudoColorShader)
        rstlayer.setContrastEnhancementAlgorithm(\
          QgsContrastEnhancement.StretchToMinimumMaximum, False)
      # three bands for kriging tool
      elif toolname == "kriging":
        pass
      # add layer to the registry
      QgsMapLayerRegistry.instance().addMapLayer(rstlayer);
      self.zoomToLayerExtent(rstlayer)
    # adding raster layer to TOC: no
    return 0

  def saveDialog(self, parent, extension = "shp"):
    ## tool: rggobi, toolnear, density, adaptive,
    ## poisson, toolrandom, toolregular, quadrattest
    #       dirName,        filtering,      saveText,       suffix
    dt = "ReadQGISLayer-saveDialog"
    index = {"shp":["UI/lastShapefileDir","Shapefiles (*.shp)",
                    "Save output shapefile","shp"],
             "csv":["sda4pp/csvDir",
                    "Comma Separated Values (*.csv)",
                    "Save output comma separated values","csv"],
             "tif":["sda4pp/tifDir",
                    "Geo-Tagged Image File (*.tif)",
                    "Save output geo-tagged image file","tif"],
             "img":["sda4pp/imgDir",
                    "Erdas Imagine Images (*.img)",
                    "Save output erdas imagine images","img"],
             }
    settings = QtCore.QSettings()
    dirName = settings.value(index[extension][0]).toString()
    filtering = QtCore.QString(index[extension][1])
    encode = settings.value("UI/encoding").toString()
    fileDialog = QgsEncodingFileDialog(parent, index[extension][2],
                                       dirName, filtering, encode)
    fileDialog.setDefaultSuffix( QtCore.QString(index[extension][3]))
    fileDialog.setFileMode(QtGui.QFileDialog.AnyFile)
    fileDialog.setAcceptMode(QtGui.QFileDialog.AcceptSave)
    fileDialog.setConfirmOverwrite(True)
    if not fileDialog.exec_() == QtGui.QDialog.Accepted:
      return None, None
    files = fileDialog.selectedFiles()
    settings.setValue(index[extension][0], QtCore.QVariant(\
        QtCore.QFileInfo(unicode(files.first())).absolutePath()))
    try:
      (f,e) = str(files.first()), str(fileDialog.encoding())
    except Exception, e:
      wl.wl("Exception: "+str(e),dt)
      # converting pyqt object to string is done due to reason in sda4ppRoptions.readOGR.
      # similarly in this case it is valid for writeOGR/writeGDAL function in the R.
      # see TODO note in this function. True way is to use "unicode" instead of "str".
      error = "This plugin does not support unicode characters.\n" +\
              "Please, use only ASCII characters in the path and the name of file.\n\n" +\
              "The output folder, '" + unicode(files.first()) + \
              "', is changed to default folder:\n" +\
              self.createOutputDir()
      QtGui.QMessageBox.information(self.iface.mainWindow(),
        "SDA4PP Plugin Error", error)
      return None, None
    return f,e

  def doDistanceMatrix(self, layer1, layer2, outPath):
    ## tool: toolnear
    dt = "ReadQGISLayer-doDistanceMatrix"
    provider1 = layer1.dataProvider()
    provider2 = layer2.dataProvider()
    allAttrs = provider1.attributeIndexes()
    provider1.select(allAttrs)
    allAttrs = provider2.attributeIndexes()
    provider2.select(allAttrs)
    csvList = []
    distArea = QgsDistanceArea()
    inFeat = QgsFeature()
    outFeat = QgsFeature()
    inGeom = QgsGeometry()
    outGeom = QgsGeometry()
    first = True
    while provider1.nextFeature(inFeat):
      inGeom = inFeat.geometry()
      inID = inFeat.id()
      if first:
        featList = range(layer2.featureCount())
        first = False
        data = [""]
        for i in range(layer2.featureCount()):
          provider2.featureAtId(int(i), outFeat, True, [-1])
          data.append('"V' + str(outFeat.id())+'"')
        csvList.append(data)
      data = [inID]
      for j in featList:
        provider2.featureAtId(int(j), outFeat, True)
        outGeom = outFeat.geometry()
        dist = distArea.measureLine(inGeom.asPoint(), outGeom.asPoint())
        data.append(float(dist))
      csvList.append(data)
    csvtxt = ""
    for lines in csvList:
      for field in lines:
        csvtxt += str(field) + ","
      csvtxt = csvtxt[:-1] + "\n"
    f = open(outPath, "w")
    f.write(csvtxt)
    f.close()
    return 0
