# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
from PyQt4 import QtCore
from PyQt4 import QtGui
from qgis.core import *
# import the code for the dialog
from ui_rggobi import Ui_rggobiDialog
# handling outputFile: path name, file name and extension
import os
# run R code
import rggobiRpart
# write to logFile.log
import wl
# dialog for open help file and R code 
import sda4ppDisplayHelpFile
# reading qgis layer
import sda4ppReadQGISLayer
# load available R packages
import sda4ppLoadRlib
# R options
import sda4ppRoptions

class RggobiTool(QtGui.QDialog, Ui_rggobiDialog):
  def __init__(self, iface):
    QtGui.QDialog.__init__(self)
    # save reference to the QGIS interface
    self.iface = iface
    # Set up the user interface from Designer.
    self.setupUi(self)
    self.setFixedSize(self.size())
    # initialize for wl
    self.index = {"inputFilePath":"", "inputFileName":"",
                  "outputFilePath":"", "outputFileName":"",
                  "fileFormat":"csv"}
    # read the name of qgis layer
    self.readInputFile()
    QtCore.QObject.connect(self.chkOption,
        QtCore.SIGNAL("clicked()"), self.chkOption_changed)
    QtCore.QObject.connect(self.cmbPointLayer,
        QtCore.SIGNAL("activated(QString )"), self.cmbPointLayer_changed)
    QtCore.QObject.connect(self.btnSave,
        QtCore.SIGNAL("clicked()"), self.btnSave_changed)
    QtCore.QObject.connect(self.btnCancel,
        QtCore.SIGNAL("clicked()"), self.runClose)
    QtCore.QObject.connect(self.btnApply,
        QtCore.SIGNAL("clicked()"), self.runApply)
    QtCore.QObject.connect(self.btnHelp,
        QtCore.SIGNAL("clicked()"), self.runHelp)

  def runClose(self):
    self.reject()

  def runHelp(self):
    sda4ppDisplayHelpFile.DisplayHelpFile("Rggobi")

  def getUniqueOutputFileName(self, file=""):
    notFileExist = 0
    counter = 0
    if file == "":
      file = self.ReadPointLayer.createOutputDir() + "rggobi"
    while (notFileExist == 0):
      outputFilename = file + "_" + str(counter) + ".csv"
      if not(os.path.exists(outputFilename)):
        self.index["outputFilePath"] = outputFilename
        self.txtPath.setText(outputFilename)
        layerSource = QtCore.QFileInfo(outputFilename)
        self.index["outputFileName"] = str(layerSource.completeBaseName())
        notFileExist = 1
      else:
        counter = counter + 1

  def changeExtension(self):
    if self.index["outputFilePath"] != "":
      f = QtCore.QFileInfo(self.index["outputFilePath"])
      if f.suffix() != "csv":
        self.index["outputFilePath"] = f.path() + "/" + f.completeBaseName() + ".csv"
      if not(os.path.exists(self.index["outputFilePath"])):
        self.txtPath.setText(self.index["outputFilePath"])
        self.index["outputFileName"] = f.completeBaseName()
      else:
        file =f.path() + "/" + f.completeBaseName()
        self.getUniqueOutputFileName(file)

  def btnSave_changed(self):
    (self.index["outputFilePath"], foo) = self.ReadPointLayer.saveDialog(self,
                                                extension = "csv")
    if self.index["outputFilePath"] is None:
      self.index["outputFilePath"] = str(self.txtPath.text())
      return
    self.changeExtension()

  def chkOption_changed(self):
    if self.cmbPointLayer.currentIndex() == -1:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "Please add point typed vector layer in QGIS.")
      return
    if self.chkOption.checkState() == 2:
      self.btnSave.setEnabled(True)
      self.txtPath.setEnabled(True)
      self.getUniqueOutputFileName()
    elif self.chkOption.checkState() == 0:
      self.btnSave.setEnabled(False)
      self.txtPath.setEnabled(False)
      self.txtPath.clear()
      self.index["fileFormat"] = ""
      self.index["outputFilePath"] = ""

  def cmbPointLayer_changed(self):
    dt = "rggobi-cmbPointLayer_changed"
    #update source of layer
    (self.index["inputFilePath"], self.index["inputFileName"]) = \
       self.ReadPointLayer.getFileSource (self.cmbPointLayer.currentText())
    # readOGR
    error = sda4ppRoptions.readOGR(self.R,self.index["inputFilePath"],
					self.index["inputFileName"])
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return
    wl.wl("index: " + str(self.index),dt)

  def readInputFile(self):
    dt = "rggobi-readInputFile"
    # load R library
    import rpy2.robjects as robjects
    self.R = robjects.r
    errorChecking = sda4ppLoadRlib.loadRggobi(self.R)
    if not (errorChecking):
      try:
        self.R.library("rggobi")
      except Exception, e:
        QtGui.QMessageBox.information(self.iface.mainWindow(), 
		 "SDA4PP Plugin Error",
                 "R library, rggobi, could not be loaded;\n" + str(e) + \
                 "\nPlease, install 'rggobi' package with dependencies " + \
                 "or\nuse 'Components/R Packages' tool in the SDA4PP menu.")
        wl.wl("rggobi package could not be loaded;\n" + str(e),dt)
      return
    # read inputFile
    wl.wl("init ReadQGISLayer class for POINT layer.",dt)
    self.ReadPointLayer = sda4ppReadQGISLayer.ReadQgisLayer(self.iface)
    layers = self.ReadPointLayer.getLayerList()
    wl.wl("layers: " +str(layers),dt)
    if layers == []:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "Please add point typed vector layers in QGIS.")
      return
    for layer in layers:
      self.cmbPointLayer.addItem(layer)
    # inputFile
    (self.index["inputFilePath"], self.index["inputFileName"]) = \
       self.ReadPointLayer.getFileSource (self.cmbPointLayer.currentText())
    # readOGR
    error = sda4ppRoptions.readOGR(self.R,self.index["inputFilePath"],
					self.index["inputFileName"])
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return
    wl.wl("index: " + str(self.index),dt)
    return

  def runApply(self):
    dt = "rggobi-runApply"
    #BEGIN SECTION: inputFile
    if self.cmbPointLayer.currentIndex() == -1:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "Please add point typed vector layer in QGIS.")
      return
    # could not save postgis layer as shp file
    if self.index["inputFilePath"] == 'error':
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", self.fileBaseName)
      return
    #BEGIN SECTION: R part
    self.btnApply.setEnabled(False)
    wl.wl("index: " + str(self.index),dt)
    # apply analysis part to R
    rggobiRpart.doSpatialAnalysis(self.R, self.index)
    self.btnApply.setEnabled(True)
    self.close()
