# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
from PyQt4 import QtCore
from PyQt4 import QtGui
from qgis.core import *
# write to log.file
import wl
# load form
from ui_menuConsoleR import Ui_menuConsoleRDialog
# reading qgis layer
import sda4ppReadQGISLayer
# check available R packages
import sda4ppLoadRlib

class MenuConsoleR(QtGui.QDialog, Ui_menuConsoleRDialog):
  def __init__(self, iface, importQGIS = True, batchInstDisp = []):
    QtGui.QDialog.__init__(self)
    # save reference to the QGIS interface
    self.iface = iface
    # Set up the user interface from Designer.
    self.setupUi(self)
    self.setFixedSize(self.size())
    QtCore.QObject.connect(self.txtRpy, QtCore.SIGNAL("returnPressed()"),
                           self.entered)
    # check to have rpy2, R-cran
    (result, self.r) = sda4ppLoadRlib.checkPartners()
    dt = "menuConsoleR-__init__"
    # required for installRpackages: importQGIS is false in installRpackages, 
    # since no need to load any r libraries and import layer
    if importQGIS:
      # ready to use packages
      if result:
        # load R libs
        self.textEdit_history.append("Loading plugin related R libraries...\n")
        status = ""
        if sda4ppLoadRlib.loadRgdal(self.r):
          status += "rgdal package is loaded.\n"
          if sda4ppLoadRlib.loadMaptools(self.r):
            status += "maptools package is loaded.\n"
            if sda4ppLoadRlib.loadSpatstat(self.r):
              status += "spatstat package is loaded.\n"
            else:
              status += "spatstat package could not be loaded.\n"
          else:
            status += "maptools package could not be loaded.\n"
        else:
          status += "rgdal package could not be loaded.\n"
        self.textEdit_history.append(status)
        # import layers
        self.ReadAllLayer = sda4ppReadQGISLayer.ReadQgisLayer(self.iface,"all")
        layers = self.ReadAllLayer.getLayerList()
        if layers == []:
          self.textEdit_history.append("No layer in the TOC.\n")
        else:
          if sda4ppLoadRlib.loadRgdal(self.r):
            codeTxt = []
            for layer in layers:
              (path, file, geom) = self.ReadAllLayer.getFileSource(layer)
              codeTxt.append(str(file) + " <- readOGR(dsn='" + str(path) + \
                           "', layer='" + str(file) + "')")
            for code in codeTxt:
              self.commands(code, outText="False")
            self.textEdit_history.append("Imported layers from QGIS & R objects;")
            self.commands("ls()")
          else:
            self.textEdit_history.append("Rgdal could not be loaded.\n" + \
                                       "So, no layer imported from the TOC.\n")
        self.textEdit_history.append("-*------------------------------------" + \
                                     "---------------------------------------*-")
      else:
        wl.wl("The error: " + str(self.r),dt)
    else:
      for instDisp in batchInstDisp:
        wl.wl("instDisp: " + str(instDisp),dt)
        self.textEdit_history.append(str(instDisp))

  def keyPressEvent(self, event):
    if event.key() == QtCore.Qt.Key_Up: #Qt.Key.
      self.txtRpy.undo()
      self.txtRpy.deselect()
    elif event.key() == QtCore.Qt.Key_Down:
      self.txtRpy.redo()
      self.txtRpy.deselect()

  def commands(self, rCode, outText="True"):
    try:
      output = self.r(str(rCode))
      if outText == "True":
        if isinstance(output, list):
          for i in output:
            self.textEdit_history.append(str(i))
        else:
          self.textEdit_history.append(str(output))
        self.textEdit_history.append("")
      return True
    except Exception, e:
      self.textEdit_history.append(str(e))
      return False

  def entered(self):
    # When enter is pressed, convert input to R commands
    # Get input text from input bar
    expression = self.txtRpy.text()
    # If the user is trying to exit, ask them if they are sure...
    if expression.contains("quit()") or expression.contains("q()"):
      askQuit = QtGui.QMessageBox.question(self, "Console R Dialog",
                    "Are you sure you want to close Console R Dialog?",
                    QtGui.QMessageBox.Yes, QtGui.QMessageBox.No,
                    QtGui.QMessageBox.NoButton)
      # if they are then quit
      if askQuit == QtGui.QMessageBox.Yes:
        self.closing()
      # Otherwise, send input to self.commands to be converted to R input
    else:
      self.txtRpy.clear()
      self.textEdit_history.append(expression)
      self.commands(expression)
