# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
from PyQt4 import QtCore
from PyQt4 import QtGui
from qgis.core import *
# import the code for the dialog
from ui_iplot import Ui_iplotDialog
# handling outputFile: path name, file name and extension
import os
# run R code
import iplotRpart
# write to logFile.log
import wl
# dialog for open help file and R code 
import sda4ppDisplayHelpFile
# reading qgis layer
import sda4ppReadQGISLayer
# load available R packages
import sda4ppLoadRlib
# R options
import sda4ppRoptions

class IplotTool(QtGui.QDialog, Ui_iplotDialog):
  def __init__(self, iface):
    dt = "iplot-__init__"
    QtGui.QDialog.__init__(self)
    # save reference to the QGIS interface
    self.iface = iface
    # Set up the user interface from Designer.
    self.setupUi(self)
    self.setFixedSize(self.size())
    # init of variables
    self.index = {"turnOnRadio":"Single",
                  "SingleX":"","MultiX":"","MultiY":"",
                  "OptionColorField":"","Linking":0,"OptionSelection":0,
                  "Hist":0,"Coord":0,"Parallel":0,"Bar":0,
                  "MultiParallel":0,"ScatterLowess":0,
                  "ScatterLine":0,"Scatter":0,
                  "inputFile":"","fileBaseName":"",
                  "nonumericfieldError":"","readogrError":""}
    # load R lib, and load layer and field names to comboboxes
    self.readInputFile()
    # event part
    QtCore.QObject.connect(self.radioBtnSingle,
                           QtCore.SIGNAL("clicked()"),
                           self.radioBtnSingle_changed)
    QtCore.QObject.connect(self.radioBtnMulti, QtCore.SIGNAL("clicked()"),
                           self.radioBtnMulti_changed)
    QtCore.QObject.connect(self.cmbPointLayer,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbPointLayer_changed)
    QtCore.QObject.connect(self.btnApply, QtCore.SIGNAL("clicked()"),
                           self.runApply)
    QtCore.QObject.connect(self.btnClose, QtCore.SIGNAL("clicked()"),
                           self.closeRplots)
    QtCore.QObject.connect(self.btnHelp, QtCore.SIGNAL("clicked()"),
                           self.runHelp)
    # single variable checkboxes
    QtCore.QObject.connect(self.cmbSingleX,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbSingleX_changed)
    QtCore.QObject.connect(self.chkSingleBar, QtCore.SIGNAL("clicked()"),
                           self.chkSingleBar_changed)
    QtCore.QObject.connect(self.chkSingleParallel,
                           QtCore.SIGNAL("clicked()"),
                           self.chkSingleParallel_changed)
    QtCore.QObject.connect(self.chkSingleCoord,
                           QtCore.SIGNAL("clicked()"),
                           self.chkSingleCoord_changed)
    QtCore.QObject.connect(self.chkSingleHist, QtCore.SIGNAL("clicked()"),
                           self.chkSingleHist_changed)
    # multi variable checkboxes
    QtCore.QObject.connect(self.cmbMultiX,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbMultiX_changed)
    QtCore.QObject.connect(self.cmbMultiY,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbMultiY_changed)
    QtCore.QObject.connect(self.chkMultiScatter,
                           QtCore.SIGNAL("clicked()"),
                           self.chkMultiScatter_changed)
    QtCore.QObject.connect(self.chkMultiScatterLine,
                           QtCore.SIGNAL("clicked()"),
                           self.chkMultiScatterLine_changed)
    QtCore.QObject.connect(self.chkMultiScatterLowess,
                           QtCore.SIGNAL("clicked()"),
                           self.chkMultiScatterLowess_changed)
    QtCore.QObject.connect(self.chkMultiParallel,
                           QtCore.SIGNAL("clicked()"),
                           self.chkMultiParallel_changed)
    # options section
    QtCore.QObject.connect(self.chkOptionLinking,
                           QtCore.SIGNAL("clicked()"),
                           self.chkOptionLinking_changed)
    QtCore.QObject.connect(self.chkOptionSelection,
                           QtCore.SIGNAL("clicked()"),
                           self.chkOptionSelection_changed)
    QtCore.QObject.connect(self.chkOptionColor,
                           QtCore.SIGNAL("clicked()"),
                           self.chkOptionColor_changed)
    QtCore.QObject.connect(self.cmbOptionColorField,
                           QtCore.SIGNAL("activated(QString )"),
                           self.cmbOptionColorField_changed)

  def closeRplots(self):
    iplotRpart.doCloseAnalysis(self.R)

  def runHelp(self):
    sda4ppDisplayHelpFile.DisplayHelpFile("Iplot")

  def chkOptionLinking_changed(self):
    dt = "iplot-chkOptionLinking_changed"
    self.index["Linking"] = self.chkOptionLinking.checkState()
    wl.wl("index: " +str(self.index),dt)

  def chkMultiScatter_changed(self):
    dt = "iplot-chkMultiScatter_changed"
    if self.chkMultiScatter.checkState() == 2:
      self.index["Scatter"] = 2
      self.chkMultiScatterLine.setEnabled(True)
      self.chkMultiScatterLowess.setEnabled(True)
    elif self.chkMultiScatter.checkState() == 0:
      self.index["Scatter"] = 0
      self.chkMultiScatterLine.setEnabled(False)
      self.chkMultiScatterLowess.setEnabled(False)
      self.chkOptionColor.setEnabled(True)
      self.chkOptionLinking.setEnabled(True)
      self.cmbOptionColorField.setEnabled(True)
    # reset sub-checkbox of scatter
    self.chkMultiScatterLine.setChecked(False)
    self.chkMultiScatterLowess.setChecked(False)
    self.index["ScatterLine"] = 0
    self.index["ScatterLowess"] = 0
    wl.wl("index: " +str(self.index),dt)

  def chkMultiScatterLine_changed(self):
    dt = "iplot-chkMultiScatterLine_changed"
    self.index["ScatterLine"] = self.chkMultiScatterLine.checkState()
    if self.index["ScatterLine"] == 2:
      self.chkOptionColor.setChecked(False)
      self.chkOptionColor.setEnabled(False)
      self.chkOptionLinking.setChecked(False)
      self.chkOptionLinking.setEnabled(False)
      self.cmbOptionColorField.setEnabled(False)
      self.index["OptionColorField"] = ""
      self.index["Linking"] = 0
    else:
      self.chkOptionColor.setEnabled(True)
      self.chkOptionLinking.setEnabled(True)
      self.cmbOptionColorField.setEnabled(True)
    wl.wl("index: " +str(self.index),dt)

  def chkMultiScatterLowess_changed(self):
    dt = "iplot-chkMultiScatterLowess_changed"
    self.index["ScatterLowess"] = self.chkMultiScatterLowess.checkState()
    wl.wl("index: " +str(self.index),dt)

  def chkMultiParallel_changed(self):
    dt = "iplot-chkMultiParallel_changed"
    self.index["MultiParallel"] = self.chkMultiParallel.checkState()
    wl.wl("index: " +str(self.index),dt)

  def chkSingleBar_changed(self):
    dt = "iplot-chkSingleBar_changed"
    self.index["Bar"] = self.chkSingleBar.checkState()
    wl.wl("index: " +str(self.index),dt)

  def chkSingleParallel_changed(self):
    dt = "iplot-chkSingleParallel_changed"
    self.index["Parallel"] = self.chkSingleParallel.checkState()
    wl.wl("index: " +str(self.index),dt)

  def chkSingleCoord_changed(self):
    dt = "iplot-chkSingleCoord_changed"
    self.index["Coord"] = self.chkSingleCoord.checkState()
    wl.wl("index: " +str(self.index),dt)

  def chkSingleHist_changed(self):
    dt = "iplot-chkSingleHist_changed"
    self.index["Hist"] = self.chkSingleHist.checkState()
    wl.wl("index: " +str(self.index),dt)

  def chkOptionSelection_changed(self):
    dt = "iplot-chkOptionSelection_changed"
    if self.chkOptionSelection.checkState() == 2:
      # get id of each selected feature
      (data, rowNumber) = self.ReadPointLayer.getSelectedDataFromIDField()
      # check if nothing selected by the user
      if data == "error":
        QtGui.QMessageBox.information(self.iface.mainWindow(),
              "SDA4PP Plugin Error", rowNumber)
        self.chkOptionSelection.setChecked(False)
        #the error is: No selection found in the map.
        return
      # fill index full of zeros
      indexNewColon = []
      for j in range(rowNumber):
        indexNewColon.append(0)
      # mark the index with 1 for selected one.
      for i in range(len(data)):
        indexNewColon[int(data[i])] = 1
      #convert list to str
      self.index["OptionSelection"] = ""
      for k in range(len(indexNewColon)):
        self.index["OptionSelection"] += str(indexNewColon[k]) + ","
      self.index["OptionSelection"] = self.index["OptionSelection"][:-1]
    else:
      self.index["OptionSelection"] = ""
    wl.wl("index: " +str(self.index),dt)

  def chkOptionColor_changed(self):
    dt = "iplot-chkOptionColor_changed"
    self.cmbOptionColorField.clear()
    if self.chkOptionColor.checkState() == 2:
      self.cmbOptionColorField.setEnabled(True)
      # field names
      fields = self.ReadPointLayer.getFieldNameList(allFieldType="YES")
      wl.wl("fields: " +str(fields),dt)
      if fields == []:
        QtGui.QMessageBox.information(self.iface.mainWindow(),
                 "SDA4PP Plugin Error",
                 "This tool requires at least one field.\n" + \
                 "Please, add any field to the layer, '" + \
                 self.index["inputFileName"] + "'.")
        self.chkOptionColor.setChecked(False)
        self.cmbOptionColorField.setEnabled(False)
        self.index["OptionColorField"] = ""
        return
      for field in fields:
        self.cmbOptionColorField.addItem(field)
      self.index["OptionColorField"] = \
                                     self.cmbOptionColorField.currentText()
    elif self.chkOptionColor.checkState() == 0:
      self.cmbOptionColorField.setEnabled(False)
      self.index["OptionColorField"] = ""
    wl.wl("index: " +str(self.index),dt)

  def cmbOptionColorField_changed(self):
    dt = "iplot-cmbOptionColorField_changed"
    self.index["OptionColorField"] = self.cmbOptionColorField.currentText()
    wl.wl("index: " +str(self.index),dt)

  def resetAllWidgets(self):
    dt = "iplot-resetAllWidgets"
    # multi variable
    self.cmbMultiX.setEnabled(False)
    self.cmbMultiY.setEnabled(False)
    self.chkMultiScatter.setEnabled(False)
    self.chkMultiScatterLine.setEnabled(False)
    self.chkMultiScatterLowess.setEnabled(False)
    self.chkMultiParallel.setEnabled(False)
    # single variable
    self.cmbSingleX.setEnabled(False)
    self.chkSingleBar.setEnabled(False)
    self.chkSingleParallel.setEnabled(False)
    self.chkSingleCoord.setEnabled(False)
    self.chkSingleHist.setEnabled(False)
    # buttons
    self.radioBtnSingle.setEnabled(False)
    self.radioBtnMulti.setEnabled(False)
    self.cmbPointLayer.setEnabled(False)
    self.btnApply.setEnabled(False)
    self.btnClose.setEnabled(False)
    # options section
    self.chkOptionSelection.setEnabled(False)
    self.chkOptionColor.setEnabled(False)
    self.cmbOptionColorField.setEnabled(False)
    self.chkOptionLinking.setEnabled(False)
    wl.wl("index: " +str(self.index),dt)

  def radioBtnSingle_changed(self):
    dt = "iplot-radioBtnSingle_changed"
    if self.index["nonumericfieldError"] == "":
      self.index["turnOnRadio"] = "Single"
      # single variable
      self.cmbSingleX.setEnabled(True)
      self.chkSingleBar.setEnabled(True)
      self.chkSingleParallel.setEnabled(True)
      self.chkSingleCoord.setEnabled(True)
      self.chkSingleHist.setEnabled(True)
      # multi variable
      self.cmbMultiX.setEnabled(False)
      self.cmbMultiY.setEnabled(False)
      self.chkMultiScatter.setEnabled(False)
      self.chkMultiScatterLine.setEnabled(False)
      self.chkMultiScatterLowess.setEnabled(False)
      self.chkMultiParallel.setEnabled(False)
      # reset checkbox
      self.chkMultiScatter.setChecked(False)
      self.chkMultiScatterLine.setChecked(False)
      self.chkMultiScatterLowess.setChecked(False)
      self.chkMultiParallel.setChecked(False)
      # add field to combo
      self.cmbSingleX_changed()
      wl.wl("index: " +str(self.index),dt)

  def radioBtnMulti_changed(self):
    dt = "iplot-radioBtnMulti_changed"
    if self.index["nonumericfieldError"] == "":
      self.index["turnOnRadio"] = "Multi"
      # single variable
      self.cmbSingleX.setEnabled(False)
      self.chkSingleBar.setEnabled(False)
      self.chkSingleParallel.setEnabled(False)
      self.chkSingleCoord.setEnabled(False)
      self.chkSingleHist.setEnabled(False)
      # reset checkbox
      self.chkSingleBar.setChecked(False)
      self.chkSingleParallel.setChecked(False)
      self.chkSingleCoord.setChecked(False)
      self.chkSingleHist.setChecked(False)
      # multi variable
      self.cmbMultiX.setEnabled(True)
      self.cmbMultiY.setEnabled(True)
      self.chkMultiScatter.setEnabled(True)
      self.chkMultiParallel.setEnabled(True)
      # add field to combo
      self.cmbMultiX_changed()
      self.cmbMultiY_changed()
      wl.wl("index: " +str(self.index),dt)

  def popComboWithFields(self, combo):
    dt = "iplot-popComboWithFields"
    combo.clear()
    wl.wl("load fieldnames to combobox.",dt)
    for fieldName in self.fieldNTdict.iterkeys():
      combo.addItem(str(fieldName))
    wl.wl("combo.currentText(): " +str(combo.currentText()),dt)

  def cmbSingleX_changed(self):
    dt = "iplot-cmbSingleX_changed"
    self.index["nonumericfieldError"] = ""
    self.index["SingleX"] = str(self.cmbSingleX.currentText())
    wl.wl("index: " +str(self.index),dt)
    wl.wl("fieldNTdict: " +str(self.fieldNTdict),dt)
    # update field type label
    self.txtSingle_ftype.setText("Field Type: " + \
                        str(self.fieldNTdict[self.index["SingleX"]]))

  def cmbMultiX_changed(self):
    dt = "iplot-cmbMultiX_changed"
    self.index["nonumericfieldError"] = ""
    self.index["MultiX"] = str(self.cmbMultiX.currentText())
    wl.wl("index: " +str(self.index),dt)
    wl.wl("fieldNTdict: " +str(self.fieldNTdict),dt)
    # update field type label
    self.txtMultiX_ftype.setText("Field Type: " + \
                        str(self.fieldNTdict[self.index["MultiX"]]))

  def cmbMultiY_changed(self):
    dt = "iplot-cmbMultiY_changed"
    self.index["nonumericfieldError"] = ""
    self.index["MultiY"] = str(self.cmbMultiY.currentText())
    wl.wl("index: " +str(self.index),dt)
    wl.wl("fieldNTdict: " +str(self.fieldNTdict),dt)
    # update field type label
    self.txtMultiY_ftype.setText("Field Type: " + \
                        str(self.fieldNTdict[self.index["MultiY"]]))

  def cmbPointLayer_changed(self):
    dt = "iplot-cmbPointLayer_changed"
    self.index["readogrError"] = ""
    #update source of layer
    (self.index["inputFilePath"], self.index["inputFileName"]) = \
       self.ReadPointLayer.getFileSource (self.cmbPointLayer.currentText())
    # get field name and field type
    self.fieldNTdict = self.ReadPointLayer.getFieldNameList(\
                                            returnFieldType="YES")
    wl.wl("fieldNTdict: " +str(self.fieldNTdict),dt)
    if self.fieldNTdict == {}:
      self.index["nonumericfieldError"] = \
              "This tool requires at least one numeric field.\n\n" + \
              "Please, add one numeric field to the layer, '" + \
              self.index["inputFileName"] + \
              "',nor do not use this layer for this analysis."
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", self.index["nonumericfieldError"])
    else:
      self.index["nonumericfieldError"] = ""
      self.addFieldNamesToCombobox()
    wl.wl("index: " +str(self.index),dt)

  def addFieldNamesToCombobox(self):
    dt = "iplot-addFieldNamesToCombobox"
    wl.wl("cmbSingleX will be populated with field names",dt)
    self.popComboWithFields(self.cmbSingleX)
    self.cmbSingleX_changed()
    wl.wl("cmbMultiX will be populated with field names",dt)
    self.popComboWithFields(self.cmbMultiX)
    self.cmbMultiX_changed()
    wl.wl("cmbMultiY will be populated with field names",dt)
    self.popComboWithFields(self.cmbMultiY)
    self.cmbMultiY_changed()

  def readInputFile(self):
    dt = "iplot-readInputFile"
    # load R library
    import rpy2.robjects as robjects
    # self.Robjects is required for doMultiAnalysis in runApply.
    self.Robjects = robjects
    self.R = robjects.r
    errorChecking = sda4ppLoadRlib.loadIplot(self.R)
    if not (errorChecking):
      try:
        self.R.library("rJava")
        self.R.library("iplots")
      except Exception, e:
        QtGui.QMessageBox.information(self.iface.mainWindow(), "SDA4PP Plugin Error",
                 "R library, iplots, could not be loaded;\n" + str(e) + \
                 "\nPlease, install 'iplots' package with all dependencies or\n" + \
                 "use 'Components/R Packages' tool in the SDA4PP menu.")
        wl.wl("iplots package could not be loaded;\n" + str(e),dt)
        self.resetAllWidgets()
        return
    # read inputFile
    wl.wl("init ReadQGISLayer class",dt)
    self.ReadPointLayer = sda4ppReadQGISLayer.ReadQgisLayer(self.iface)
    layers = self.ReadPointLayer.getLayerList(checkNumericField="YES")
    wl.wl("layers: " +str(layers),dt)
    if layers == []:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "Please add point typed vector layers in QGIS.")
      self.resetAllWidgets()
      return
    for layer in layers:
      self.cmbPointLayer.addItem(layer)
    # inputFile
    (self.index["inputFilePath"], self.index["inputFileName"]) = \
       self.ReadPointLayer.getFileSource (self.cmbPointLayer.currentText())
    # readOGR
    error = sda4ppRoptions.readOGR(self.R,self.index["inputFilePath"],self.index["inputFileName"])
    if error != 0:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", error)
      return "error"
    # get field name and field type
    self.fieldNTdict = self.ReadPointLayer.getFieldNameList(\
                                            returnFieldType="YES")
    wl.wl("fieldNTdict: " +str(self.fieldNTdict),dt)
    if self.fieldNTdict == {}:
      self.index["nonumericfieldError"] = \
              "This tool requires at least one numeric field.\n\n" + \
              "Please, add one numeric field to the layer, '" + \
              self.index["inputFileName"] + \
              "',nor do not use this layer for this analysis."
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", self.index["nonumericfieldError"])
    else:
      self.index["nonumericfieldError"] = ""
      self.addFieldNamesToCombobox()
    return

  def runApply(self):
    dt = "iplot-runApply"
    #inputFile
    if self.cmbPointLayer.currentIndex() == -1:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error",
            "Please add point typed vector layer in QGIS.")
      self.resetAllWidgets()
      return
    # could not save postgis layer as shp file
    if self.index["inputFilePath"] == 'error':
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", self.fileBaseName)
      self.resetAllWidgets()
      return
    # if none of the plot type is checked, gives error
    if self.index["turnOnRadio"] == "Single":
      if self.index["Hist"] == 0 and self.index["Coord"] == 0 and \
             self.index["Parallel"] == 0 and self.index["Bar"] == 0:
        QtGui.QMessageBox.information(self.iface.mainWindow(),
              "SDA4PP Plugin Error", "Please check any plot to draw")
        return
    else:
      if self.index["MultiParallel"] == 0 and self.index["Scatter"] == 0:
        QtGui.QMessageBox.information(self.iface.mainWindow(),
              "SDA4PP Plugin Error", "Please check any plot to draw")
        return
    # nonumericfieldError
    if self.index["nonumericfieldError"] != "":
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", self.index["nonumericfieldError"])
      return
    # informative msg about how to stop the linked display
    if self.index["Linking"] == 2:
      QtGui.QMessageBox.information(self.iface.mainWindow(),
            "How to use linked display",
            "1. Click on the plot to make selection\n\n" + \
            "2. In order to finish the selection on the plot,\n" + \
            "Select 'Break' from File Menu of any plot or " + \
            "Click 'Ctrl+Shift+B'\n\n" + \
            "3. Selected Value on the plot will be highlighted" + \
            " at the layer\nand will be returned back to QGIS...\n\n" + \
            "Do not close the plot without 'Break' the event...")
    #R part
    wl.wl("index: " +str(self.index),dt)
    self.btnApply.setEnabled(False)
    if self.index["turnOnRadio"] == "Single":
      recordList = iplotRpart.doSingleAnalysis(self.R, self.index)
    else:
      recordList = iplotRpart.doMultiAnalysis(self.R, self.Robjects, self.index)
    self.btnApply.setEnabled(True)
    # linked display is active
    if recordList != 0:
      wl.wl("recordList: " +str(recordList),dt)
      self.ReadPointLayer.setSelectionFromQuery(recordList)
    # plots are drawn without error,
    # so closing all R plots button can do his job.
    self.close()
