# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
# R options
import sda4ppRoptions
# write to logFile.log
import wl
import math

def doSpatialAnalysis (r, index):
  dt="quadrattestRpart-doSpatialAnalysis"
  wl.wl("index: " + str(index),dt)
  r("sp_est <- as(v_spdf,\"SpatialPoints\")")
  r("ppp_est <- as(sp_est,\"ppp\")")
  if index["option"]:
    w = r("w <- ppp_est$window")
    a = r("area <- area.owin(w)")
    ax = r("ax <- max(w$xrange)-min(w$xrange)")
    ay = r("ay <- max(w$yrange)-min(w$yrange)")
    n = r("n <- ppp_est$n")
    qs = math.sqrt((2 * a[0]) / n[0])
    qx = int(round((ax[0] / qs),0))
    qy = int(round((ay[0] / qs),0))
    return qx, qy
  # quadrat
  if index["fitModel"]:
    r("fitx <- ppm(ppp_est, ~x, Poisson())")
    r("q_est <- quadrat.test(fitx, nx=" + str(index["xDiv"]) + ", ny=" + \
      str(index["yDiv"]) + ")")
    r("mainTitle <- \"Chi-squared Test of fitted Poisson Model\" ")
  else:
    r("q_est <- quadrat.test(ppp_est, nx=" + str(index["xDiv"]) + ", ny=" + \
      str(index["yDiv"]) + ")")
    r("mainTitle <- \"Chi-squared Test of CSR using Quadrat Counts\" ")
  # output parameters
  txt = []
  txt.append("method:\n" + str(r("q_est$method")[0]))
  txt.append("\n" + str(r("q_est$statistic")))
  txt.append("\n" + str(r("q_est$parameter")))
  txt.append("\np-value:\n" + str(r("q_est$p.value")[0]))
  # observed
  obs = r("q_est$observed")
  o = ""
  for ob in obs:
    o += str(ob) + " "
  txt.append("\nobserved:\n" + str(o))
  # expected
  exp = r("q_est$expected")
  e = ""
  for ex in exp:
    e += str(ex) + " "
  txt.append("\nexpected:\n" + str(e))
  # residuals
  res = r("q_est$residuals")
  d = ""
  for re in res:
    d += str(re) + " "
  txt.append("\nresiduals:\n" + str(d))
  # plot
  if index["plot"]:
    rcodes = ["plot(ppp_est, pch=\"+\", cols=\"green\", lwd=2, main=mainTitle)",
              "plot(q_est, add=TRUE, col=\"red\", cex=1.4, lty=2, lwd=3)"]
    sda4ppRoptions.plotGraphics(r, rcodes)
  # save
  if index["save"]:
    r("qa <- attr(q_est,\"quadratcount\")")
    r("qat <- attr(qa,\"tess\")")
    r("x = qat$xgrid")
    r("y = qat$ygrid")
    r("dx = x[2]-x[1]")
    r("dy = y[2]-y[1]")
    r("x_d = x[1] + (dx/2)")
    r("y_d = y[1] + (dy/2)")
    r("grid_q <- GridTopology (c(x_d,y_d),c(dx,dy),c(" + \
      str(index["xDiv"]) + "," + str(index["yDiv"]) + "))")
    r("polys <- as.SpatialPolygons.GridTopology(grid_q)")
    r("proj4string(polys) <- CRS(\"" + str(index["projText"]) + "\")")
    cTxt = "at_df = data.frame(observed=q_est$observed, " + \
           "expected=round(q_est$expected,3), " + \
           "residuals=round(q_est$residuals,7), " + \
           "row.names=sapply(slot(polys,\"polygons\"), " + \
           "function(i) slot(i,\"ID\")))"
    r(cTxt)
    r("spdf = SpatialPolygonsDataFrame(polys, at_df)")
    r("writeOGR(spdf,\"" + str(index["outputFilePath"]) + "\",\"" + \
      str(index["outputFileName"]) + "\", driver=\"ESRI Shapefile\")")
  return txt
