# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
from PyQt4 import QtCore
from PyQt4 import QtGui
# load form
from ui_menuGraphicsConf import Ui_graphicsDialog
import os
# write to logFile.log
import wl 

class MenuGraphicsConf(QtGui.QDialog, Ui_graphicsDialog):
  def __init__(self, iface):
    QtGui.QDialog.__init__(self)
    self.iface = iface
    self.setupUi(self)
    self.setFixedSize(self.size())
    dt = "MenuGraphicsConf-__init__"
    # r device widgets
    QtCore.QObject.connect(self.chkRdevice,
        QtCore.SIGNAL("clicked()"), self.useRdevice)
    QtCore.QObject.connect(self.rbRdefault,
        QtCore.SIGNAL("clicked()"), self.rbRdefault_changed)
    QtCore.QObject.connect(self.rbRcustom,
        QtCore.SIGNAL("clicked()"), self.rbRcustom_changed)
    QtCore.QObject.connect(self.spRpointsize,
        QtCore.SIGNAL("valueChanged(QString )"), self.spRpointsize_changed)
    # png device widgets
    QtCore.QObject.connect(self.chkPNGdevice,
        QtCore.SIGNAL("clicked()"), self.usePNGdevice)
    QtCore.QObject.connect(self.btnSave,
        QtCore.SIGNAL("clicked()"), self.doSave)
    QtCore.QObject.connect(self.btnDefaults,
        QtCore.SIGNAL("clicked()"), self.doLoadDefaultValues)
    QtCore.QObject.connect(self.radioBtnOverwrite,
        QtCore.SIGNAL("clicked()"), self.radioBtnOverwrite_changed)
    QtCore.QObject.connect(self.radioBtnKeep,
        QtCore.SIGNAL("clicked()"), self.radioBtnKeep_changed)
    QtCore.QObject.connect(self.radioBtnPluginFolder,
        QtCore.SIGNAL("clicked()"), self.radioBtnPluginFolder_changed)
    QtCore.QObject.connect(self.radioBtnNewFolder,
        QtCore.SIGNAL("clicked()"), self.radioBtnNewFolder_changed)
    QtCore.QObject.connect(self.cmbUnits,
        QtCore.SIGNAL("activated(QString )"), self.cmbUnits_changed)
    QtCore.QObject.connect(self.dSpinBoxWidth,
        QtCore.SIGNAL("valueChanged(QString )"), self.dSpinBoxWidth_changed)
    QtCore.QObject.connect(self.dSpinBoxHeight,
        QtCore.SIGNAL("valueChanged(QString )"), self.dSpinBoxHeight_changed)
    QtCore.QObject.connect(self.spinBoxRes,
        QtCore.SIGNAL("valueChanged(QString )"), self.spinBoxRes_changed)
    ## PNG device part
    # QSetting part for graphics
    self.index = wl.manageConfFile(mode="read", index="", tool="graphics")
    wl.wl("index: " +str(self.index),dt)
    # use R device
    if not self.index["Rdevice"]:
      self.chkRdevice.setChecked(False)
      self.rbRdefault.setEnabled(False)
      self.rbRcustom.setEnabled(False)
    else:
      self.chkRdevice.setChecked(True)
      self.rbRdefault.setEnabled(True)
      self.rbRcustom.setEnabled(True)
    # use PNG device
    if not self.index["PNGdevice"]:
      self.chkPNGdevice.setChecked(False)
      self.radioBtnOverwrite.setEnabled(False)
      self.radioBtnKeep.setEnabled(False)
      self.radioBtnPluginFolder.setEnabled(False)
      self.radioBtnNewFolder.setEnabled(False)
      self.cmbUnits.setEnabled(False)
      self.dSpinBoxWidth.setEnabled(False)
      self.dSpinBoxHeight.setEnabled(False)
      self.spinBoxRes.setEnabled(False)
    else:
      self.chkPNGdevice.setChecked(True)
      self.radioBtnOverwrite.setEnabled(True)
      self.radioBtnKeep.setEnabled(True)
      self.radioBtnPluginFolder.setEnabled(True)
      self.radioBtnNewFolder.setEnabled(True)
      self.cmbUnits.setEnabled(True)
      self.dSpinBoxWidth.setEnabled(True)
      self.dSpinBoxHeight.setEnabled(True)
      self.spinBoxRes.setEnabled(True)
    # PNG device widgets
    # graphic unit
    if self.index["units"] == "px":
      self.cmbUnits.setCurrentIndex(0)
    elif self.index["units"] == "in":
      self.cmbUnits.setCurrentIndex(1)
    elif self.index["units"] == "cm":
      self.cmbUnits.setCurrentIndex(2)
    # graphic size
    self.prevUnit = self.index["units"]
    self.dSpinBoxWidth.setValue(float(self.index["width"]))
    self.dSpinBoxHeight.setValue(float(self.index["height"]))
    self.spinBoxRes.setValue(int(self.index["res"]))
    # overwrite to file
    if self.index["overwrite"]:
      self.radioBtnOverwrite.setChecked(True)
      self.radioBtnKeep.setChecked(False)
    else:
      self.radioBtnOverwrite.setChecked(False)
      self.radioBtnKeep.setChecked(True)
    # folder
    if self.index["folder"]:
      self.radioBtnPluginFolder.setChecked(True)
      self.radioBtnNewFolder.setChecked(False)
      self.txtNewFolder.setText("")
    else:
      self.radioBtnPluginFolder.setChecked(False)
      self.radioBtnNewFolder.setChecked(True)
      self.txtNewFolder.setText(str(self.index["folderPath"]))
    ## R device part
    # QSetting part for rplot
    self.valueR = wl.manageConfFile(mode="read", index="", tool="rplot")
    wl.wl("valueR: " +str(self.valueR),dt)
    # 1 for default radio button, 0 for custom radio button
    if self.valueR["default"]:
      self.rWidgetStatus(useDeviceValue="default", noChangeInRb=False)
    else:
      self.rWidgetStatus(useDeviceValue="custom", noChangeInRb=False)
    # R device widgets
    self.txtRwidth.setText(str(self.valueR["width"]))
    self.txtRheight.setText(str(self.valueR["height"]))
    self.txtRxpos.setText(str(self.valueR["xpos"]))
    self.txtRypos.setText(str(self.valueR["ypos"]))
    self.spRpointsize.setValue(self.valueR["pointsize"])

  def rWidgetStatus(self, useDeviceValue="default", noChangeInRb=True):
    if useDeviceValue == "default":
      self.rbRdefault.setChecked(True)
      self.rbRcustom.setChecked(False)
      if noChangeInRb:
        self.rbRdefault.setEnabled(False)
        self.rbRcustom.setEnabled(False)
      self.txtRwidth.setEnabled(False)
      self.txtRheight.setEnabled(False)
      self.txtRxpos.setEnabled(False)
      self.txtRypos.setEnabled(False)
      self.spRpointsize.setEnabled(False)
    else:
      self.rbRdefault.setChecked(False)
      self.rbRcustom.setChecked(True)
      if noChangeInRb:
        self.rbRdefault.setEnabled(True)
        self.rbRcustom.setEnabled(True)
      self.txtRwidth.setEnabled(True)
      self.txtRheight.setEnabled(True)
      self.txtRxpos.setEnabled(True)
      self.txtRypos.setEnabled(True)
      self.spRpointsize.setEnabled(True)

  def useRdevice(self):
    if int(str(self.chkRdevice.checkState())) == 0:
      self.index["Rdevice"] = False
    elif int(str(self.chkRdevice.checkState())) == 2:
      self.index["Rdevice"] = True
    if not self.index["Rdevice"]:
      self.rWidgetStatus(useDeviceValue="default")
    else:
      self.rbRdefault.setEnabled(True)
      self.rbRcustom.setEnabled(True)
    # if both of them are checked, no device to show graphics.
    # So, user could not check this option
    if (not self.index["PNGdevice"]) and (not self.index["Rdevice"]):
      self.btnSave.setEnabled(False)
      QtGui.QMessageBox.information(self.iface.mainWindow(),
         "Graphic Display Option Error",
         "Please check at least one device in order to show the graphics.")
    else:
      self.btnSave.setEnabled(True)

  def usePNGdevice(self):
    if int(str(self.chkPNGdevice.checkState())) == 0:
      self.index["PNGdevice"] = False
    elif int(str(self.chkPNGdevice.checkState())) == 2:
      self.index["PNGdevice"] = True
    if not self.index["PNGdevice"]:
      self.radioBtnOverwrite.setEnabled(False)
      self.radioBtnKeep.setEnabled(False)
      self.radioBtnPluginFolder.setEnabled(False)
      self.radioBtnNewFolder.setEnabled(False)
      self.cmbUnits.setEnabled(False)
      self.dSpinBoxWidth.setEnabled(False)
      self.dSpinBoxHeight.setEnabled(False)
      self.spinBoxRes.setEnabled(False)
    else:
      self.radioBtnOverwrite.setEnabled(True)
      self.radioBtnKeep.setEnabled(True)
      self.radioBtnPluginFolder.setEnabled(True)
      self.radioBtnNewFolder.setEnabled(True)
      self.cmbUnits.setEnabled(True)
      self.dSpinBoxWidth.setEnabled(True)
      self.dSpinBoxHeight.setEnabled(True)
      self.spinBoxRes.setEnabled(True)
    # if both of them are checked, no device to show graphics.
    # So, user could not check this option
    if (not self.index["PNGdevice"]) and (not self.index["Rdevice"]):
      self.btnSave.setEnabled(False)
      QtGui.QMessageBox.information(self.iface.mainWindow(),
         "Graphic Display Option Error",
         "Please check at least one device in order to show the graphics.")
    else:
      self.btnSave.setEnabled(True)

  def cmbUnits_changed(self):
    dt = "menuGraphicsConf-cmbUnits_changed"
    # newUnit: 0 for pixel, 1 for inch, 2 for cm
    if int(self.cmbUnits.currentIndex()) == 0:
      newUnit = "px"
    elif int(self.cmbUnits.currentIndex()) == 1:
      newUnit = "in"
    elif int(self.cmbUnits.currentIndex()) == 2:
      newUnit = "cm"
    self.index["units"] = newUnit
    wl.wl("prevUnit: " + str(self.prevUnit),dt)
    wl.wl("newUnit: " + str(newUnit),dt)
    #conversion from px to in
    if self.prevUnit == "px" and newUnit == "in":
      self.dSpinBoxWidth.setValue(float(\
          self.dSpinBoxWidth.value()/self.spinBoxRes.value()))
      self.dSpinBoxHeight.setValue(float(\
          self.dSpinBoxHeight.value()/self.spinBoxRes.value()))
      #conversion from px to cm
    elif self.prevUnit == "px" and newUnit == "cm":
      self.dSpinBoxWidth.setValue(float(\
          2.54 * self.dSpinBoxWidth.value()/self.spinBoxRes.value()))
      self.dSpinBoxHeight.setValue(float(\
          2.54 * self.dSpinBoxHeight.value()/self.spinBoxRes.value()))
      #conversion from in to cm
    elif self.prevUnit == "in" and newUnit == "cm":
      self.dSpinBoxWidth.setValue(float(\
          2.54 * self.dSpinBoxWidth.value()))
      self.dSpinBoxHeight.setValue(float(\
          2.54 * self.dSpinBoxHeight.value()))
      #conversion from in to px
    elif self.prevUnit == "in" and newUnit == "px":
      self.dSpinBoxWidth.setValue(float(\
          self.dSpinBoxWidth.value() * self.spinBoxRes.value()))
      self.dSpinBoxHeight.setValue(float(\
          self.dSpinBoxHeight.value() * self.spinBoxRes.value()))
      #conversion from cm to in
    elif self.prevUnit == "cm" and newUnit == "in":
      self.dSpinBoxWidth.setValue(float(\
          0.3937008 * self.dSpinBoxWidth.value()))
      self.dSpinBoxHeight.setValue(float(\
          0.3937008 * self.dSpinBoxHeight.value()))
      #conversion from cm to px
    elif self.prevUnit == "cm" and newUnit == "px":
      self.dSpinBoxWidth.setValue(float(\
        0.3937008 * self.dSpinBoxWidth.value() * self.spinBoxRes.value()))
      self.dSpinBoxHeight.setValue(float(\
        0.3937008 * self.dSpinBoxHeight.value() * self.spinBoxRes.value()))
    if int(self.cmbUnits.currentIndex()) == 0:
      self.prevUnit = "px"
    elif int(self.cmbUnits.currentIndex()) == 1:
      self.prevUnit = "in"
    elif int(self.cmbUnits.currentIndex()) == 2:
      self.prevUnit = "cm"
    self.dSpinBoxWidth_changed()
    self.dSpinBoxHeight_changed()
    wl.wl("index: " +str(self.index),dt)

  def dSpinBoxWidth_changed(self):
    self.index["width"] = round(float(str(self.dSpinBoxWidth.value())),2)

  def dSpinBoxHeight_changed(self):
    self.index["height"] = round(float(str(self.dSpinBoxHeight.value())),2)

  def spinBoxRes_changed(self):
    self.index["res"] = int(str(self.spinBoxRes.value()))

  def spRpointsize_changed(self):
    self.valueR["pointsize"] = int(str(self.spRpointsize.value()))

  def rbRdefault_changed(self):
    self.valueR["default"] = True
    self.rWidgetStatus(useDeviceValue="default", noChangeInRb=False)

  def rbRcustom_changed(self):
    self.valueR["default"] = False
    self.rWidgetStatus(useDeviceValue="custom", noChangeInRb=False)

  def radioBtnOverwrite_changed(self):
    self.index["overwrite"] = True
    self.radioBtnKeep.setChecked(False)

  def radioBtnKeep_changed(self):
    self.index["overwrite"] = False
    self.radioBtnOverwrite.setChecked(False)

  def radioBtnPluginFolder_changed(self):
    self.index["folder"] = True
    self.index["folderPath"] = ""
    self.txtNewFolder.setText("")
    self.radioBtnNewFolder.setChecked(False)

  def radioBtnNewFolder_changed(self):
    self.index["folder"] = False
    self.index["folderPath"] = str(QtGui.QFileDialog.getExistingDirectory(\
        self, "Choose folder to save graphic files", ""))
    if self.index["folderPath"] == "":
      self.radioBtnPluginFolder.setChecked(True)
      self.radioBtnPluginFolder_changed()
      return
    self.txtNewFolder.setText(self.index["folderPath"])
    self.radioBtnPluginFolder.setChecked(False)

  def doSave(self):
    dt = "menuGraphicsConf-doSave"
    # saving rplot choices to QSetting
    if self.index["Rdevice"]:
      # width
      width = str(self.txtRwidth.text())
      (value, errorText) = wl.readIntTxtBox(width, mode="decimal", \
            widgetName="the value of width of plotting window (inches)")
      if value == "error":
        QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", errorText)
        return
      self.valueR["width"] = value
      # height
      height = str(self.txtRheight.text())
      (value, errorText) = wl.readIntTxtBox(height, mode="decimal", \
            widgetName="the value of height of plotting window (inches)")
      if value == "error":
        QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", errorText)
        return
      self.valueR["height"] = value
      # xpos
      xpos = str(self.txtRxpos.text())
      (value, errorText) = wl.readIntTxtBox(xpos, mode="integer", \
            allowZero="True", allowNegative="True", \
            widgetName="the value of X position of window (pixels)")
      if value == "error":
        QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", errorText)
        return
      self.valueR["xpos"] = value
      # ypos
      ypos = str(self.txtRypos.text())
      (value, errorText) = wl.readIntTxtBox(ypos, mode="integer", \
            allowZero="True", allowNegative="True", \
            widgetName="the value of Y position of window (pixels)")
      if value == "error":
        QtGui.QMessageBox.information(self.iface.mainWindow(),
            "SDA4PP Plugin Error", errorText)
        return
      self.valueR["ypos"] = value
      # point size
      self.valueR["pointsize"] = int(str(self.spRpointsize.value()))
      # saving device choices to QSettings
      wl.wl("valueR: " +str(self.valueR),dt)
      wl.manageConfFile(mode="writeIndex", index=self.valueR, tool="rplot")
    # saving graphics choices to QSetting
    wl.wl("index: " +str(self.index),dt)
    wl.manageConfFile(mode="writeIndex", index=self.index, tool="graphics")
    self.close()

  def doLoadDefaultValues(self):
    dt = "menuGraphicsConf-doLoadDefaultValues"
    # default index for png device
    self.index = {"units":"px", "width":600.00, "height":600.00,
                  "res":72, "folderPath":"", "overwrite":False,
                  "folder":True, "Rdevice":True, "PNGdevice":False}
    # init png widgets wrt default index
    self.cmbUnits.setCurrentIndex(0)
    self.dSpinBoxWidth.setValue(self.index["width"])
    self.dSpinBoxHeight.setValue(self.index["height"])
    self.spinBoxRes.setValue(self.index["res"])
    self.txtNewFolder.setText("")
    # check default widget
    self.chkRdevice.setChecked(self.index["Rdevice"])
    self.chkPNGdevice.setChecked(self.index["PNGdevice"])
    self.radioBtnKeep.setChecked(True)
    self.radioBtnOverwrite.setChecked(False)
    self.radioBtnPluginFolder.setChecked(True)
    self.radioBtnNewFolder.setChecked(False)
    # enable default widget
    self.rbRdefault.setEnabled(True)
    self.rbRcustom.setEnabled(True)
    self.btnSave.setEnabled(True)
    self.radioBtnKeep.setEnabled(False)
    self.radioBtnOverwrite.setEnabled(False)
    self.radioBtnPluginFolder.setEnabled(False)
    self.radioBtnNewFolder.setEnabled(False)
    self.txtNewFolder.setEnabled(False)
    self.cmbUnits.setEnabled(False)
    self.dSpinBoxWidth.setEnabled(False)
    self.dSpinBoxHeight.setEnabled(False)
    self.spinBoxRes.setEnabled(False)
    # default index for r device
    if os.name == "nt":
      self.valueR = {"default":True, "width":5.00, "height":5.00, "xpos":0,
                     "ypos":0, "pointsize":9}
      self.setRwidgetValues(self.valueR)
      self.rWidgetStatus(useDeviceValue="default", noChangeInRb=False)
    else:
      self.valueR = {"default":False, "width":5.00, "height":5.00, "xpos":0,
                     "ypos":0, "pointsize":7}
      self.setRwidgetValues(self.valueR)
      self.rWidgetStatus(useDeviceValue="custom", noChangeInRb=False)
    # saving device choices to QSettings
    wl.wl("valueR: " +str(self.valueR),dt)
    wl.manageConfFile(mode="writeIndex", index=self.valueR, tool="rplot")
    # saving graphics choices to QSetting
    wl.wl("index: " +str(self.index),dt)
    wl.manageConfFile(mode="writeIndex", index=self.index, tool="graphics")
    self.close()

  def setRwidgetValues(self, valueR):
    # init r custom device widgets wrt index value
    self.rbRdefault.setChecked(valueR["default"])
    self.rbRcustom.setChecked(valueR["default"])
    self.txtRwidth.setText(str(valueR["width"]))
    self.txtRheight.setText(str(valueR["height"]))
    self.txtRxpos.setText(str(valueR["xpos"]))
    self.txtRypos.setText(str(valueR["ypos"]))
    self.spRpointsize.setValue(valueR["pointsize"])
