# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
from PyQt4 import QtCore
from PyQt4 import QtGui
from qgis.core import *
# import the code for the dialog
from ui_menuAbout import Ui_menuAboutDialog
# import plugin version
import __init__

class MenuAbout(QtGui.QDialog, Ui_menuAboutDialog):
  def __init__(self, iface):
    QtGui.QDialog.__init__(self)
    # save reference to the QGIS interface
    self.iface = iface
    # Set up the user interface from Designer.
    self.setupUi(self)
    self.setFixedSize(self.size())
    # get version
    self.lblVersion.setText("Version: " + __init__.version())
    # event part
    QtCore.QObject.connect(self.lblSDAhome,
            QtCore.SIGNAL("linkActivated(QString )"), self.openSDA)
    QtCore.QObject.connect(self.lblDepen,
            QtCore.SIGNAL("linkActivated(QString )"), self.openDepen)
    QtCore.QObject.connect(self.lblSDhome,
            QtCore.SIGNAL("linkActivated(QString )"), self.openSD)
    QtCore.QObject.connect(self.lblGGIThome,
            QtCore.SIGNAL("linkActivated(QString )"), self.openGGIT)
    QtCore.QObject.connect(self.lblMETUhome,
            QtCore.SIGNAL("linkActivated(QString )"), self.openMETU)
    QtCore.QObject.connect(self.lblVKmail,
            QtCore.SIGNAL("linkActivated(QString )"), self.openVKmail)
    QtCore.QObject.connect(self.lblSDmail,
            QtCore.SIGNAL("linkActivated(QString )"), self.openSDmail)

  def openSDA(self):
    QtGui.QDesktopServices.openUrl(\
        QtCore.QUrl("http://ggit.metu.edu.tr/~volkan/index.html"))

  def openDepen(self):
    QtGui.QDesktopServices.openUrl(\
        QtCore.QUrl(\
        "http://ggit.metu.edu.tr/~volkan/development_environment.html"))

  def openSD(self):
    QtGui.QDesktopServices.openUrl(\
        QtCore.QUrl(\
        "http://www.ggit.metu.edu.tr/index.php" + \
        "?option=com_content&task=view&id=8&Itemid=9"))

  def openGGIT(self):
    QtGui.QDesktopServices.openUrl(\
        QtCore.QUrl("http://www.ggit.metu.edu.tr"))

  def openMETU(self):
    QtGui.QDesktopServices.openUrl(\
        QtCore.QUrl("http://www.metu.edu.tr"))

  def openVKmail(self):
    QtGui.QDesktopServices.openUrl(\
        QtCore.QUrl("mailto:vkepoglu@gmail.com?subject=SDA4PP Plug-in"))

  def openSDmail(self):
    QtGui.QDesktopServices.openUrl(\
        QtCore.QUrl("mailto:duzgun@metu.edu.tr?subject=SDA4PP Plug-in"))
