# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
# R options
import sda4ppRoptions
# write to logFile.log
import wl

def doSpatialAnalysis (r,index):
  dt="histogramRpart-doSpatialAnalysis"
  wl.wl("index: " +str(index),dt)
  r("v_df <- v_spdf@data")
  r("v_num <- v_df[,\"" + str(index["fieldName"]) + "\"]")
  rCode = "hist(v_num"
  if str(index["breaks"]) != "":
    rCode += ", breaks=c(" + str(index["breaks"]) + ")"
  if str(index["column"]) != "":
    rCode += ", col=\"" + str(index["column"]) + "\""
  if str(index["border"]) != "":
    rCode += ", border=\"" + str(index["border"]) + "\""	
  if str(index["main"]) != "":
    rCode += ", main=\"" + str(index["main"]) + "\""
  if str(index["xlab"]) != "":
    rCode += ", xlab=\"" + str(index["xlab"]) + "\""	
  if index["labels"]:
    rCode += ", labels=" + str(index["labels"])
  rCode = [rCode + ")"]
  wl.wl("rCode: " +str(rCode),dt)	
  sda4ppRoptions.plotGraphics(r,rCode)

