# -*- coding: utf-8 -*-
"""
/**************************************************************************
        SDATool - A QGIS plugin to do spatial data analysis 
                                using R Statistical package
                             -------------------
    begin                : 2008-01-15
    copyright            : (C) 2008 by Volkan Kepoglu
    email                : vkepoglu at gmail.com
 *************************************************************************/
/**************************************************************************
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2 of the License, or    *
 *   (at your option) any later version.                                  *
 *************************************************************************/
"""
# write to logFile.log
import wl
import time, threading
import tempfile, os, webbrowser
try:
  import rpy2.rinterface as rinterface
except:
  pass
# R options
import sda4ppRoptions

def doSpatialAnalysis (r, index):
  dt = "envelopeRpart-doSpatialAnalysis"
  r("toSP4nokta <- as(v_spdf,\"SpatialPoints\")")
  r("pointUnit <- elide(toSP4nokta, scale=TRUE, unitsq=TRUE)")
  r("envPoint <- envelope(as(pointUnit,\"ppp\"), fun=" + str(index["testFun"]) + \
    ", nsim=" + str(index["nSim"]) + ")")
  r("envLow <- envPoint$lo")
  r("envHigh <- envPoint$hi")
  # reads values from settings
  index = wl.manageConfFile(mode="read", index="", tool="graphics")
  # folder
  if index["folder"]:
    tempDir = tempfile.gettempdir()
    graphFolder = os.path.join(tempDir,"SDA4PP")
  else:
    graphFolder = os.path.join(index["folderPath"],"SDA4PP")
  if not(os.path.exists(graphFolder)):
    os.mkdir(graphFolder)
  # overwrite
  if index["overwrite"]:
    graphFileName = "plot.png"
  else:
    notFileExist = 0
    counter = 0
    while (notFileExist == 0):
      plotName = "plot_" + str(counter) + ".png"
      outputFilename = os.path.join(graphFolder, plotName)
      if not(os.path.exists(outputFilename)):
        graphFileName = "plot_" + str(counter) + ".png"
        notFileExist = 1
      else:
        counter = counter + 1
  # graphic path
  index["gPath"] = os.path.join(graphFolder, graphFileName)
  index["gPath"] = index["gPath"].replace("\\","/")
  # check min of graphic size
  if index["units"] == "px" and float(index["width"]) < 20.0:
    index["width"] = 20.0
    wl("width of pixels of plotting area could not be smaller than 20",dt)
  elif index["units"] == "px" and float(index["height"]) < 20.0:
    index["height"] = 20.0
    wl("height of pixels of plotting area could not be smaller than 20",dt)
  r.library("lattice")
  # save plot as png file
  if index["PNGdevice"]:
    r("png(filename=\"" + str(index["gPath"]) + "\",width=" + str(index["width"]) + \
        ",height=" + str(index["height"]) + ",units=\"" + str(index["units"]) + \
        "\",res=" + str(index["res"]) + ")")
    rInput = "xyplot(obs ~ theo, data=envPoint, type=\"l\", " + \
             "panel=function(x, y) { lpolygon(c(x, rev(x)), " + \
             "c(envLow, rev(envHigh)), border=\"gray\", " + \
             "fill=\"gray\") \nllines(x, y, col=\"black\", lwd=2)}) "
    exec "output = r(''' capture.output(" + str(rInput) + ") ''')"
    r['dev.off']()
    webbrowser.open(index["gPath"])
  # use R-cran native plot device
  if index["Rdevice"]:
    sda4ppRoptions.setRdeviceSize(r)
    t = threading.Timer(0.1, r_refresh)
    t.start()
    rInput = "xyplot(obs ~ theo, data=envPoint, type=\"l\", " + \
             "panel=function(x, y) { lpolygon(c(x, rev(x)), " + \
             "c(envLow, rev(envHigh)), border=\"gray\", " + \
             "fill=\"gray\") \nllines(x, y, col=\"black\", lwd=2)}) "
    exec "output = r(''' capture.output(" + str(rInput) + ") ''')"
  return 0

def r_refresh(interval = 0.03):
  # Ctrl-C to interrupt
  while True:
    rinterface.process_revents()
    time.sleep(interval)
