var __index = {"config":{"lang":["en"],"separator":"[\\s\\-]+","pipeline":["stopWordFilter"]},"docs":[{"location":"index.html","title":"Anwendungsdokumentation SAGis XPlanung","text":"<p>SAGis XPlanung ist eine Erweiterung f\u00fcr die GIS-Software QGIS, die eine Erfassung und Visualisierung von Bauleitpl\u00e4nen nach Richtlinien des Standards XPlanung erm\u00f6glicht</p>"},{"location":"index.html#erste-schritte","title":"Erste Schritte","text":"<ul> <li> <p> Installation</p> <p>Leitfaden zur Installation und Einrichtung von SAGis XPlanung</p> <p> Installation</p> </li> <li> <p> Ersten XPlan erfassen</p> <p>Vorgehensweise zum Erstellen eines XPlanung konformen Datensatzes</p> <p> Plan erstellen</p> </li> <li> <p> Import von XPlanGML-Dokumenten</p> <p>Bestehende XPlanung konforme Datens\u00e4tze importieren</p> <p> XPlanGML-Import</p> </li> </ul>"},{"location":"index.html#weitere-funktionen","title":"Weitere Funktionen","text":"<ul> <li> <p>Planinhalte hinzuf\u00fcgen</p> <p>Erfassen von raumbezogenen Festsetzungen in einem Plan</p> </li> <li> <p>Geometriepr\u00fcfung</p> <p>Validieren der Anforderungen an erfasste Geometrien im Standard XPlanung</p> </li> <li> <p>Export von XPlanGML-Dokumenten</p> <p>Erstellen von XPlanGML-Dateien aus erfassten XPlan-Datens\u00e4tzen</p> </li> <li> <p>Planinhalte bearbeiten</p> <p>Anpassen von Geometrie und Sachdaten bestehender Planinhalte</p> </li> </ul>"},{"location":"index.html#programmversionen","title":"Programmversionen","text":"<p>Die Anwendung wird in zwei verschiedenen Versionen zur Verf\u00fcgung gestellt.  Zum \u00dcberblick \u00fcber die Funktionsunterschiede dient die folgende Tabelle:</p> Community-Version Vollversion Teilvektorielle Erfassung Speichern externer Referenzen Import von XPlanGML-Dokumenten Visualisierung gem\u00e4\u00df PlanZV Export von XPlanGML-Dokumenten <sup>1</sup> Bearbeiten von XPlanung-Attributen <sup>1</sup> Erfassung neuer Planinhalte (vollvektorielle Erfassung) Benutzerdefinierte Symbolisierung Tabellen-Import (Excel) <p>Die Community-Version ist unter einer Open-Source Lizenz im Plugin-Verzeichnis vom QGIS zum  Download verf\u00fcgbar.</p> <ol> <li> <p>Nur f\u00fcr Basisobjekte m\u00f6glich (teilvektorielle Erfassung)\u00a0\u21a9\u21a9</p> </li> </ol>"},{"location":"add-plancontent.html","title":"Konfiguration von Planinhalten","text":"<p>Nach dem Erfassen eines Planwerks, k\u00f6nnen sowohl vektorielle Planinhalte  zugeordnet werden als auch Planinhalte, die keine Geometrien enthalten \u2013  die sogenannten Datenobjekte.</p>"},{"location":"add-plancontent.html#planinhalte-mit-raumbezug-hinzufugen","title":"Planinhalte mit Raumbezug hinzuf\u00fcgen","text":"Vollversion <p>Voraussetzung zum Hinzuf\u00fcgen vektorieller Planinhalte ist, dass ein Layer  mit Objekten im QGIS geladen ist, der Geometrien f\u00fcr die neuen Planinhalte enth\u00e4lt. Dies kann ein Layer aus beliebiger Datenquelle oder auch ein Tempor\u00e4rlayer sein.</p> <p>Info</p> <p>Um vektorielle Planinhalte einem Planwerk zuordnen zu k\u00f6nnen, muss bei der Erfassung eines Planwerks mindestens ein Bereich angelegt werden.  Ein Bereich dient zur logischen Gruppierung von Planinhalten. Bereiche nachtr\u00e4glich hinzuf\u00fcgen, ist \u00fcber die Funktion Datenobjekte hinzuf\u00fcgen m\u00f6glich.</p> <ol> <li>Das Werkzeug Planinhalte konfigurieren / abfragen aus der XPlanung-Werkzeugleiste w\u00e4hlen. Alt+Q</li> <li> <p>Mit der rechten Maustaste ein Objekt auf der Karte w\u00e4hlen, das als neuer Planinhalt konfigurieren werden soll.    Im Kontextmen\u00fc die Option Als Planinhalt konfigurieren w\u00e4hlen.</p> <p> </p> </li> <li> <p>Im folgenden Dialog findet die Zuordnung der gew\u00e4hlten Geometrien zu einem Planwerk statt. Dabei wird eine Objektart     aus dem XPlanung-Objektkatalog zugewiesen. Es bestehen folgende Optionen zum Konfigurieren eines neuen Planinhalts:</p> <p> Zuordnung zu einem Plan Auswahl eines Planwerks aus der Datenbank, zu dem die neu konfigurierten Planinhalte zugeordnet werden              sollen.           Gew\u00e4hlte Geometrien Diese Sektion erlaubt es, weitere Geometrien auf der Karte anzuw\u00e4hlen, die ebenfalls als gleiche             Objektart mit gleichen Sachdaten erfasst werden soll. Die Auswahl der Geometrien kann \u00fcber die             folgenden Optionen stattfinden:            <ul> <li>Auswahl von Einzelobjekten durch Klick in die Karte</li> <li>Checkbox Alle Ausw\u00e4hlen: Alle Objekte des gew\u00e4hlten Layers werden zur Auswahl hinzugef\u00fcgt</li> <li>QGIS Abfrageeditor: Ausw\u00e4hlen von Objekten nach bestimmten Filter-Abfragen \u00fcber QGIS-Ausdr\u00fccke</li> </ul> XPlanung-Objektart w\u00e4hlen Auswahl einer Objektart aus dem XPlanung-Schema, die den gew\u00e4hlten Geometrien zugeordnet werden.             Die verf\u00fcgbaren Objekte sind abgestimmt auf den Geometrietyp (Punkt, Linie, Polygon) des gew\u00e4hlten             Layers und die Art des bei Sektion Zuordnung zu einem Plan gew\u00e4hlten Planwerks.               Mit dem Auswahlmen\u00fc neben dem Suchfeld, kann die Liste der Objektklassen mit weiteren Objekten aus             anderen XPlan-Fachbereichen erweitert werden.          </p> <p>Info</p> <p>Die Option Alle Ausw\u00e4hlen funktioniert nur bei Layern mit weniger als 1000 Objekten. F\u00fcr gr\u00f6\u00dfere Layer muss zun\u00e4chst ein Ausschnitt erstellt werden (Objekte mit QGIS Werkzeugen w\u00e4hlen,  dann mit Funktion gew\u00e4hlte Objekte exportieren neu speichern)</p> <p>Geometrievalidierung</p> <p>Bei der Auswahl von Geometrien findet eine Pr\u00fcfung auf G\u00fcltigkeit und Lage innerhalb des gew\u00e4hlten Bereichs statt. Sobald eine Geometrie mit einer Warnung versehen ist, wird diese bei einer Geometriepr\u00fcfung einen Fehler hervorrufen. Siehe Geometriepr\u00fcfung f\u00fcr Anforderungen an geometrische Korrektheit.</p> <p> </p> </li> <li> <p>Mit dem Button Weiter in das Sachdaten-Formular der gew\u00e4hlten Objektart wechseln</p> </li> <li>Nach Eingabe der Sachdaten f\u00fcr die neu zu erstellenden Objekte, mit dem Button Speichern     den Dialog best\u00e4tigen</li> </ol> <p>Nach Best\u00e4tigen des Dialogs werden die neuen Objekte in der Datenbank angelegt und mit dem gew\u00e4hlten Plan verkn\u00fcpft. Neue Objekte erscheinen im Anschluss im Objektbaum.</p>"},{"location":"add-plancontent.html#datenobjekte-hinzufugen","title":"Datenobjekte hinzuf\u00fcgen","text":"<p>Datenobjekte sind Objektarten, die zus\u00e4tzliche Sachdaten enthalten. Sie sind besitzen grunds\u00e4tzliche keinen Raumbezug (Geometrie).</p> <p>Warning</p> <p>Ausnahme: Bereiche hinzuf\u00fcgen! Bereiche sind keine Datenobjekte, werden aber \u00fcber die gleiche Funktion erstellt.</p> <ol> <li>Planwerk w\u00e4hlen und Planwerk Details aufrufen</li> <li> <p>Im Objektbaum mit der rechten Maustaste das Kontextmen\u00fc eines Objekts \u00f6ffnen und im Kontextmen\u00fc die Option      Neues Datenobjekt hinzuf\u00fcgen w\u00e4hlen:      </p> </li> <li> <p>Im folgenden Dialog k\u00f6nnen die Sachdaten f\u00fcr eine gew\u00e4hlte Objektart eingetragen werden</p> </li> <li>Mit dem Button Speichern das Erfassen eines neuen Datenobjekt best\u00e4tigen</li> </ol>"},{"location":"map-display.html","title":"Kartenanzeige","text":"<p>SAGis XPlanung enth\u00e4lt eine Sammlung an Standard-Darstellungsvorschriften zur Visualisierung von Planwerken nach  den Vorlagen der Planzeichenverordnung. Eine Anpassung der individuellen Stile ist in den Einstellungen m\u00f6glich.</p> <p>Tip</p> <p>Die Darstellungskonfiguration aus den Einstellungen wird auf alle Planwerke bei der  Kartenanzeige angewendet. F\u00fcr die Anpassung der Darstellung einzelner Planwerke, k\u00f6nnen die \u00fcblichen QGIS-Darstellungseigenschaften projektbasiert verwendet werden. </p>"},{"location":"map-display.html#prasentationsobjekte","title":"Pr\u00e4sentationsobjekte","text":"<p>Zur Erweiterung der Darstellungsinformationen realisiert der Standard XPlanung das Konzept der Pr\u00e4sentationsobjekte. Diese unterst\u00fctzen oder \u00e4ndern die Standard-Darstellung von Planinhalten, haben jedoch selbst keine fachliche Bedeutung. Pr\u00e4sentationobjekte k\u00f6nnen graphische Annotationen, wie textliche Beschriftungen oder zus\u00e4tzliche Symbole repr\u00e4sentieren.</p>"},{"location":"map-display.html#allgemein","title":"Allgemein","text":"<p>In XPlanung werden Pr\u00e4sentationsobjekte f\u00fcr die grafische Darstellung im Plan verwendet, ohne selbst inhaltliche  Planwerte zu repr\u00e4sentieren. Man unterscheidet freie und gebundene Pr\u00e4sentationsobjekte. </p> <ul> <li>Freie Pr\u00e4sentationsobjekte haben keinen Bezug zu einem Fachobjekt (z.B. ein blo\u00dfer Annotations-Text) und dienen nur  der grafischen Beschriftung</li> <li>Gebundene Pr\u00e4sentationsobjekte sind \u00fcber die Relation <code>&lt;xplan:dientZurDarstellungVon&gt;</code> mit genau einem  Fachobjekt verkn\u00fcpft und zeigen Attributwerte dieses Fachobjekts im Plan an</li> </ul> <p>Bei gebundenen Pr\u00e4sentationsobjekten bestimmt das Attribut <code>&lt;xplan:art&gt;</code> den angezeigten Inhalt.  In diesem Feld wird ein XPath-Ausdruck eingetragen, der auf ein oder mehrere Attribute des zugeh\u00f6rigen Fachobjekts referenziert.  Der Ausdruck ist relativ zum Fachobjekt und verwendet in der Regel den Namensraum-Pr\u00e4fix <code>&lt;xplan:&gt;</code> vor jedem Elementnamen. Praktisch wird also durch die Angabe <code>&lt;xplan:art&gt;xplan:text&lt;/xplan:art&gt;</code> angeben, den Inhalt des Attributs text zu visualisieren.</p> <p>Beispiel 1: Darstellung von Einzelattributen </p> <p><pre><code>BP_Plan\n\u251c\u2500\u2500 BP_BaugebietsTeilFlaeche\n\u2502   \u251c\u2500\u2500 allgArtDerBaulNutzung: WohnBauflaeche\n\u2502   \u251c\u2500\u2500 besondereArtDerBaulNutzung: ReinesWohngebiet\n\u2502   \u2514\u2500\u2500 XP_PPO\n\u2502       \u251c\u2500\u2500 art: xplan:allgArtDerBaulNutzung\n\u2502       \u2514\u2500\u2500 art: xplan:besondereArtDerBaulNutzung\n\u2514\u2500\u2500 BP_GruenFlaeche\n    \u251c\u2500\u2500 zweckbestimmung: Kleingarten\n    \u2514\u2500\u2500 XP_PPO\n        \u2514\u2500\u2500 art: xplan:zweckbestimmung\n</code></pre> Bedeutung: Darstellung zweier punktf\u00f6rmiger Pr\u00e4sentationsobjekte:</p> <ul> <li>Visualisierung der Inhalte aus Attributen allgArtDerBaulNutzung und besondereArtDerBaulNutzung auf einem Objekt <code>BP_BaugebietsTeilFlaeche</code></li> </ul> <ul> <li>Visualisierung der Inhalte aus Attribut zweckbestimmung auf einem Objekt <code>BP_GruenFlaeche</code></li> </ul> <p>Beispiel 2: Darstellung von Attributen mit Mehrfachauswahl</p> <p><pre><code>FP_Plan\n\u2514\u2500\u2500 FP_Gemeinbedarf\n    \u251c\u2500\u2500 zweckbestimmung: Sport, Schule\n    \u251c\u2500\u2500 XP_PPO\n    \u2502   \u2514\u2500\u2500 art: xplan:zweckbestimmung[1]\n    \u2514\u2500\u2500 XP_PPO\n        \u2514\u2500\u2500 art: xplan:zweckbestimmung[2]\n</code></pre> Bedeutung: Darstellung von zwei punktf\u00f6rmigen Pr\u00e4sentationsobjekten auf einem einzelnen Fachobjekt aus der Mehrfachauswahl im Attribut zweckbestimmung</p> <p>Index bei Mehrfachauswahl</p> <p>Der Index im XPath-Ausdruck gibt an, welcher Wert bei Attributen mit Mehrfachauswahl visualisiert werden soll. In Version 5.x muss der Index auch im Attribut index eingetragen werden. Hier muss weiterhin eine 0-basierte Z\u00e4hlweise verwendet werden, sodass der Index 0 auf den ersten Wert verweist, der Index 1 auf den zweiten Wert, usw.</p>"},{"location":"map-display.html#neues-prasentationsobjekt-anlegen","title":"Neues Pr\u00e4sentationsobjekt anlegen","text":"<ol> <li>Das Werkzeug Planinhalte konfigurieren / abfragen aus der XPlanung-Werkzeugleiste w\u00e4hlen. Alt+Q</li> <li>Auf das XPlan-Objekt in der Karte klicken, zu dem das Pr\u00e4sentationsobjekt hinzugef\u00fcgt werden soll</li> <li> <p>Im Kontextmen\u00fc das entsprechende Objekt finden und die Option Pr\u00e4sentationsobjekt hinzuf\u00fcgen w\u00e4hlen</p> <p> </p> </li> <li> <p>Im Dialog die Art des Pr\u00e4sentationsobjekts ausw\u00e4hlen, die Position/Platzierung definieren und den Inhalt des     neuen Pr\u00e4sentationsobjekts konfigurieren</p> <p> </p> </li> </ol> Art des Pr\u00e4sentationsobjekts <ul> <li> Symbol: <code>XP_PPO</code>, Objektklasse f\u00fcr punktf\u00f6rmige Symbole             </li> <li> Text: <code>XP_PTO</code>, Objektklasse f\u00fcr Schriftinhalte             </li> <li> Nutzungsschablone: <code>XP_Nutzungsschablone</code>, Objektklasse f\u00fcr Baunutzungsschablonen.                 (Objektklasse kann nur als Pr\u00e4sentationsobjekt f\u00fcr die Darstellung eines Objekts vom Typ                 <code>BP_BaugebietsTeilFlaeche</code> verwendet werden)             </li> </ul> Position           Das Pr\u00e4sentationsobjekt wird standardm\u00e4\u00dfig an der Position des Mauscursors bei Aufruf des Dialogs platziert.          Alternativ kann die Position ver\u00e4ndert werden:          <ul> <li> Auf Mittelpunkt setzen: Position wird auf den Mittelpunkt des Objekts festgelegt. Die Platzierung erfolgt dabei immer innerhalb der Grenzen des Objekts.             </li> <li> Auf Karte w\u00e4hlen: Nach Auswahl des Werkzeugs kann auf der Karte eine neue Position festgelegt werden             </li> </ul> Inhalt/Darstellung           Der Inhalt des Pr\u00e4sentationsobjekts wird \u00fcber die Konfiguration eines XPath-Ausdrucks definiert. Damit das           Pr\u00e4sentationsobjekt auf der Karte dargestellt werden kann muss mindesteins ein XPath hinterlegt sein."},{"location":"map-display.html#nutzungschablone","title":"Nutzungschablone","text":"<p>Ein typisches Pr\u00e4sentationsobjekt ist die Nutzungschablone.  Die Tabellenform der Nutzungschablone gibt einen  einfachen \u00dcberblick auf die wichtigsten Festsetzungen einer Baufl\u00e4che.  Die Nutzungsschablone kann f\u00fcr alle Baufl\u00e4chen innerhalb eines Bebauungsplans angelegt werden  (Objektklasse <code>BP_BaugebietsTeilFlaeche</code>). Die angezeigten Daten der Tabelle werden aus den Sachdaten des referenzierten XPlan-Fachobjekts verwendet.</p> Nutzungsschablone anlegen <ul> <li>             Siehe Neues Pr\u00e4sentationsobjekt anlegen: Art des Pr\u00e4sentationsobjekt             als Nutzungsschablone festlegen.         </li> Nutzungsschablone anpassen <ul> <li>             \u00dcber den Objektbaum die Attribut-Ansicht eines Objekts vom Typ <code>XP_Nutzungsschablone</code> aufrufen.         </li> </ul>     Im Sachdatendialog besteht die M\u00f6glichkeit die Form und Inhalte der Nutzungschablone anzupassen:      Form Anpassen der Tabellenform. Auswahl aus den drei vorgegebenen Formen. Zellwerte Bestimmt die Inhalte der Nutzungschablone. Jede Auswahlliste bestimmt den Inhalt einer Zelle in der                 Tabelle. Es kann aus den folgenden Optionen gew\u00e4hlt werden:                 <ul> <li>Art d. baulichen Nutzung (Punkt 1 PlanZV)</li> <li>Anzahl der Vollgeschosse (Punkt 2.7 PlanZV)</li> <li>Grundfl\u00e4chenzahl (Punkt 2.5 PlanZV)</li> <li>Geschossfl\u00e4chenzahl (Punkt 2.1 PlanZV)</li> <li>Art der Bebbaung (Punkt 3.1.1-3.1.4 PlanZV)</li> <li>Bauweise (Punkt 3.1-3.3 PlanZV)</li> <li>Dachneigung: Angabe aus zugeordnetem Objekt vom Typ <code>BP_Dachgestaltung</code></li> <li>Dachform: Angabe aus zugeordnetem Objekt vom Typ <code>BP_Dachgestaltung</code></li> <li>H\u00f6he baulicher Anlagen (Punkt 2.8 PlanZV): Angabe aus zugeordnetem Objekt vom Typ <code>XP_Hoehenangabe</code></li> <li>Baumasse / Baumassenzahl (Punkt 2.3-2.4 PlanZV)</li> <li>Grundfl\u00e4che / Geschossfl\u00e4che (Punkt 2.2+2.6 PlanZV)</li> </ul>"},{"location":"multi-edit.html","title":"Mehrfachbearbeitung","text":"<p>Die Mehrfachbearbeitung ist eine Funktion zum Bearbeiten mehrerer Planinhalte eines erfassten Plans von der gleichen XPlan-Objektart. </p> <ol> <li>Plan auf Karte anzeigen</li> <li> <p>Mit den QGIS-Auswahlwerkzeugen eine beliebige Auswahl auf der Karte treffen (bspw. \u00fcber Einzelklick w\u00e4hlen oder    Objekte nach Wert w\u00e4hlen)      </p> </li> <li> <p>Das Werkzeug Planinhalte konfigurieren / abfragen aus der XPlanung-Werkzeugleiste w\u00e4hlen. Alt+Q</p> </li> <li>Ein beliebiges Objekt in der aktuellen Auswahl auf der Karte mit Rechtsklick w\u00e4hlen und im Kontextmen\u00fc die    Option Gew\u00e4hlte Objekte bearbeiten aufrufen      </li> <li>In der Attributauswahl alle Attribute ausw\u00e4hlen, die angepasst werden sollen</li> <li>Im Abschnitt \u00c4nderungen die neuen Attributwerte eintragen</li> <li>Mit Button \u00c4nderungen speichern werden die neuen Attributwerte den gew\u00e4hlten Objekten zugewiesen      </li> </ol> <p>Tip</p> <p>Alternativ kann die Mehrfachbearbeitung auch \u00fcber den Objektbaum  aufgerufen werden. Nach Auswahl mehrerer Eintr\u00e4ge gleicher Objektart im Kontextmen\u00fc die Option  Gew\u00e4hlte Objekte bearbeiten aufrufen:  </p>"},{"location":"new-plan.html","title":"Neuen Plan erfassen","text":"<p>Voraussetzung f\u00fcr die Erfassung eines neuen Planwerks ist ein Vektorlayer  vom Geometrietyp (Multi)Polygon, der den Geltungsbereich des zu erfassenden  Plans beschreibt. Sollte der Plan nur teilvektoriell erfasst werden, wird  zus\u00e4tzlich ein georeferenziertes Rasterbild der Planzeichnung ben\u00f6tigt.</p> <ol> <li> <p>Im Hauptdialog der Anwendung im Abschnitt Neuen Plan erfassen die entsprechende Art des zu erfassenden Plans    ausw\u00e4hlen</p> </li> <li> <p>Mit dem Button Planwerk erfassen \u00f6ffnet sich ein Sachdatendialog zur Konfiguration der Sachdaten f\u00fcr den zu     erstellenden Plan</p> <p> </p> </li> <li> <p>Im Formular alle ben\u00f6tigten Attribute mit Daten f\u00fcllen. Dabei sind die folgenden Angaben als Pflichtattribute     zwingend auszuf\u00fcllen:</p> </li> </ol> planArt Art des Planwerks Gemeinde Datenobjekt vom Typ <code>XP_Gemeinde</code>. Entweder bestehendes Objekt im Dropdown w\u00e4hlen oder              \u00fcber das Plus-Symbol ein neues Objekt anlegen.             Ben\u00f6tigte Daten: <ul> <li> Gemeindeschl\u00fcssel (12-stellig) oder Regionalschl\u00fcssel</li> <li> Name der Gemeinde </li> </ul> name Beliebiger Bezeichner f\u00fcr den Plan Geltungsbereich Auswahlm\u00f6glichkeit f\u00fcr die Vektorgeometrie des Geltungsbereich. Nach Auswahl des Layers bestehen zwei Optionen:             <ul> <li>Kartenabfrage: \u00dcber die Schaltfl\u00e4che mit dem Cursor-Symbol aktiviert sich ein QGIS-Kartenwerkzeug, mit dem der Geltungsbereich auf der Karte gew\u00e4hlt werden kann (Linke Maustaste zum Ausw\u00e4hlen eines Features auf der Karte; rechte Maustaste zum Deaktivieren des Werkzeugs)</li> <li>Auswahl \u00fcber ID: Anstatt der Nutzung des Werkzeugs, kann auch direkt in der unteren Auswahlliste das Feature gew\u00e4hlt werden, wenn die Nummer des Features bekannt ist.</li> </ul> <p>Geometrie des Geltungsbereich</p> <p>Die Geomtrie des Geltungsbereichs muss zwingend vom Typ (Multi-) Polygon sein.   Es wird keine Umring-Geometrie (Linie) akzeptiert.</p> <p>Weitere Schritte:</p> <ul> <li>Planwerk-Details abfragen</li> <li>Vektorielle Planinhalte hinzuf\u00fcgen</li> </ul>"},{"location":"plan-export.html","title":"XPlanGML Export","text":"<p>SAGis XPlanung erm\u00f6glicht den Export aller erfassten Planwerke in das Austauschformat XPlanGML.  Die Anwendung erzeugt dabei XPlanGML-Dateien in der Version 5.3 oder 6.0  (Anpassung der Version in den Einstellungen m\u00f6glich).</p> <ol> <li>Planwerk im Dropdown-Men\u00fc im untersten Abschnitt des Hauptdialogs ausw\u00e4hlen     </li> <li>Ausgabeformat \u00fcber die Auswahl der zwei Optionsfelder festgelegen:      XPlanGML Beim Export mit der Option XPlanGML wird ausschlie\u00dflich die XPlanGML-Datei ausgegeben ZIP-Archiv Bei der Auswahl der Option ZIP-Archiv wird ein komprimierter Ordner samt XPlanGML und allen                  verkn\u00fcpften Referenzen ausgegeben              </li> <li>Mit dem Button Export startet der Export</li> </ol> <p>Info</p> <p>Abh\u00e4ngig von der Gr\u00f6\u00dfe des Planwerks kann dieser Prozess einige Zeit in Anspruch nehmen.  Nach Beendigung wird der Erfolg des Exports in der Statusleiste best\u00e4tigt.</p>"},{"location":"plan-import.html","title":"XPlanGML Import","text":"<p>Neben dem Export von Planwerken erlaubt SAGis XPlanung den Import von bestehenden Planwerken  im XPlanGML-Format, um ein Planwerk, das bereits XPlanung konform vorliegt, im QGIS zu visualisieren und zu bearbeiten. </p> <p>Info</p> <p>Ein fehlerfreier Import funktioniert nur f\u00fcr unterst\u00fctzte XPlanGML-Versionen. Andere Versionen des Austauschformats funktionieren m\u00f6glicherweise abh\u00e4ngig von der Belegung der Attribute auch,  jedoch k\u00f6nnen dann einzelne Informationen beim Import verloren gehen.</p> <ol> <li> <p>Zum Import im Abschnitt des Hauptdialogs XPlanGML Import die Schaltfl\u00e4che mit den drei Punkten w\u00e4hlen.</p> <p></p> </li> <li> <p>Im Dialog den Speicherort der XPlanGML-Datei suchen, anschlie\u00dfend mit Button \u00d6ffnen best\u00e4tigen</p> </li> <li>Im letzten Schritt die ausgew\u00e4hlte Datei, die im Eingabefeld Pfad erscheint, mit einem Klick auf      Import in die Datenbank \u00fcberf\u00fchren</li> </ol> <p>Info</p> <p>Abh\u00e4ngig von der Gr\u00f6\u00dfe des Planwerks kann dieser Prozess einige Zeit in Anspruch nehmen.  Der Import-Fortschritt wird im Dialog angezeigt. Mit dem Abbruch-Icon kann der Import-Prozess vorzeitig abgebrochen  werden.</p>"},{"location":"elements/main-dialog.html","title":"Hauptdialog","text":"<p>Der Hauptdialog ist der zentrale Einstiegspunkt der Anwendung. Das Fenster bietet Zugriff auf die meistgenutzten Funktionen des SAGis XPlanung und ist untergliedert in die folgenden vier Sektionen:</p> Werkzeuge Zugriff auf das XPlanung-Werkzeug zum Zuweisen neuer Planinhalte und              zur Abfrage von XPlan-Daten auf der Karte Neuen Plan erfassen Funktion zum Erstellen eines neuen XPlan XPlanGML Import Funktion zum Import bestehender XPlanGML-Dokumente in die Datenbank Planwerk-Auswahl Funktion zur Auswahl eines erfassten Planwerks aus der Datenbank.             Der im Dropdown-Men\u00fc gew\u00e4hlte Plan wird im Arbeitsbereich des Planwerk-Detail Fenster geladen und              kann mit der Option Auswahl exportieren in ein              XPlanGML-Dokument exportiert werden"},{"location":"elements/main-dialog.html#starten-der-anwendung","title":"Starten der Anwendung","text":"<p>Beim Aufruf der Anwendung startet das SAGis XPlanung in der Anischt des Hauptdialogs.</p> <ol> <li>In der SAGis Men\u00fcleiste auf das SAGis XPlanung-Icon klicken um die Anwendung         zu starten</li> <li>Das Hauptfenster \u00f6ffnet sich standardm\u00e4\u00dfig als QGIS-Bedienfeld an der rechten Seite,      kann jedoch auch per drag-and-drop an eine andere Position verschoben werden</li> </ol> <p>Info</p> <p>Sollte das Icon nicht in der Werkzeugleiste zu finden sein, vergewissern Sie sich, dass die  SAGis Men\u00fcleiste aktiviert ist (Ansicht | Werkzeugleisten | SAGis Toolbar).  </p>"},{"location":"elements/plan-details.html","title":"Detailansicht Planwerk","text":"<p>Im Fenster Planwerk Details lassen sich verschiedenen Funktionen und Inhalte abrufen, die einen einzelnen Plan in der Datenbank betreffen. Dabei wird immer der Plan in den Arbeitsbereich geladen, der im Hauptdialog in der Liste der Planwerke ausgew\u00e4hlt wurde.</p> <p>Das Fenster Planwerk Details besteht aus den beiden Sektionen Geometriepr\u00fcfung und dem Objektbaum. Im oberen Bereich finden sich allgemeine Aktionen zum  Anzeigen, Bearbeiten und L\u00f6schen des vorliegenden Plans.</p> Detailansicht f\u00fcr ein Planwerk \u00f6ffnen <ol> <li>Gew\u00fcnschtes Planwerk aus Liste im Hauptdialog w\u00e4hlen</li> <li>Neben der Liste der Planwerke auf das Info-Symbol klicken</li> </ol>"},{"location":"elements/plan-details.html#kartenanzeige","title":"Kartenanzeige","text":"<p>Jeder in der Datenbank erfasste Datensatz kann auf der QGIS-Karte visualisiert werden. Dabei wird eine standardm\u00e4\u00dfig  konfigurierte Stilvorgabe und Layerreihenfolge des SAGis XPlanung angewendet. Eine Anpassung der individuelle Stile ist in den Einstellungen m\u00f6glich.</p> Plan auf Karte anzeigen <ul> <li>Mit dem Kartensymbol l\u00e4sst sich der aktuell gew\u00e4hlte Plan auf der QGIS-Karte anzeigen</li> </ul>"},{"location":"elements/plan-details.html#geometrieprufung","title":"Geometriepr\u00fcfung","text":"<p>Zur Erfassung eines qualitativ hochwertigen Planwerks ist topologisch korrektes Anlegen der Geometrien unerl\u00e4sslich.  XPlanung definiert hierf\u00fcr einige Qualit\u00e4tsvorgaben, die bei der Validierung einer XPlanGML-Datei gepr\u00fcft werden.  Mit der Geometriepr\u00fcfung unterst\u00fctzt SAGis XPlanung die Einhaltung der Vorgaben zur korrekten geometrischen Erfassung.</p> <p>Dies betrifft die folgenden Bedingungen:</p> <ul> <li>Geometrien sind valide nach OGC Simple Feature Access Standard</li> <li>Geometrien enthalten keine doppelten St\u00fctzpunkte</li> <li>Einhaltung des Fl\u00e4chenschlusskonzepts</li> </ul> <p>Info</p> <p>Fl\u00e4chenschluss: Bei der vollvektoriellen Erfassung muss der Zusammenschluss aller erfassten Fl\u00e4chen mit der Fl\u00e4che  des Geltungsbereichs \u00fcbereinstimmen. Es d\u00fcrfen keine \u00dcberlappungen oder L\u00fccken zwischen den Fl\u00e4chen auftreten und  keine Fl\u00e4che darf den Umring des Geltungsbereichs \u00fcbertreten.</p> Ausf\u00fchren der Geometriepr\u00fcfung <ol> <li>             Mit dem Button Geometriepr\u00fcfung starten den Prozess starten. Je nach Menge der erfassten              Fl\u00e4chenschlussobjekte kann der Prozess einige Zeit in Anspruch nehmen         </li> <li>             Sollte die Geometriepr\u00fcfung Fehler identifiziert haben, werden diese im Anschluss im Protokoll-Fenster              angezeigt. Jede Fehlermeldung, kann durch einen Doppelklick auf die Fehlernachricht auf der Karte              visualisiert werden.         </li> <li>             Zum Beheben von Geometriefehlern k\u00f6nnen die              QGIS-Bearbeitungswerkzeuge verwendet werden.         </li> </ol> Fl\u00e4chenschluss erzwingen <ul> <li>             Die Funktion Fl\u00e4chenschluss erzwingen erm\u00f6glicht es, Fl\u00e4chen, die mit keiner Festsetzung              konfiguriert sind, mit einem Objekt des Typ <code>BP_FlaecheOhneFestsetzung</code> zu f\u00fcllen. Dies ist              hilfreich, um die Fl\u00e4chenschlussbedingung zu erf\u00fcllen, wenn nicht die komplette Fl\u00e4che des Geltungsbereichs              mit vektoriell erfassten Planinhalten gef\u00fcllt werden kann.          </li> </ul>"},{"location":"elements/plan-details.html#der-objektbaum","title":"Der Objektbaum","text":"<p>Der Objektbaum spiegelt die baumartige Struktur eines XPlanGML-Dokuments wider. Jeder XPlan-Datensatz besteht zun\u00e4chst aus dem Grundobjekt <code>BP_Plan</code>/<code>FP_Plan</code>/etc. Diesem sind dann weitere Planinhalte zugeordnet. Dabei k\u00f6nnen einzelne Planinhalte wiederum anderen Inhalte zugeordnet sein, wodurch eine die Baumstruktur entsteht.</p> <p>\u00dcber den Objektbaum werden die folgenden Funktionen abgebildet:</p> <ul> <li> Filtern und Sortieren der Planinhalte</li> <li>Bearbeiten von Sachdaten</li> <li>Hinzuf\u00fcgen neuer Datenobjekte</li> <li>L\u00f6schen von einzelnen Inhalten</li> </ul>"},{"location":"elements/plan-details.html#filtern-und-sortieren","title":"Filtern und Sortieren","text":"<p>Zur Navigation im Objektbaum, k\u00f6nnen alle erfassten Objekte sortiert und gefiltert werden. Zur Sortierung stehen die drei Optionen Nach Objekthierarchie, Alphabetisch und Nach Kategorie sortieren  zur Verf\u00fcgung (in Reihenfolge von links von rechts). Die standardm\u00e4\u00dfige Sortierung Nach Objekthierarchie spiegelt  den Aufbau des XPlan-Datensatzes in der Struktur einer XPlanGML-Datei wider.</p> <p>Mit dem Lupen-Symbol \u00f6ffnet sich ein Suchfeld, das zum Filtern der angezeigten Objekte nach Namen der Objektart und  XPlanung-ID genutzt werden kann.</p>"},{"location":"elements/plan-details.html#bearbeiten-von-sachdaten","title":"Bearbeiten von Sachdaten","text":"Vollversion <p>Warning</p> <p>Bearbeiten von Attributen ist in der Community-Version nur f\u00fcr Basisobjekte m\u00f6glich.</p> <ol> <li>Doppel-Klick auf einen Eintrag Objektbaum \u00f6ffnet die Attribut-Ansicht</li> <li>Doppel-Klick in eine Zelle der Spalte Wert \u00f6ffnet einen Dialog zum Bearbeiten des gew\u00e4hlten Attributs</li> <li>Gew\u00fcnschte Anpassung am Attributwert eintragen und mit Speichern best\u00e4tigen       </li> </ol> <p>Tip</p> <p>Mit der R\u00fcckg\u00e4ngig-Funktion k\u00f6nnen letzte \u00c4nderungen an Attributen wieder gel\u00f6scht werden um den Datensatz in einen fr\u00fcheren Zustand zu versetzen.  </p> <p>Tip</p> <p>Funktion Mehrfachbearbeitung f\u00fcr \u00c4nderungen an mehreren gleichen Planinhalten.</p>"},{"location":"elements/plan-details.html#loschen-von-inhalten","title":"L\u00f6schen von Inhalten","text":"Plan l\u00f6schenPlaninhalte l\u00f6schen <ul> <li>Mit dem M\u00fclleimer-Symbol im oberen Abschnitt des Fensters wird der gesamte Plan gel\u00f6scht      </li> </ul> <ol> <li>Objekte zum L\u00f6schen im Objektbaum ausw\u00e4hlen (Ctrl zur Mehrfachauswahl oder gesamten Bereich durch Ziehen   der Maus markieren)</li> <li>Mit der rechten Masustaste das Kontextmen\u00fc aufrufen</li> <li>Mit Planinhalt L\u00f6schen werden gew\u00e4hlte Inhalte entfernt.      </li> </ol>"},{"location":"elements/plan-details.html#weitere-planinhalt-aktionen","title":"Weitere Planinhalt-Aktionen","text":"<p>Der Objektbaum bietet weitere Funktionen, die auf einzelne erfasste Planinhalte angewendet werden k\u00f6nnen. Viele der Planinhalt-Aktionen k\u00f6nnen nur auf Objekten bestimmter XPlanung-Objektklassen oder Kategorien von Planinhalten ausgef\u00fchrt werden.</p> <ol> <li>Aufruf der Planinhalt-Aktionen \u00fcber das Kontextmen\u00fc der Eintr\u00e4ge im Objektbaum (Rechtsklick)      </li> </ol> Planinhalte <ul> <li> Planinhalt l\u00f6schen: Planinhalt aus der Datenbank entfernen                 (Bei Mehrfachauswahl werden alle gew\u00e4hlten Objekte gel\u00f6scht)             </li> <li> Planinhalt auf Karte hervorheben: Wenn der Plan im Arbeitsbereich/Karte geladen                ist, wird die Geometrie auf der Karte aufleuchten             </li> <li> Datenobjekt hinzuf\u00fcgen </li>              Bei Mehrfachauswahl:              <li> Gew\u00e4hlte Objekte bearbeiten </li> </ul>"},{"location":"elements/plan-overview.html","title":"Plan\u00fcbersicht","text":"<p>Die Plan\u00fcbersicht, gibt einen \u00dcberblick auf alle in der Datenbank gespeicherten Pl\u00e4ne in tabellarischer Form. Weitere Aktionen im Dialog der Plan\u00fcbersicht:</p> <ol> <li>Suchen, Sortieren und Filtern</li> <li>Planwerk-Aktionen</li> <li>Tabellenimport</li> <li>Navigationswerkzeuge zum Wechseln zwischen den Seiten</li> </ol> Plan\u00fcbersicht \u00f6ffnen <ol> <li> Hauptdialog der Anwendung aufrufen         </li> <li>             Mit der Schaltfl\u00e4che ALLE ANZEIGEN oberhalb der Planwerk-Auswahl wird die Plan\u00fcbersicht aufgerufen         </li> </ol>"},{"location":"elements/plan-overview.html#suchen-sortieren-und-filtern","title":"Suchen, Sortieren und Filtern","text":"<ul> <li>Suche: Im Suchfeld einen Suchbegriff eingeben und mit Enter best\u00e4tigen</li> <li>Filtern: Zum Filtern kann in der Auswahlliste neben dem Suchfeld eine Auswahl der Planart getroffen werden.</li> <li>Sortieren: Die Sortierung der Eintr\u00e4ge in der Tabelle kann durch Klicken in den Tabellenkopf in einer beliebigen Spalte beeinflusst werden</li> </ul>"},{"location":"elements/plan-overview.html#planwerk-aktionen","title":"Planwerk-Aktionen","text":"<p>Die Aktionsleiste unterhalb des Suchfelds bietet als Shortcuts den Zugriff auf einige Funktionen, die sich ebenfalls \u00fcber die  Detailansicht eines Planwerks aufrufen lassen.</p> Allgemeine Aktionen <ul> <li>Alle w\u00e4hlen/abw\u00e4hlen: Auswahl aller Eintr\u00e4ge auf der aktuellen Seite</li> <li>Aktualisieren: Manuelles Synchronisieren der Eintr\u00e4ge mit den Inhalten der Datenbank</li> </ul> Planwerk-Aktionen              Diese Gruppe an Aktionen betrefft die Auswahl in der Tabelle. Zum W\u00e4hlen eines Eintrags an der entsprechenden             Stelle in die Tabelle klicken. Nach Auswahl stehen folgende Aktionen zur Verf\u00fcgung:             <ul> <li>XPlanGML exportieren: Gew\u00e4hlten Plan als XPlanGML-Datei exportieren</li> <li>Bearbeiten: \u00d6ffnet den Dialog zum Bearbeiten der Sachdaten des gew\u00e4hlten Plans</li> <li>Kartenansicht: Gew\u00e4hlten Plan auf der Karte anzeigen</li> <li>L\u00f6schen: Gew\u00e4hlten Plan aus der Datenbank entfernen</li> </ul>"},{"location":"elements/plan-overview.html#navigationswerkzeuge","title":"Navigationswerkzeuge","text":"<p>Standardm\u00e4\u00dfig werden in der Plan\u00fcbersicht 10 Pl\u00e4ne angezeigt. Um weitere Pl\u00e4ne zu laden, kann mit den Pfeilsymbolen zu  weiteren Seiten navigiert werden, wenn mehr als die initial geladenen Pl\u00e4ne in der Datenbank gespeichert sind.</p>"},{"location":"elements/plan-overview.html#einstellungen","title":"Einstellungen","text":"<p>\u00dcber das Zahnradsymbol kann der Dialog Plan\u00fcbersicht konfiguriert werden. Im Abschnitt Allgemein besteht die M\u00f6glichkeit, die Anzahl der Pl\u00e4ne pro Seite festzulegen. Im Abschnitt Tabellenspalten anordnen k\u00f6nnen einzelne Spalten ausgeblendet und per drag-and-drop die Anzeigereihenfolge der XPlan-Attribute angepasst werden.</p>"},{"location":"settings/index.html","title":"Einstellungen","text":"<p>In den Einstellungen kann das Verhalten der Anwendung konfiguriert werden. </p> <p>Warning</p> <p>Einstellungen werden im lokalen Benutzerverzeichnis gespeichert und damit nicht bei Anmeldung mit anderem Nutzer  \u00fcbernommen. Alle Einstellungen sind QGIS-Profil \u00fcbergreifend, d.h. bei Wechsel des QGIS Profils werden die gleichen Einstellungen des SAGis XPlanung \u00fcbernommen.</p>"},{"location":"settings/index.html#offnen-der-einstellungen","title":"\u00d6ffnen der Einstellungen","text":"<ul> <li>In der QGIS-Men\u00fcleiste den Men\u00fcpunkt SAGis | SAGis XPlanung | Einstellungen aufrufen      </li> </ul>"},{"location":"settings/index.html#allgemeine-einstellungen","title":"Allgemeine Einstellungen","text":"<p>Auf der Startseite der Einstellungen lassen sich die folgenden allgemeinen Einstellungen treffen:</p>"},{"location":"settings/index.html#exportoptionen","title":"Exportoptionen","text":"Pfad f\u00fcr externe Referenzen Beim XPlanGML-Export als ZIP-Archiv werden alle Externen Referenzen im angegebenen              Unterordner gespeichert. Mit Option Referenzen im Hauptordner speichern werden alle Referenzen auf gleicher             Ebene mit der XPlanGML-Datei verpackt XPlanung-Version Auswahlliste zum Wechseln der XPlanung-Version. Die festgelegte XPlanung-Version beeinflusst alle              verf\u00fcgbaren Objektklassen, Attribute und Auswahllisten in der Anwendung  <p>Info</p> <p>Beim Wechsel der Version werden keine Daten aus der Datenbank entfernt. Es findet jedoch keine                     Migration statt.</p>"},{"location":"settings/index.html#validierung","title":"Validierung","text":"Geometrien automatisch bereinigen Zum Erf\u00fcllen der Geometriepr\u00fcfung kann SAGis             XPlanung zwei Fehlerquellen bei der Datenerfassung automatisch korrigieren. Dies betrifft den korrekten              Umlaufsinn von Polygongeometrien und die Erfassung von doppelten St\u00fctzpunkten.              Wenn die Option Geometrien automatisch bereinigen aktiviert ist, werden alle Geometrien, die neu in              der Datenbank erfasst werden automatisch korrigiert. Dieser Prozess kann durch die folgenden Optionen              konfiguriert werden:             <ul> <li>                     Topologie erhalten: Die Geometriebereinigung erh\u00e4lt die topologische Struktur der Geometrien. Es                      werden nur doppelte, aufeinanderfolgende St\u00fctzpunkte entfernt.                 </li> <li>                     bessere Erkennung doppelter St\u00fctzpunkte: Die Geometriebereinigung entfernt auch doppelte St\u00fctzpunkte,                      die nicht aufeinanderfolgend sind. Dies kann jedoch zu \u00c4nderungen in der Topologie f\u00fchren.                  </li> </ul>"},{"location":"settings/codelists.html","title":"Codelisten","text":"<p>Die Verwendung von sogennanten Codelisten erlaubt es Informationen im XPlan-Format zu erfassen, die nicht direkt Teil des Standards sind. Ein Codelist-Attribut \u00e4hnelt den Schl\u00fcsselnummer-Attributen (Enumerationen), mit dem Unterschied,  dass die vorgebenen Auswahlwerte in einer externen Codeliste definiert sind. Codelisten werden in der GDI-DE Registry verwaltet.</p> <p>Findet sich kein passender Eintrag in der Codeliste oder sind die vorhandenen Werte f\u00fcr den eigenen Datensatz nicht  spezifisch genug oder unpassend, so kann die Leitstelle XPlanung / XBau kontaktiert werden, um die XPlanung-Codelisten  um passende Werte zu erweitern. </p> <ul> <li>siehe XLeitstelle: Externe Codelisten</li> </ul>"},{"location":"settings/codelists.html#codelisten-aus-gdi-de-registry-abrufen","title":"Codelisten aus GDI-DE Registry abrufen","text":"<ul> <li>Mit Button GDI-DE Standards laden werden die ver\u00f6ffentlichten Codelisten-Eintr\u00e4ge aus der Registry abgerufen</li> </ul> <p>Info</p> <p>Nach einmaligem Abruf der Codelisten-Eintr\u00e4ge werden diese in der XPlan-gespeichert. Falls \u00c4nderungen in der Registry ver\u00f6ffentlicht werden, m\u00fcssen die Daten erneut abgerufen werden um auf entsprechende neue Werte zuzugreifen.</p>"},{"location":"settings/database.html","title":"Datenbank","text":"<p>Die Seite f\u00fcr Datenbank-Einstellungen ist in die folgenden zwei Fenster unterteilt:</p> VerbindungNeue Datenbank anlegen"},{"location":"settings/database.html#verbindungsinformationen","title":"Verbindungsinformationen","text":"<p> PostGIS Verbindung Datenquelle f\u00fcr die XPlan-Daten. Nutzername Name eines PostgreSQL Nutzers mit Zugriff auf die unter PostGIS Verbindung gew\u00e4hlte Datenbank Passwort Passwort zur Authentifizierung im Zusammenhang mit dem gew\u00e4hlten Nutzernamen <p>Verbindungsinformationen</p> <p>Falls die Zugangsdaten bereits im QGIS \u00fcber die PostGIS-Verbindung gespeichert sind, werden die Felder  Nutzername und Passwort automatisch \u00fcbernommen</p>"},{"location":"settings/database.html#verbindungstest","title":"Verbindungstest","text":"<p>Mit dem Button Verbindung testen wird die Verbindung zur konfigurierten Datenbank gepr\u00fcft. Bei erflogreicher  Verbindung wird die Version der installierten XPlan-Datenbank angezeigt. Sollte die Verbindung fehlschlagen wird im Dialog stattdessen eine Fehlermeldung angezeigt. </p> <p>M\u00f6gliche Fehlermeldungen:  Inkompatible Datenbankversion              Die Version der installierten QGIS-Erweiterung ben\u00f6tigt eine andere Version der XPlan-Datenbank.              Sollte eine veraltete Datenbankversion vorliegen, besteht die M\u00f6glichkeit mit dem Button Upgrade             die Datenbank auf den aktuellen Stand zu bringen.              fehlerhafter Nutzername/Passwort Die angegebene Kombination aus Benutzernamen und Passwort hat keinen Zugriff auf die Datenbank keine XPlan-Datenbank Die angegebene PostGIS-Verbindung verweist nicht auf eine Datenbank, die dem XPlanung-Schema folgt </p> <p>\u00dcber die Seite Neue Datenbank anlegen kann eine neue (leere) XPlan-Datenbank angelegt werden. Dieser Prozess ist auf der Seite Einrichtung einer Datenquelle beschrieben.</p>"},{"location":"settings/forms.html","title":"Formulare","text":"<p>Im Fenster Formulare kann die Anzeige der Attributformulare f\u00fcr alle verf\u00fcgbaren XPlan-Objektarten angepasst werden. Durch W\u00e4hlen/Abw\u00e4hlen k\u00f6nnen einzelne Attribute in allen Dialogen, die ein Attribut\u00fcbersicht zeigen, entferent werden. XPlan-Attribute, die als Pflichtattribute gekennzeichnet sind, k\u00f6nnen nicht ausgeblendet werden.</p> <p>Tip</p> <p>Durch das Abw\u00e4hlen von wenig verwendeten Attributen, k\u00f6nnen die Eingabemasken f\u00fcr XPlan-Objekte vereinfacht und  \u00fcbersichtlicher gestaltet werden</p>"},{"location":"settings/symbology.html","title":"Darstellung","text":"<p>Zur Symbolisierung erfasster Planinhalte auf der QGIS-Karte wird durch die Anwendung eine Stilvorgabe f\u00fcr viele  XPlan-Objektklassen bereitgestellt.</p> <p>In den Darstellung-Einstellungen kann sowohl die Darstellungsreihenfolge als auch die einzelnen Stilvorgaben angepasst werden. Die Darstellungsreihenfolge leitet sich dabei aus der Position der Eintr\u00e4ge in der Liste ab. Eine h\u00f6here Position in der Liste wird beim Anzeigen eines Plans weiter oben angezeigt, w\u00e4hrend untere Eintr\u00e4ge in der Liste auf der Karte in den Hintergrund r\u00fccken. </p>"},{"location":"settings/symbology.html#symbolisierung-bearbeiten","title":"Symbolisierung bearbeiten","text":"<ul> <li>Mit Doppelklick auf einen beliebigen Eintrag in der Liste der XPlan-Objektklassen \u00f6ffnet sich ein Dialog zum Anpassen   der Darstellungseinstellungen. Hier k\u00f6nnen alle \u00fcblichen QGIS-Konfigurationsm\u00f6glichkeiten angewandt werden um einen   Stil zu laden oder anzupassen.</li> </ul> <p>Note</p> <p>Viele XPlan-Objektklassen k\u00f6nnen mit unterschiedlichem Geometetriebezug auftreten (Punkt, Linie oder Polygon). F\u00fcr entsprechende Klassen existiert ein Eintrag pro Geometrietyp in der Liste der Objektklassen.</p>"},{"location":"settings/symbology.html#darstellungsreihenfolge-anpassen","title":"Darstellungsreihenfolge anpassen","text":"<ul> <li>Nach Markieren eines Eintrags in der Liste der XPlan-Objektklassen kann der gew\u00e4hlte Eintrag mit den Pfeilsymbolen in   der Aktionsleiste nach oben oder unten versschoben werden. Alternativ kann jeder Eintrag auch per drag-and-drop in   der Liste verschoben werden.</li> </ul>"},{"location":"settings/symbology.html#weitere-aktionen","title":"Weitere Aktionen","text":"<ul> <li>Aufruf weiterer Aktionen \u00fcber das Men\u00fc (Button mit drei vertikalen Punkten in der Aktionsleiste)</li> </ul> Einstellungen zur\u00fccksetzen Setzt die Darstellungskonfiguration auf den von SAGis XPlanung bereitgestellten Standard zur\u00fcck Einstellungen exportieren/importieren Funktion zum Export der konfigurierten Stilvorgaben. Eine exportierte Datei kann mit der Option              Einstellungen importieren eingelesen werden"},{"location":"settings/symbology.html#benutzerdefinierte-stildateien","title":"Benutzerdefinierte Stildateien","text":"<p>Neben der Option einzelne Stile anzupassen, besteht die M\u00f6glichkeit, in einem Verzeichnis f\u00fcr benutzerdefinierte Stile \u00fcbliche QGIS-Stildefinitionen (QML-Dateien) abzulegen.</p> <p>Das Verzeichnis kann mit dem Button \u00d6ffnen im Dateiexplorer ge\u00f6ffnet werden.</p> <p>Alle hinterlegten Stildateien, m\u00fcssen einem vorgegebenen Schema bei der Bezeichnung der Dateinamen folgen:</p> {XPlan-Objektart}-{Geometriedimension}.qml <ul> <li>XPlan-Objektart: exakte Bezeichnung der XPlan-Objektklasse aus dem Katalog der Objektarten</li> <li>Geometriedimension: 0 - Punktgeometrien, 1 - Liniengeometrien, 2 - Polygongeometrien</li> </ul>             Beispielsweise FP_BebauungsFlaeche-2.qml f\u00fcr alle Fl\u00e4chengeometrien die eine Bebauungsfl\u00e4che darstellen."},{"location":"setup/index.html","title":"Installation und Einrichtung","text":"<p>Die Einrichtung von SAGis XPlanung setzt folgende Installationen voraus:</p> <ul> <li>QGIS (&gt; 3.22)</li> <li>PostgreSQL (&gt; 12) mit Erweiterung PostGIS (&gt; 3.4)</li> </ul> <p>Zus\u00e4tzlich wird eine Internetverbindung f\u00fcr das Laden einiger Komponenten der Anwendung bei der Installation ben\u00f6tigt.</p> <p>Zur Installation der Anwendung stehen die in den folgenden beiden Abschnitten beschriebenen Vorgehensweise zur  Verf\u00fcgung. Die Nutzung des Installationsprogramm steht erstmals seit der Version 1.5.0 zur Verf\u00fcgung. F\u00fcr die  Installation ab Version 2.0 ist die Installation \u00fcber den QGIS Plugin Manager mithilfe der Plugin-ZIP Datei empfohlen.</p> <ul> <li>Community-Edition: Installation aus QGIS Plugin Repository</li> <li>Vollversion: Installation \u00fcber Plugin-Datei</li> </ul> <p>Zus\u00e4tzlich zum QGIS-Plugin ben\u00f6tigt SAGis XPlanung eine PostgreSQL Datenbank.</p> <ul> <li>Einrichtung einer Datenbank</li> </ul>"},{"location":"setup/database-setup.html","title":"Einrichtung einer Datenquelle","text":"Neue Standard DatenquelleManuelle Konfiguration <p>Neu in Version 2.0.1</p> <ol> <li>Einstellungen aufrufen: SAGis | SAGis XPlanung | Einstellungen</li> <li>Seite Datenbank aufrufen</li> <li>Option Neue Datenbank anlegen w\u00e4hlen</li> <li>Verbindungsinformation eintragen:      Name Beliebiger Name der zu erstellenden Datenbank Host Host-Adresse des PostgreSQL Server Port Der TCP Port des PostgreSQL Server Nutzername Name eines PostgreSQL Nutzers mit Berechtigung zum Erstellen neuer Datenbanken und Tabellen Passwort Passwort zur Authentifizierung im Zusammenhang mit dem gew\u00e4hlten Nutzernamen </li> <li>Mit Button Erstellen die neue Datenbank erstellen</li> <li>Nach erfolgreichem Erstellen der Datenbank mit Button Konfiguration anwenden die neue Datenbank als aktuelle Datenquelle festlegen</li> </ol> <p> Neue XPlan Datenbank anlegen <p>Info</p> <p>Falls bereits eine XPlan-Datenbank besteht, kann dieser Schritt \u00fcbersprungen werden</p> <ol> <li>Im PostgreSQL eine neue Datenbank anlegen, beispielsweise mit pgAdmin</li> <li>SQL-Skript (create_&lt;version&gt;.sql) zum Erzeugen des XPlan-Schemas in der Datenbank ausf\u00fchren </li> </ol> <p> Neue PostgreSQL Verbindung anlegen <ol> <li>Im QGIS Bedienfeld Browser das Kontextmen\u00fc auf dem Men\u00fcpunkt PostgreSQL \u00f6ffnen (rechte Maustaste)</li> <li>Neue Verbindung aufrufen</li> <li>Verbindungsinformationen der im Schritt zuvor angelegten Datenbank eintragen:      </li> </ol> <p> Neue Datenquelle anlegen (SAGis XPlanung) <ol> <li>Einstellungen aufrufen: SAGis | SAGis XPlanung | Einstellungen</li> <li>Seite Datenbank aufrufen</li> <li>Option Verbindung w\u00e4hlen</li> <li>In der Auswahlliste PostGIS Verbindung die neu angelegte Verbindung w\u00e4hlen</li> <li>Die Felder Nutzername und Passwort f\u00fcllen, falls diese Information nicht in den QGIS-Optionen gesetzt wurde </li> </ol>"},{"location":"setup/install.html","title":"Installation des QGIS Plugins","text":""},{"location":"setup/install.html#installation-aus-qgis-plugin-repository","title":"Installation aus QGIS Plugin Repository","text":"Community-Version <ol> <li>Erweiterungsmanager aufrufen: Erweiterungen | Erweiterungen verwalten und installieren\u2026</li> <li>Option Alle in der Seitenleiste w\u00e4hlen</li> <li>Im Suchfeld nach SAGis suchen und den Eintrag SAGis XPlanung w\u00e4hlen</li> <li>Erweiterung installieren </li> </ol>"},{"location":"setup/install.html#installation-uber-plugin-datei","title":"Installation \u00fcber Plugin-Datei","text":"Vollversion <ol> <li>Erweiterungsmanager aufrufen: Erweiterungen | Erweiterungen verwalten und installieren\u2026</li> <li>Option Aus ZIP installieren in der Seitenleiste w\u00e4hlen</li> <li>Dateipfad zum Archiv der Anwendung ausw\u00e4hlen (SAGis.XPlanung_&lt;version&gt;.zip)</li> <li>Erweiterung installieren </li> </ol>"}]}