import logging
from dataclasses import dataclass
from enum import Flag, auto
from typing import List

from sqlalchemy import Column

from SAGisXPlanung import XPlanVersion

logger = logging.getLogger(__name__)


class LayerPriorityType(Flag):
    """ Enum to configure the layer priority of XPlanung layers when adding to the layer tree """

    Top = auto()  # Layer prefers to stay at top
    Bottom = auto()  # Layer prefers to stay at the bottom
    CustomLayerOrder = auto()  # Layer is affected by the custom layer order from Settings/QgsConfig
    OutlineStyle = auto()  # Layer has a style that only affects the outline, and should therefore stay above others


def xp_version(versions: List[XPlanVersion]):
    """ Class-Decorator to denote the XPlan-Version a class belongs to."""
    def decorator_versions(cls):
        setattr(cls, 'xp_versions', versions)
        return cls
    return decorator_versions
