# -*- coding: utf-8 -*-
"""
/***************************************************************************
 RiskGuardDialog
                                 A QGIS plugin
 test
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-04-07
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Alessio Corsini
        email                : alessio.corsini@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import requests
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
'''from PyQt5.QtNetwork import QNetworkAccessManager, QNetworkRequest, QNetworkReply'''
from PyQt5 import QtCore
from .flow_layout import FlowLayout
from .services.data_services import DataServices
from .widget_creator import WidgetCreator
from .services.data_download import DownloadServices
import logging
#from .services.data_db_save import DBWorker


# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'riskGuard_dialog_base.ui'))


class RiskGuardDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(RiskGuardDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.logger = logging.getLogger(__name__)
        # Initialize attributes
        self.dataset_url = 'https://ddshub.cmcc.it/web/datasets'
        self.datasource = 'cmcc'
        self.groupBox = []
        self.selected_ids = []  # Array to keep track of selected checkbox IDs
        self.labelErrorNoInfo = None

        # Connect UI elements to methods
        self.comboServiceURL.activated.connect(self.getVariableDataset)
        self.radioButton_copernicus.clicked.connect(self.onRadioButtonToggled)
        self.radioButton_cmcc.clicked.connect(self.onRadioButtonToggled)
        self.widget_creator = WidgetCreator(self, self.verticalLayout)


        # Example button to trigger DB connection
        #self.connectButton = QtWidgets.QPushButton("Connect to DB")
        #self.layout().addWidget(self.connectButton)
        #self.connectButton.clicked.connect(self.trigger_connect_db)

    '''def trigger_connect_db(self):
        print("Button clicked!")

        # Database connection parameters
        db_params = ("localhost", "5432", "postgres", "corsini", "new_database_name")

        # Create a DBWorker instance
        self.worker = DBWorker(db_params)

        # Connect the finished signal to a slot to handle the result
        self.worker.finished.connect(self.on_db_task_finished)

        # Start the worker thread
        self.worker.start()

    def on_db_task_finished(self, result):
            # This method will handle the result emitted by DBWorker
            print(f"Database operation result: {result}")'''

    def onRadioButtonToggled(self):
        if self.radioButton_copernicus.isChecked():
            self.collections_url = 'https://cds.climate.copernicus.eu/api/catalogue/v1/collections'
            self.dataset_url = 'https://cds.climate.copernicus.eu/api/catalogue/v1/datasets'
            self.keywords_url = 'https://cds.climate.copernicus.eu/api/catalogue/v1/vocabularies/keywords'
            self.constraints_url = 'https://cds.climate.copernicus.eu/api/retrieve/v1/processes'
            self.licences_url = 'https://cds.climate.copernicus.eu/api/profiles/v1/account/licences?scope=all'
            self.datasource = 'copernicus'
            self.create_combo_product_type()
        elif self.radioButton_cmcc.isChecked():
            #if self.groupBox is not None:
            self.remove_group_box() #Remove CDS Product Type
            self.dataset_url = 'https://ddshub.cmcc.it/web/datasets'
            self.datasource = 'cmcc'
            self.populate_combo_box('cmcc', None)



    def create_combo_product_type(self):
        
        self.widget_creator.remove_inner_group_box()

        parent_layout = self.verticalLayout_4
        # Remove existing group box if it exists
        if hasattr(self, 'groupBox') and isinstance(self.groupBox, QtWidgets.QGroupBox):
            # Remove the groupBox from the layout
            if self.groupBox in parent_layout.children():
                parent_layout.removeWidget(self.groupBox)
            self.groupBox.deleteLater()  # Delete the group box
            self.groupBox = None  # Reset the reference

        self.comboServiceURL.clear() 
        flowLayout = FlowLayout()
        response = DataServices(self.keywords_url).getData()
        
        # Filter for only "Product type" entries
        product_type_entries = [item for item in response['keywords'] if item['id'].startswith('Product type:')]
        # Extract the labels from the filtered entries
        product_labels = [entry['label'].split(": ")[1] for entry in product_type_entries]
        product_ids = [entry['id'] for entry in product_type_entries]  # Extract the IDs

        self.groupBox = QtWidgets.QGroupBox('Product type', self)

        for id, label in zip(product_ids, product_labels):
            checkbox = QtWidgets.QCheckBox(label)
            checkbox.setObjectName(id)  # Set the checkbox ID as its object name
            checkbox.stateChanged.connect(lambda state, id=id: self.on_checkbox_state_changed(state, id))
            flowLayout.addWidget(checkbox)
        
        self.groupBox.setLayout(flowLayout)
        # Access the layout where you want to insert the dropdown
        #parent_layout = self.verticalLayout_4  # QVBoxLayout inside the QGroupBox
        # Insert the new combo box above the horizontal layout
        parent_layout.insertWidget(1, self.groupBox)  # Inserting at the 0th position'''


    def on_checkbox_state_changed(self, state, id): #Populate array with product type checked
        if state == QtCore.Qt.Checked:
            if id not in self.selected_ids:
                self.selected_ids.append(id)
                #print(f"Added {id} to selected_ids: {self.selected_ids}")
        elif state == QtCore.Qt.Unchecked:
            if id in self.selected_ids:
                self.selected_ids.remove(id)
                #print(f"Removed {id} from selected_ids: {self.selected_ids}")
        
        self.populate_combo_box('copernicus', self.selected_ids)


    #Populate combo with dataSet CDS or CMCC
    def populate_combo_box(self, datasource, selected_ids):
        self.comboServiceURL.clear()  # Clear the combo box
        self.comboServiceURL.addItem('Select Item')

        self.widget_creator.remove_inner_group_box()

        if datasource == 'cmcc':

            try:
                # Make a GET request API
                response = DataServices(self.dataset_url).getData() 
                response = response.get('data')
                #DownloadServices.download_cmcc()
                #print("cmcc data", response)
                for resource in response:
                    self.comboServiceURL.addItem(resource.get('id'))
                    if "products" in resource:
                        index = self.comboServiceURL.count() - 1  # Get the index of the last added item
                        self.comboServiceURL.setItemData(index, resource.get('products'), QtCore.Qt.UserRole + 1)
            except requests.exceptions.ConnectionError as e:
                self.display_message(f"Connection error: {e}", "red")

        else:
            try:
                # Make a GET request API Dataset
                if self.selected_ids:
                    # Create a list of parameter strings "kw=value"
                    params = [f"kw={keyword}" for keyword in self.selected_ids]
                    # Join the parameters with '&' and append to the base URL
                    query_string = "&".join(params)
                    request_url = f"{self.dataset_url}?{query_string}&sortby=update&page=0&limit=50&search_stats=true"
                    
                    
                    # Check if labelErrorNoInfo exists, else create it
                    '''if not hasattr(self, 'labelErrorNoInfo') or self.labelErrorNoInfo is None:
                        self.labelErrorNoInfo = QtWidgets.QLabel("")
                        self.verticalLayout.addWidget(self.labelErrorNoInfo)
                        self.groupBox.setLayout(self.verticalLayout)'''
                    
                    response = DataServices(request_url).getData() 
                    #DownloadServices.download_cds()
                    if response is not None:
                        response = response.get('collections')
                        
                        for resource in response:
                            self.comboServiceURL.addItem(resource.get('id'))
                            self.display_message(f"Number of dataset: {len(response)}", "black")
                            #self.labelErrorNoInfo.setText(f"DataSet: {len(resource.get('id'))}")
                            #self.labelErrorNoInfo.setStyleSheet("color: black;")
                    else:
                        self.display_message("The 'dataset' key is either missing or its value is None.", "red")
                        #self.labelErrorNoInfo.setStyleSheet("color: red;")
                        
            except requests.exceptions.ConnectionError as e:
                self.display_message(f"Connection error: {e}", "red")
            except Exception as e:
                self.display_message(f"An error occurred: {e}", "red")
            
        
    

    def getVariableDataset(self):
        selectedTextCombo = self.comboServiceURL.currentText()
        selectedDataSet = self.comboServiceURL.currentData(QtCore.Qt.UserRole + 1)

        if selectedTextCombo != 'Select Item':
            
            self.widget_creator.remove_inner_group_box()
            
            if self.datasource == 'cmcc':
                data_service = DataServices(self.dataset_url +'/'+ selectedTextCombo)
                dataset_json = data_service.getData()
                self.create_cmcc_products(dataset_json)
                #self.widget_creator.create_cmcc_widgets(dataset_json)
            elif self.datasource == 'copernicus':
                data_service = DataServices(self.collections_url +'/'+ selectedTextCombo)
                dataset_json = data_service.getData()

                licences_list = DataServices(self.licences_url).getLicences()
                

                url_constrain = self.constraints_url + '/' + selectedTextCombo +'/constraints'
                # Check if there is a link with 'rel': 'form' in the 'links' list
                form_link = None
                if 'links' in dataset_json:
                    for link in dataset_json['links']:
                        if link.get('rel') == 'form':
                            form_link = link
                            data_service = DataServices(form_link.get('href'))
                            break

                if form_link:
                    dataset_json = data_service.getData()
                    self.widget_creator.create_copernicus_widgets(dataset_json, url_constrain, selectedTextCombo, licences_list)
                else:
                    self.widget_creator.create_copernicus_widgets(None)


    def create_cmcc_products(self, dataset_json):
        parent_layout = self.verticalLayout_4
        products = dataset_json['dataset'].get("products", [])
        self.default_product = dataset_json['dataset'].get("default", None)  # Get the default product
        self.dataset_id = dataset_json['dataset'].get("id")

        # Remove existing group box if it exists
        if hasattr(self, 'groupBox') and isinstance(self.groupBox, QtWidgets.QGroupBox):
            # Remove the groupBox from the layout
            if self.groupBox in parent_layout.children():
                parent_layout.removeWidget(self.groupBox)
            self.groupBox.deleteLater()  # Delete the group box
            self.groupBox = None  # Reset the reference

        
        if products:
            self.groupBox = QtWidgets.QGroupBox("Products")
            flowLayout = FlowLayout()
            
            # Create a button group to ensure only one product can be selected
            product_button_group = QtWidgets.QButtonGroup(self)
            product_button_group.setExclusive(True)

            # Add a radio button for each product
            for product in products:
                product_radio_button = QtWidgets.QRadioButton(product['description'])
                product_radio_button.setStyleSheet("QRadioButton { padding: 10px; }")
                
                # Check if the product ID matches the default product
                if product['id'] == self.default_product:
                    product_radio_button.setChecked(True)  # Pre-select the default product
                    self.period_cmcc_changed(2, product['description'], product['id'])
                    #self.create_selected_items('product_type', default_product, 2, '')
                
                product_radio_button.toggled.connect(lambda checked, description=product['description'], id=product['id']: self.period_cmcc_changed(checked, description, id))
                product_button_group.addButton(product_radio_button)  # Add to the button group
                flowLayout.addWidget(product_radio_button)  # Add to the layout

            self.groupBox.setLayout(flowLayout)

        self.groupBox.setLayout(flowLayout)
        parent_layout.addWidget(self.groupBox)
    

    def period_cmcc_changed(self, checked, description, id):
            if checked:  # Only trigger when a radio button is selected
                self.widget_creator.remove_inner_group_box()  # Remove all dynamically created widgets except `Products`
                # Fetch new dataset and populate widgets
                data_service = DataServices(self.dataset_url + '/' + self.dataset_id + '/' + id)
                dataset_json = data_service.getData()
                self.widget_creator.create_cmcc_widgets(dataset_json, id)


    def remove_group_box(self): #remove the product type list box
        if self.groupBox:
            self.selected_ids = []
            
            # Access the layout where the groupBox is placed
            parent_layout = self.verticalLayout_4
            # Remove the groupBox from the layout
            parent_layout.removeWidget(self.groupBox)
                
            if self.labelErrorNoInfo is not None:
                self.labelErrorNoInfo.deleteLater()
                self.labelErrorNoInfo = None
            # Delete the groupBox
            self.groupBox.deleteLater()
            self.groupBox = None  # Reset the reference
            

    def display_message(self, message, color):
        """Display messages (success or error) in a QLabel with dynamic color."""
        if not hasattr(self, 'labelErrorNoInfo') or self.labelErrorNoInfo is None:
            self.labelErrorNoInfo = QtWidgets.QLabel("")
            self.verticalLayout.addWidget(self.labelErrorNoInfo)

        self.labelErrorNoInfo.setText(message)
        self.labelErrorNoInfo.setStyleSheet(f"color: {color};font-weight: Bold;")
        self.labelErrorNoInfo.show()