from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.QtSql import *
from qgis.core import *
from qgis.utils import *
from qgis.gui import *
from PyQt4.QtCore import QSettings, QTranslator, qVersion, QCoreApplication
from PyQt4.QtGui import QAction, QIcon
from os.path import expanduser
import processing
from    pyspatialite  import dbapi2 as sqlite
import  subprocess
import os

result = False

class MostraErros(QMainWindow):

 closed = pyqtSignal( int )

 def __init__(self, camada_erros, camada_base, camada_corrigida, deleta_camada, camada_ref):
    
    QMainWindow.__init__(self)
    self.camada_erros = camada_erros
    self.camada_base = camada_base
    self.camada_corrigida = camada_corrigida
    self.camada_ref = camada_ref
    self.deleta_camada = deleta_camada
    self.canvas = QgsMapCanvas()
    self.canvas.setCanvasColor(Qt.white)
    self.canvas.setDestinationCrs(iface.mapCanvas().mapSettings().destinationCrs())
    self.ifaceCanvas =  iface.mapCanvas()

    self.x = 0

    self.selecionadas = []

    for feat in self.camada_base.selectedFeatures():
        self.selecionadas.append(feat.geometry().asPolyline())
        
    for feat in self.camada_erros.getFeatures():
            if feat.id() == self.x:
                self.canvas.setExtent(feat.geometry().boundingBox())
                self.canvas.refresh()
                self.ifaceCanvas.setExtent((feat.geometry().boundingBox()))
                self.ifaceCanvas.refresh()   

    list_layer = [QgsMapCanvasLayer(self.camada_erros), QgsMapCanvasLayer(self.camada_corrigida), QgsMapCanvasLayer(self.camada_ref)]
    for layer in iface.legendInterface().layers():
        if  iface.legendInterface().isLayerVisible(layer):
            if layer <> self.camada_base and layer <> self.camada_erros and QgsMapCanvasLayer(layer) not in list_layer:
                list_layer.append(QgsMapCanvasLayer(layer))

    self.canvas.setLayerSet(list_layer)



    self.setCentralWidget(self.canvas)

    actionZoomIn = QAction("Zoom in", self)
    actionZoomOut = QAction("Zoom out", self)
    actionPan = QAction("Pan", self)
    actionRepair = QAction("Repair", self)
    actionNext = QAction("Next Error", self)
    actionPrevious = QAction("Previous Error", self)


    actionZoomIn.setCheckable(True) 
    actionZoomOut.setCheckable(True)
    actionPan.setCheckable(True)



    self.connect(actionZoomIn, SIGNAL("triggered()"), self.zoomIn)
    self.connect(actionZoomOut, SIGNAL("triggered()"), self.zoomOut)
    self.connect(actionPan, SIGNAL("triggered()"), self.pan)
    
    if camada_base.name()== 'Face de quadra' or camada_base.name() == 'Eixo de logradouro':
        self.connect(actionRepair, SIGNAL("triggered()"), self.repair_2)
        if camada_base.name()== 'Face de quadra':
            self.id = 'id_fac'
        else:    
            self.id = 'id_eix'
    else:
        self.connect(actionRepair, SIGNAL("triggered()"), self.repair)
    self.connect(actionNext, SIGNAL("triggered()"), self.next)
    self.connect(actionPrevious, SIGNAL("triggered()"), self.previous)

    self.toolbar = self.addToolBar("Canvas actions")
    self.toolbar.addAction(actionZoomIn)
    self.toolbar.addAction(actionZoomOut)
    self.toolbar.addAction(actionPan)
    self.toolbar.addAction(actionRepair)
    self.toolbar.addAction(actionNext)
    self.toolbar.addAction(actionPrevious)     
    


    # create the map tools
    self.toolPan = QgsMapToolPan(self.canvas)
    self.toolPan.setAction(actionPan)
    self.toolZoomIn = QgsMapToolZoom(self.canvas, False) # false = in
    self.toolZoomIn.setAction(actionZoomIn)
    self.toolZoomOut = QgsMapToolZoom(self.canvas, True) # true = out
    self.toolZoomOut.setAction(actionZoomOut)
    self.toolZoomOut = QgsMapToolZoom(self.canvas, True) # true = out
    self.toolZoomOut.setAction(actionZoomOut)


    self.ifaceCanvas.extentsChanged.connect(lambda:self.sync())
    self.canvas.extentsChanged.connect(lambda:self.sync2())

 def closeEvent(self, event):
    QgsMapLayerRegistry.instance().removeMapLayer(self.camada_erros)
    QgsMapLayerRegistry.instance().removeMapLayer(self.camada_corrigida)
    QgsMapLayerRegistry.instance().removeMapLayer(self.deleta_camada)
    QgsMapLayerRegistry.instance().removeMapLayer(self.camada_ref)
    
    
 def zoomIn(self):
   self.canvas.setMapTool(self.toolZoomIn)

 def zoomOut(self):
   self.canvas.setMapTool(self.toolZoomOut)

 def pan(self):
   self.canvas.setMapTool(self.toolPan)
 

 
 def repair_2(self):
    self.camada_base.startEditing()
    
    for feat in self.camada_erros.getFeatures():
        if feat.id() == self.x:      
            geom_1 = feat.geometry()
            box_1 = geom_1.boundingBox()
              
    index_1 = QgsSpatialIndex()        
          
    for feat in self.camada_corrigida.getFeatures():
        index_1.insertFeature(feat)
        
        
    adicionar = index_1.intersects(box_1)
    
    for feat_corrigida in self.camada_corrigida.getFeatures():
    
        if feat_corrigida.id() in adicionar:
            geom = feat_corrigida.geometry()
            geom.convertToMultiType()
            for feat in self.camada_base.getFeatures():
                if feat.attribute(self.id) == feat_corrigida.attribute(self.id):
                    self.camada_base.changeGeometry(feat.id(), geom)       
                    
    
    id_deleta =  []
    for feat in self.deleta_camada.getFeatures():
        id_deleta.append(feat.attribute(self.id))    
    
    index_2 = QgsSpatialIndex() 
            
    for feat in self.camada_base.getFeatures():
        index_2.insertFeature(feat)
      
    deletar = index_2.intersects(box_1)

    deleta = []
    for feat in self.camada_base.getFeatures():
        if feat.id() in deletar and feat.attribute(self.id) in id_deleta:           
            deleta.append(feat.id())    
             
    self.camada_base.deleteFeatures(deleta)    
    
    self.camada_base.updateFields()                 
    self.ifaceCanvas.refresh()

 def repair(self):
    self.camada_base.startEditing()
    
    for feat in self.camada_erros.getFeatures():
        if feat.id() == self.x:      
            geom_1 = feat.geometry()
            box_1 = geom_1.boundingBox()
              
    index_1 = QgsSpatialIndex()        
          
    for feat in self.camada_corrigida.getFeatures():
        index_1.insertFeature(feat)
        
        
    adicionar = index_1.intersects(box_1)
    
    for feat_corrigida in self.camada_corrigida.getFeatures():
    
        if feat_corrigida.id() in adicionar:
            geom = feat_corrigida.geometry()
            geom.convertToMultiType()
            self.camada_base.changeGeometry(feat_corrigida.attribute('id_or'), geom)       
                    

    index_2 = QgsSpatialIndex() 
            
    for feat in self.deleta_camada.getFeatures():
        index_2.insertFeature(feat)
        
    deletar = index_2.intersects(box_1)
    deleta = []
    for feat in self.deleta_camada.getFeatures():
        if feat.id() in deletar:
             feat.id()
             feat.attribute('id_or')
             deleta.append(feat.attribute('id_or'))    
             
    self.camada_base.deleteFeatures(deleta)    
     
    self.camada_base.updateFields()                 
    self.ifaceCanvas.refresh()


 
 def next(self):
   if self.x < max(self.camada_erros.allFeatureIds()): 
    self.x = self.x+1
   else:  
    mostra_mensagem = iface.messageBar().pushMessage("last error was found", level=QgsMessageBar.INFO, duration =  10)    
                   
   for feat in self.camada_erros.getFeatures():
            if feat.id() == self.x:
                self.canvas.setExtent(feat.geometry().boundingBox())
                self.canvas.refresh()
                self.ifaceCanvas.setExtent((feat.geometry().boundingBox()))
                self.ifaceCanvas.refresh()
            feat            

 def previous(self):
    if self.x > 0:
       self.x = self.x-1 
       for feat in self.camada_erros.getFeatures():
                if feat.id() == self.x:
                    self.canvas.setExtent(feat.geometry().boundingBox())
                    self.canvas.refresh()
                    self.ifaceCanvas.setExtent((feat.geometry().boundingBox()))
                    self.ifaceCanvas.refresh()    
       
 def sync(self):
    if self.canvas.extent().center() <> self.ifaceCanvas.extent().center():
        self.canvas.setExtent(self.ifaceCanvas.extent())
        self.canvas.refresh()
    
 def sync2(self):
    if self.canvas.extent().center() <> self.ifaceCanvas.extent().center():
        self.ifaceCanvas.setExtent(self.canvas.extent())
        self.ifaceCanvas.refresh()