# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Reloader                    A QGIS plugin : Reloads the current layer
                              -------------------
        begin                : 2013-01-07
        copyright            : (C) 2012-2013, CS Information Systems, CSSI
        contributors         : Alexia Mondot
        email                : alexia.mondot@c-s.fr
 ***************************************************************************/
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
History :
2014-03-25 : QGIS 2.0 compatibility
"""

# Import the PyQt and QGIS libraries
from PyQt4.QtCore import QFileInfo, QSettings, qVersion, QObject, QCoreApplication, QTranslator, SIGNAL
from PyQt4.QtGui import QIcon, QAction, QMessageBox


from qgis.core import QgsMapLayerRegistry, QgsApplication


# Initialize Qt resources from file resources.py
import resources_rc


class Reloader:
    """
    This class allows to reload the current layer.
    
    Keyword arguments:
        QGIS :
        self.iface      -- qgis interface
        self.canvas     -- qgis map canvas
        self.plugin_dir -- qgis plugin's directory
    """

    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface
        self.canvas = self.iface.mapCanvas()

        self.plugin_dir = QFileInfo(QgsApplication.qgisUserDbFilePath()).path() + "/python/plugins/reloader"
        # initialize locale
        localePath = ""
        locale = QSettings().value("locale/userLocale")[0:2]

        if QFileInfo(self.plugin_dir).exists():
            localePath = self.plugin_dir + "/i18n/reloader_" + locale + ".qm"

        if QFileInfo(localePath).exists():
            self.translator = QTranslator()
            self.translator.load(localePath)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

    
    def initGui(self):
        # Create action that will start plugin configuration
        self.action = QAction(
            QIcon(":/plugins/reloader/icon.png"),
            u"Reloader", self.iface.mainWindow())
        # connect the action to the run method
        QObject.connect(self.action, SIGNAL("triggered()"), self.run)

        # Add toolbar button and menu item
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu(u"&Reloader", self.action)

    
    def unload(self):
        # Remove the plugin menu item and icon
        self.iface.removePluginMenu(u"&Reloader", self.action)
        self.iface.removeToolBarIcon(self.action)

    
    # run method that performs all the real work
    def run(self):
        """
        This method runs the reloading.
        It get the source of the current layer.
        It reopens it and rename the old layer with the suffix "_old"
        """
        
        # the following line should allow to put the new layer in the same qgis group as the old one
        #layer_interface = self.iface.legendInterface().groupLayerRelationship()
        
        
        #the layer to reload is the selected layer QgsMapLayer
        layer = self.canvas.currentLayer() #QgsMapCanvas
        
        
        # if no layers were selected,
        if layer == None :
            QMessageBox.warning(self.iface.mainWindow(), "Reloader", "Please select one layer")
            return False
        else :
            layername = layer.name()
            layersource = layer.source()
            newLayerName = layername# + "_reloaded"
            oldLayerName = layername + "_old"
            typeLayer = layer.type()
            if typeLayer == 0 :
                #vector layer
                self.iface.addVectorLayer( layersource, newLayerName, "ogr" )
            elif typeLayer == 1 :
                #adding the reloaded layer
                self.iface.addRasterLayer( layersource, newLayerName )
            else :
                QMessageBox.warning(self.iface.mainWindow(), "Reloader", "This layer is not compatible with Realoder")
                return False
            #changing the name of the old layer
            layer.setLayerName( oldLayerName )
            
        #Note : QgsDataProvider has a method called reloadData() 
        #But it seems not working yet
        
        
        
