# ![rasterbender](resources/icon.png) ![rasterbender](resources/icon.png) ![rasterbender](resources/icon.png) RasterBender ![rasterbender](resources/icon.png) ![rasterbender](resources/icon.png) ![rasterbender](resources/icon.png)

RasterBender is an __EXPERIMENTAL__ QGIS Python plugin allowing to distort raster layers using pairs of points. This allows to match data that has complex non-uniform and non-linear deformations (historical maps, hand drawn sketches...).

__This plugin is not much tested__ and you should be very careful when using it.

![rasterbender](resources/animation.gif)

## How to use

Launch RasterBender from the plugins menu or from the plugin toolbar.

RasterBender works a bit like the georeferencer : you have to create pairs of points, the first one being the original location, and the second one being the target location.

To do so, RasterBender uses plain Linestring layers. Each pair is defined by the starting point and ending point of a Line in this layer.
You can either use one of your own Linestring layers, or use the ![create pairs layers](resources/mActionCaptureLine.png) button from the RasterBender window.

You can also create a constraint layers, which will constrain the triangulation created by the plugin. This can be useful if you have some artifact generated by unwanted triangles. The constraints are line that should go from one starting point to another. Use the preview to see if the triangulation is affected as expected.

If you use RasterBender's layers, I recommend __installing the "Save memory layer" plugin__ which will allow to save your work.

Once the layer to bend and the pairs layer are chosen, simply hit "run", wait a while (it can be quite long), and a new raster will be saved at the target path.


### How does the bending work

The first points of all pairs will be triangulated, and this triangulation will be mapped on the last points of all pairs. The raster layer will then be deformed by matching the triangulation.

The "buffer" parameters sets a buffer around the triangulation, so that the transformation ends more smoothely on the edges. Hold the "preview" button to see the size of the buffer.

Using this method will __INDUCE DEFORMATIONS__. You should __ONLY__ use it if your data is already deformed, and not to accomplish CRS transformations nor linear/affine transformations.

### The constraints layer

The constraint layers allow to prevent triangles edges from passing through certain lines, so that those lines remain linear. A typical example is if you are distorting maps containing buildings : you may want the edges of the buildings to be preserved.

To use the constraints layer, create lines that join the starting point of at least two pairs. Preview the result to see the effect. Note that you must enable snapping for the constraints to work (constraints must pass exactly through the pairs' starting points).


## Feedback / Bugs / Contribute / Known limitations

Please report bugs and ideas and see known limitations on the issue tracker : https://github.com/olivierdalang/RasterBender/issues

When reporting bugs, run the plugin with the debug checkbox and copy all QGIS's log. 

Or send me some feedback at : olivier.dalang@gmail.com

RasterBender is in its early stages of developpement, and is not much tested. Please be very careful and report any unexpected behaviour.

## Version history

- 2014-11-17 - Version 0.0 : intial release
- 2014-11-18 - Version 0.0.1 : add style button
- 2016-04-27 - Version 0.0.2 : the deformation is interpolated
- 2016-05-07 - Version 0.0.3 : the transformation now uses GDAL
- 2016-05-18 - Version 0.0.4 : bugfix with older versions of GDAL, added debug checkbox
- 2016-05-19 - Version 0.0.5 : works with non-georeferenced rasters again
- 2016-05-19 - Version 0.0.6 : fix a windows 7 specific issue
- 2016-05-29 - Version 0.0.7 : speed improvement on large rasters

## Sponsors

Many thanks to Geodeticca for sponsoring the developpement of the versions 0.0.2 through 0.0.7 of this plugin. [http://www.geodeticca.sk](http://www.geodeticca.sk)

## How it works (internally)

Here's how it works :

Preparing the mesh

1. Get a triangular mesh by doing a Delaunay triangulation of all original input points (starting points of the lines in the Raster Bender layer)
2. Adapt this mesh on the ending points of the lines
3. Get the convex hull of the points, offset it by some factor to have a smooth transition on the borders.

Doing the transformation

1. Copy the initial raster on the destination raster file
2. Use `gdal_translate` to take an extract of the intial raster corresponding to each initial triangle's bounding box (uses `-srcwin`) and reproject it with an affine transformation to match it to the target triangle (uses three `-gcp` arguments)
3. Use `gdalwarp` to collect all those extracts onto the destination raster files, cropped by the destination triangle (uses `-cutline` and `-cblend` arguments)


