import os
import sys
import importlib

# QGIS Processing imports
from qgis.core import QgsProcessingProvider
from qgis.PyQt.QtGui import QIcon

# Import the algorithms
from .dem_slope_processing import DemSlopeProcessing
from .standard_flood_analysis import StandardFloodAnalysis
from .flash_flood_analysis import FlashFloodAnalysis  
from .rainfall_data_downloader import RainfallDataDownloader
from .dependency_manager import DependencyManager

class Rain2FloodProvider(QgsProcessingProvider):
    def __init__(self):
        super().__init__()
    
    def loadAlgorithms(self):
        # Check dependencies before loading algorithms
        missing = DependencyManager.check_dependencies()
        if missing:
            DependencyManager.show_install_dialog()
            return
            
        # Add all algorithms
        self.addAlgorithm(DemSlopeProcessing())
        self.addAlgorithm(StandardFloodAnalysis())
        self.addAlgorithm(FlashFloodAnalysis())
        self.addAlgorithm(RainfallDataDownloader())
    
    def id(self):
        return 'rain2flood'
    
    def name(self):
        return 'Rain to Flood Toolkit'
    
    def icon(self):
        return QIcon()