# Radar Tools v1.2

Plugin de QGIS que proporciona herramientas para procesar y visualizar datos de radares meteorológicos incluyendo RS120 y Furuno WR110.

## Descripción

Este plugin convierte archivos NetCDF del radar meteorológico RS120 y archivos H5 del radar Doppler Furuno WR110 a diferentes formatos y ofrece funcionalidades avanzadas para análisis de datos:

- **GeoTIFF**: Conversión a formato GeoTIFF con reproyección a WGS84 UTM Zona 17S (EPSG:32717)
- **GIF Animado**: Generación de animaciones a partir de series temporales de archivos NetCDF
- **Series Temporales**: Análisis de series temporales con operaciones estadísticas (suma, media, máximo, mínimo)
- **Calibración a Precipitación**: Calibra datos de reflectividad de radar a valores de precipitación (mm) usando estaciones meteorológicas
- **Furuno WR110**: Procesamiento de datos del radar Doppler Furuno WR110 con múltiples métodos de agregación

## Novedades en la versión 1.2

### Soporte para Radar Furuno WR110
- **Nuevo algoritmo**: Procesamiento completo de archivos H5 del radar Doppler Furuno WR110
- **Múltiples métodos de agregación**: 
  - Máximo (más conservador para eventos extremos)
  - Promedio (más realista para precipitación en superficie)
  - Promedio ponderado por elevación (mayor peso a elevaciones bajas)
  - Elevación más baja (datos cercanos a la superficie)
  - Compuesto vertical inteligente (combina elevaciones según distancia)
- **Compatible con archivos comprimidos**: Soporte para archivos .h5.gz
- **Procesamiento con GDAL**: No requiere h5py, usa bibliotecas incluidas en QGIS
- **Interpolación inteligente**: Rellena automáticamente pequeños vacíos en los datos
- **Umbrales configurables**: Control preciso sobre valores mínimos de precipitación

### Mejoras generales
- **Mejor manejo de errores**: Mensajes más informativos y recuperación automática
- **Paletas de colores mejoradas**: Visualización optimizada para datos de precipitación
- **Mayor robustez**: Mejor compatibilidad con diferentes formatos de archivos
- **Interfaz actualizada**: Diálogos informativos sobre dependencias y disponibilidad

## Características principales

### Conversión a GeoTIFF (RS120)

- Reproyección automática a WGS84 UTM Zona 17S (EPSG:32717)
- Umbral personalizable para valores NoData (por defecto 25 dBZ)
- Aplicación automática de paleta de colores para visualización de precipitación
- Carga automática de la capa resultante en QGIS
- Múltiples métodos de reproyección con fallback automático

### Procesamiento Furuno WR110

- **Extracción de datos RATE**: Procesamiento automático de datos de precipitación
- **Agregación multi-elevación**: Combina datos de diferentes ángulos de elevación
- **Interpolación espacial**: Rellena vacíos pequeños en los datos
- **Proyección automática**: Conversión a coordenadas UTM apropiadas
- **Paleta de precipitación**: Colores optimizados para valores en mm/h
- **Metadatos completos**: Información detallada del procesamiento

### Creación de GIF animado (RS120)

- Umbral personalizable para transparencia (por defecto 30 dBZ)
- Incorporación opcional de mapa base de OpenStreetMap
- Velocidad de animación ajustable
- Título personalizable
- Procesamiento por lotes de directorios con múltiples archivos NetCDF
- Descarga automática de mapas base con manejo inteligente de errores

### Series Temporales (RS120)

- Análisis de datos de radar en intervalos temporales definidos por el usuario
- Operaciones disponibles: suma, media, máximo y mínimo
- Ajuste automático de zona horaria (UTC a hora local)
- Umbral personalizable para valores NoData
- Generación de imágenes acumuladas o promedios para períodos específicos
- Procesamiento recursivo en subcarpetas

### Calibración a Precipitación (RS120)

- Integración de datos de estaciones meteorológicas con datos de radar
- Algoritmo de calibración basado en técnicas de interpolación espacial
- Consideración de efectos de elevación usando Modelos Digitales de Elevación (DEM)
- Generación de mapas de precipitación calibrados en milímetros (mm)
- Múltiples métodos de interpolación disponibles:
  - IDW (Inverse Distance Weighting) - método predeterminado
  - Linear, Cubic, Nearest (basados en SciPy)
  - Ordinary Kriging y Universal Kriging (requieren PyKrige)

## Instalación

### Requisitos previos

El plugin requiere las siguientes dependencias de Python:

#### Dependencias básicas (requeridas):
```bash
pip install numpy xarray rasterio matplotlib pillow requests scipy
```

#### Dependencias opcionales (para funcionalidades avanzadas):
```bash
pip install pykrige netCDF4 dask h5py pyproj
```

Para una instalación completa de todas las dependencias:
```bash
pip install numpy xarray rasterio matplotlib pillow requests scipy pykrige netCDF4 dask h5py pyproj
```

**Nota sobre Furuno WR110**: Esta funcionalidad usa GDAL (incluido en QGIS) y no requiere h5py obligatoriamente, pero se recomienda para mejor compatibilidad.

### Instalación del plugin

1. Descarga la última versión del plugin desde el repositorio
2. En QGIS, ve a "Complementos" > "Administrar e instalar complementos..."
3. Selecciona "Instalar a partir de ZIP"
4. Navega hasta el archivo ZIP descargado y selecciónalo
5. Haz clic en "Instalar complemento"

## Uso básico

### Conversión RS120 a GeoTIFF

1. En el menú principal de QGIS, selecciona "Radar Tools" > "Radar RS120 to GeoTIFF"
2. Selecciona el archivo NetCDF de entrada
3. Establece el umbral para valores NoData (opcional, predeterminado: 25 dBZ)
4. Selecciona la ubicación del archivo GeoTIFF de salida (opcional)
5. Haz clic en "Ejecutar"

### Procesamiento Furuno WR110

1. En el menú principal de QGIS, selecciona "Radar Tools" > "Furuno WR110 to GeoTIFF"
2. Selecciona el archivo H5 de entrada (puede ser .h5 o .h5.gz)
3. Configura el umbral de precipitación (predeterminado: 0.01 mm/h)
4. Selecciona el método de agregación de elevaciones:
   - **Máximo**: Conservador, captura eventos extremos
   - **Promedio**: Más realista para precipitación en superficie
   - **Promedio ponderado**: Da más peso a elevaciones bajas
   - **Elevación más baja**: Usa solo datos cercanos a la superficie
   - **Compuesto vertical**: Combina elevaciones según distancia al radar
5. Activa/desactiva la interpolación para llenar vacíos pequeños
6. Selecciona la carpeta de salida (opcional)
7. Haz clic en "Ejecutar"

### Creación de GIF animado (RS120)

1. En el menú principal de QGIS, selecciona "Radar Tools" > "Radar RS120 to GIF"
2. Selecciona el directorio que contiene los archivos NetCDF
3. Personaliza el título para el GIF (opcional)
4. Ajusta la duración por frame (opcional, predeterminado: 850 ms)
5. Establece el umbral de transparencia (opcional, predeterminado: 30 dBZ)
6. Activa o desactiva el uso del mapa base (opcional, predeterminado: activado)
7. Selecciona la ubicación del archivo GIF de salida (opcional)
8. Haz clic en "Ejecutar"

### Series Temporales (RS120)

1. En el menú principal de QGIS, selecciona "Radar Tools" > "Radar RS120 Series Temporales"
2. Selecciona la carpeta que contiene los archivos NetCDF
3. Define la fecha de inicio y fin para el análisis
4. Establece el intervalo en horas
5. Selecciona la operación estadística (suma, media, máximo, mínimo)
6. Ajusta el desplazamiento horario UTC (p.ej. -5 para Ecuador)
7. Define el umbral para valores NoData
8. Selecciona la carpeta de salida para los GeoTIFFs
9. Haz clic en "Ejecutar"

### Calibración a Precipitación (RS120)

1. En el menú principal de QGIS, selecciona "Radar Tools" > "Radar - Calibración a Precipitación"
2. Selecciona la imagen de radar (reflectividad dBZ)
3. Selecciona el Modelo Digital de Elevación (DEM)
4. Selecciona la capa de estaciones meteorológicas
5. Indica el campo de elevación y el campo de precipitación
6. Selecciona el método de interpolación (IDW recomendado)
7. Define el valor NoData para precipitación
8. Selecciona el archivo de salida para la precipitación calibrada
9. Haz clic en "Ejecutar"

## Especificaciones técnicas

### Formatos soportados

- **Entrada RS120**: .nc, .nc4, .cdf, .netcdf
- **Entrada Furuno WR110**: .h5, .hdf5, .h5.gz
- **Salida**: GeoTIFF (.tif), GIF animado (.gif)

### Proyecciones

- **Entrada**: WGS84 (EPSG:4326) para RS120, coordenadas polares para Furuno WR110
- **Salida**: WGS84 UTM Zona 17S (EPSG:32717)

### Resoluciones típicas

- **RS120**: Variable según configuración del radar
- **Furuno WR110**: 75 metros (configurable en metadatos)

## Solución de problemas

### Errores comunes

#### RS120
- **Error de reproyección**: El plugin intenta varios métodos de reproyección. Si todos fallan, se generará un archivo en coordenadas geográficas (WGS84).
- **Error al cargar archivos NetCDF**: Asegúrate de que los archivos tengan un formato compatible con el radar RS120.
- **Mapa base no disponible**: La descarga del mapa base requiere conexión a internet. Sin conexión, el plugin funcionará pero sin mapa base.

#### Furuno WR110
- **Error al leer archivo H5**: Verifica que el archivo no esté corrupto. El plugin soporta archivos comprimidos (.h5.gz).
- **Datos RATE no encontrados**: El plugin busca automáticamente en dataset1-5/data1. Si tu archivo tiene una estructura diferente, contacta al desarrollador.
- **Valores de precipitación muy altos/bajos**: Ajusta el umbral de precipitación según tus necesidades específicas.

#### General
- **Dependencias faltantes**: Si falta alguna biblioteca Python, el plugin mostrará un mensaje con instrucciones para instalarlas.
- **Error de memoria**: Para archivos muy grandes, considera procesar en lotes más pequeños.

### Compatibilidad

- **QGIS**: Probado en QGIS 3.16 y versiones posteriores
- **Python**: Requiere Python 3.6 o superior
- **Sistema operativo**: Windows, Linux, macOS

## Desarrollo

### Estructura del proyecto

```
radar_tools/
├── __init__.py
├── plugin.py
├── netcdf_to_geotiff_algorithm.py
├── netcdf_to_gif_algorithm.py
├── netcdf_time_series_algorithm.py
├── radar_calibration_algorithm.py
├── furuno_wr110_algorithm.py          # NUEVO en v1.2
├── about_dialog.py
├── icon.png
├── metadata.txt
├── LICENSE
└── README.md
```

### Cambios en la versión 1.2

- **Nuevo algoritmo**: `furuno_wr110_algorithm.py` para procesamiento de radar Doppler
- **Mejoras en manejo de errores**: Mejor recuperación ante fallos
- **Paletas de colores actualizadas**: Optimizadas para datos de precipitación
- **Interfaz mejorada**: Mensajes más informativos y claros
- **Compatibilidad extendida**: Soporte para más formatos de archivo

### Contribuciones

Las contribuciones son bienvenidas. Por favor:

1. Fork el repositorio
2. Crea una rama para tu feature (`git checkout -b feature/nueva-funcionalidad`)
3. Commit tus cambios (`git commit -am 'Añadir nueva funcionalidad'`)
4. Push a la rama (`git push origin feature/nueva-funcionalidad`)
5. Crea un Pull Request

Para reportar problemas, usa el [sistema de issues](https://github.com/franzpc/radar_rs120_tools/issues).

## Licencia

Este plugin está licenciado bajo la Licencia Pública General de GNU v2 o posterior.

## Autor y contacto

**Departamento de Ingeniería Civil**  
Universidad Técnica Particular de Loja  

**Desarrollador**: Franz Pucha Cofrep (@franzpc)  
**Contacto**: fapucha@utpl.edu.ec  
**Repositorio**: https://github.com/franzpc/radar_rs120_tools

## Agradecimientos

- Universidad Técnica Particular de Loja por el apoyo institucional
- Comunidad QGIS por las herramientas y documentación
- Contribuidores y usuarios que han proporcionado retroalimentación

---

**Versión**: 1.2  
**Fecha de actualización**: Mayo 2025  
**QGIS mínimo**: 3.34