# -*- coding: utf-8 -*-
import os

from qgis.PyQt import QtGui, QtWidgets
from qgis.PyQt.QtCore import QCoreApplication, Qt

class AboutDialog(QtWidgets.QDialog):
    def __init__(self, parent=None):
        """Constructor."""
        super(AboutDialog, self).__init__(parent)
        # Configurar el diálogo
        self.setWindowTitle(self.tr("Acerca de Radar Tools"))
        self.resize(450, 350)
        
        # Crear el layout
        layout = QtWidgets.QVBoxLayout()
        
        # Añadir título
        title_label = QtWidgets.QLabel(self.tr("Radar Tools"))
        title_font = title_label.font()
        title_font.setPointSize(16)
        title_font.setBold(True)
        title_label.setFont(title_font)
        title_label.setAlignment(Qt.AlignCenter)
        layout.addWidget(title_label)
        
        # Añadir versión
        version_label = QtWidgets.QLabel(self.tr("Versión 1.0"))
        version_label.setAlignment(Qt.AlignCenter)
        layout.addWidget(version_label)
        
        # Añadir espacio
        layout.addSpacing(20)
        
        # Añadir descripción
        description = self.tr(
            "Este plugin proporciona herramientas para procesar y analizar datos de radares "
            "meteorológicos incluyendo RS120 y Furuno WR110, con conversión a GeoTIFF, "
            "reproyección a WGS84 Zona 17S, creación de GIF animado, análisis de series "
            "temporales, calibración de reflectividad a precipitación y procesamiento de "
            "datos de radar Doppler Furuno WR110."
        )
        desc_label = QtWidgets.QLabel(description)
        desc_label.setWordWrap(True)
        layout.addWidget(desc_label)
        
        # Añadir espacio
        layout.addSpacing(20)
        
        # Añadir autor
        author_label = QtWidgets.QLabel(self.tr("Departamento de Ingeniería Civil"))
        author_label.setAlignment(Qt.AlignCenter)
        layout.addWidget(author_label)
        
        # Añadir institución
        institution_label = QtWidgets.QLabel(self.tr("Universidad Técnica Particular de Loja"))
        institution_label.setAlignment(Qt.AlignCenter)
        layout.addWidget(institution_label)
        
        # Añadir correo electrónico
        email_label = QtWidgets.QLabel(self.tr("Contacto: fapucha@utpl.edu.ec"))
        email_label.setAlignment(Qt.AlignCenter)
        layout.addWidget(email_label)
        
        # Añadir nombre del desarrollador
        layout.addSpacing(10)
        dev_label = QtWidgets.QLabel(self.tr("desarrollado por @franzpc"))
        dev_label.setAlignment(Qt.AlignCenter)
        layout.addWidget(dev_label)
        
        # Añadir espacio expansible
        layout.addStretch()
        
        # Añadir pie de licencia
        license_label = QtWidgets.QLabel(self.tr("Licenciado bajo GNU GPL v2 o posterior"))
        license_label.setAlignment(Qt.AlignCenter)
        license_font = license_label.font()
        license_font.setItalic(True)
        license_label.setFont(license_font)
        layout.addWidget(license_label)
        
        # Añadir botón Cerrar
        button_box = QtWidgets.QDialogButtonBox(QtWidgets.QDialogButtonBox.Close)
        button_box.rejected.connect(self.reject)
        layout.addWidget(button_box)
        
        # Establecer el layout
        self.setLayout(layout)
    
    def tr(self, string):
        return QCoreApplication.translate('AboutDialog', string)