# -*- coding: utf-8 -*-
"""
/***************************************************************************
 RSWaterQualityMapper
                                 A QGIS plugin
 RS Water Quality Mapper
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-09-25
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Haibin Su
        email                : haibin.su@tamuk.edu
 ***************************************************************************/

/***************************************************************************
 * *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation; either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 * *
 ***************************************************************************/
"""
import os.path
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

from .resources import *
from .RSWaterQualityMapper_dialog import (
    WaterQualityEnsembleModelDialog, SpectralIndexDialog, SpectralClusterDialog, 
    EnsembleCalibrationDialog, DecisonTreeDialog, ApplyEnsembleModelDialog, 
    WaterQualityIndicesDialog, WaterMaskDialog, PointRasterSamplerDialog, 
    AcoliteDialog, TSICalculatorDialog, RegressionAnalysisDialog, RandomForestRegressionDialog, 
    SvmRegressionDialog
)

class RSWaterQualityMapper:
    def __init__(self, iface):
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)
        locale = QSettings().value('locale/userLocale', '')[0:2]
        locale_path = os.path.join(
            self.plugin_dir, 'i18n', f'RSWaterQualityMapper_{locale}.qm')
        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)
            
        self.actions = []
        self.menu = self.tr(u'&RS-WaterQuality Mapper')
        self.toolbar = self.iface.addToolBar(u'RSWaterQualityMapper')
        self.toolbar.setObjectName(u'RSWaterQualityMapper')

        # Initialize flags for dialogs
        self.dialog_flags = {
            'all': False, 'si': False, 'ep': False, 'sc': False, 
            'ec': False, 'dt': False, 'ap': False, 'wqi': False, 
            'wsk': False, 'prs': False, 'acolite': False, 'tsi': False, 
            'bimodal': False, 'rf_regression': False, 
            'svm_regression': False, 'ndwi': False
        }
        self.dialogs = {}

    def tr(self, message):
        return QCoreApplication.translate('RSWaterQualityMapper', message)

    def add_action(self, icon_path, text, callback, parent=None):
        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        self.iface.addPluginToMenu(self.menu, action)
        self.toolbar.addAction(action)
        self.actions.append(action)
        return action

    def initGui(self):
        icon_path = ':/plugins/RSWaterQualityMapper/icon.png'
        
        # Define menu structure
        menu_items = {
            " 1. Generate Water Mask": self.GenerateWaterMask,
            " 2. Atmospheric Correction with ACOLITE": self.run_acolite,
            " 3. Calculate Spectral Indices from Image": self.CalculateWaterQualityIndices,
            " 4. Calculate Trophic State Index": self.run_tsi_calculator, 
            " 5. Matching Pixel Values with Water Sample Points": self.run_point_raster_sampler, 
            " 6. Calculate Water Quality Spectral Indices for Sample Points": self.CalSpecIndex,
            " 7. Empirical Modeling": self.run_regression_analysis,
            " 8. Random Forest Regression Analysis": self.run_rf_regression,
            " 9. SVM Regression Analysis": self.run_svm_regression,
            "10. Spectral Clustering of Water Sample Points": self.SpectralClustering,
            "11. Ensemble Component Models Calibration and Selection": self.EnsembleModelsCalibration,
            "12. Spectral-Space Partition and Ensemble Model Generation": self.SpectralSpacePartition,
            "13. Apply Ensemble Model to an Image": self.ApplyEnsembleModel,
            "14. Integrated Ensemble Modeling": self.WaterQualityEnsembleModel
        }
        
        for text, callback in menu_items.items():
            self.add_action(
                icon_path,
                text=self.tr(text),
                callback=callback,
                parent=self.iface.mainWindow()
            )

    def unload(self):
        """Removes the plugin menu item and toolbar."""
        # Disconnect all actions and remove them from the menu and toolbar
        for action in self.actions:
            # Remove from the menu
            self.iface.removePluginMenu(self.tr(u'&RS-WaterQuality Mapper'), action)
            # Remove from the toolbar
            if hasattr(self, 'toolbar'):
                self.toolbar.removeAction(action)
            # Disconnect signals to prevent dangling references
            try:
                action.triggered.disconnect()
            except (TypeError, RuntimeError):
                # This can happen if the connection was already broken or the object was deleted
                pass

        # Now that the toolbar is empty, it can be safely removed.
        # Deleting the object is the most compatible way.
        if hasattr(self, 'toolbar'):
            del self.toolbar

        # Clear the lists to release references and prevent state from leaking across reloads
        self.actions.clear()
        self.dialogs.clear()
        self.dialog_flags.clear()

    def run_dialog(self, flag_key, dialog_class):
        """Generic function to run a dialog."""
        # This function is for dialogs that block QGIS until closed.
        if not self.dialog_flags.get(flag_key):
            self.dialogs[flag_key] = dialog_class(self.iface.mainWindow())
            self.dialog_flags[flag_key] = True
        
        # Use exec_() to run as a modal dialog.
        self.dialogs[flag_key].exec_()

    def run_acolite(self): self.run_dialog('acolite', AcoliteDialog)
    def GenerateWaterMask(self): self.run_dialog('wsk', WaterMaskDialog)
    def CalculateWaterQualityIndices(self): self.run_dialog('wqi', WaterQualityIndicesDialog)
    def run_tsi_calculator(self): self.run_dialog('tsi', TSICalculatorDialog)
    def run_point_raster_sampler(self): self.run_dialog('prs', PointRasterSamplerDialog)
    def CalSpecIndex(self): self.run_dialog('si', SpectralIndexDialog)
    def run_regression_analysis(self): self.run_dialog('ep', RegressionAnalysisDialog)
    def run_rf_regression(self): self.run_dialog('rf_regression', RandomForestRegressionDialog)
    def run_svm_regression(self): self.run_dialog('svm_regression', SvmRegressionDialog)
    def SpectralClustering(self): self.run_dialog('sc', SpectralClusterDialog)
    def EnsembleModelsCalibration(self): self.run_dialog('ec', EnsembleCalibrationDialog)
    def SpectralSpacePartition(self): self.run_dialog('dt', DecisonTreeDialog)
    def ApplyEnsembleModel(self): self.run_dialog('ap', ApplyEnsembleModelDialog)
    def WaterQualityEnsembleModel(self): self.run_dialog('all', WaterQualityEnsembleModelDialog)

    